/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.text.pattern;

import de.unkrig.commons.nullanalysis.Nullable;
import de.unkrig.commons.text.pattern.Glob;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class IncludeExclude
extends Glob {
    public static final Glob DEFAULT_EXCLUDES;
    private final List<ModeAndGlob> mags = new ArrayList<ModeAndGlob>();

    @Deprecated
    public void appendInclude(Glob include) {
        this.addInclude(include, false);
    }

    @Deprecated
    public void prependInclude(Glob include) {
        this.addInclude(include, true);
    }

    public void addInclude(Glob include, boolean override) {
        ModeAndGlob mag = new ModeAndGlob(Mode.INCLUDE, include);
        if (override) {
            this.mags.add(0, mag);
        } else {
            this.mags.add(mag);
        }
    }

    @Deprecated
    public void appendExclude(Glob exclude) {
        this.addExclude(exclude, false);
    }

    @Deprecated
    public void prependExclude(Glob exclude) {
        this.addExclude(exclude, true);
    }

    public void addExclude(Glob exclude, boolean override) {
        ModeAndGlob mag = new ModeAndGlob(Mode.EXCLUDE, exclude);
        if (override) {
            this.mags.add(0, mag);
        } else {
            this.mags.add(mag);
        }
    }

    @Override
    public boolean matches(String subject) {
        if (this.mags.isEmpty()) {
            return true;
        }
        boolean isContainer = subject.endsWith("!") || subject.endsWith("/");
        for (ModeAndGlob mag : this.mags) {
            if (mag.mode == Mode.INCLUDE) {
                if (!mag.glob.matches(subject)) continue;
                return true;
            }
            if (isContainer || !mag.glob.matches(subject)) continue;
            return false;
        }
        return this.mags.get((int)(this.mags.size() - 1)).mode == Mode.EXCLUDE;
    }

    @Override
    @Nullable
    public String replace(String subject) {
        boolean hadInclude = false;
        block4: for (ModeAndGlob map : this.mags) {
            switch (map.mode) {
                case INCLUDE: {
                    String tmp = map.glob.replace(subject);
                    if (tmp == null) continue block4;
                    subject = tmp;
                    hadInclude = true;
                    continue block4;
                }
                case EXCLUDE: {
                    if (!map.glob.matches(subject)) continue block4;
                    return hadInclude ? subject : null;
                }
            }
            throw new IllegalStateException();
        }
        return hadInclude ? subject : null;
    }

    public String toString() {
        Iterator<ModeAndGlob> it = this.mags.iterator();
        if (!it.hasNext()) {
            return "(empty)";
        }
        StringBuilder sb = new StringBuilder();
        ModeAndGlob mag = it.next();
        if (mag.mode == Mode.EXCLUDE) {
            sb.append('~');
        }
        sb.append(mag.glob);
        while (it.hasNext()) {
            mag = it.next();
            sb.append(mag.mode == Mode.INCLUDE ? (char)',' : '~');
            sb.append(mag.glob);
        }
        return sb.toString();
    }

    static {
        IncludeExclude ie = new IncludeExclude();
        ie.appendExclude(Glob.compile(".svn", 0x20000000));
        ie.appendExclude(Glob.compile("***/.svn", 0x20000000));
        ie.appendExclude(Glob.compile("***!.svn", 0x20000000));
        ie.appendExclude(Glob.compile("CVS", 0x20000000));
        ie.appendExclude(Glob.compile("***/CVS", 0x20000000));
        ie.appendExclude(Glob.compile("***!CVS", 0x20000000));
        DEFAULT_EXCLUDES = ie;
    }

    private static class ModeAndGlob {
        final Mode mode;
        final Glob glob;

        ModeAndGlob(Mode mode, Glob glob) {
            this.mode = mode;
            this.glob = glob;
        }
    }

    private static enum Mode {
        INCLUDE,
        EXCLUDE;

    }
}

