/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.text.json;

import de.unkrig.commons.text.json.Json;
import java.io.PrintWriter;

public class JsonUnparseVisitor
implements Json.ValueVisitor {
    private static final String INDENT = "  ";
    private final PrintWriter pw;
    private final String prefix;

    public JsonUnparseVisitor(PrintWriter pw, String prefix) {
        this.pw = pw;
        this.prefix = prefix;
    }

    @Override
    public void visit(Json.StrinG string) {
        this.pw.write(34);
        for (int i = 0; i < string.text.length(); ++i) {
            char c = string.text.charAt(i);
            int idx = "\"\\/\b\f\n\r\t".indexOf(c);
            if (idx != -1) {
                this.pw.write(92);
                this.pw.write("\"\\/bfnrt".charAt(idx));
                continue;
            }
            if (Character.isISOControl(c)) {
                this.pw.write(92);
                this.pw.write(117);
                this.pw.write(Character.forDigit(c >> 12, 10));
                this.pw.write(Character.forDigit(c >> 8 & 0xF, 10));
                this.pw.write(Character.forDigit(c >> 4 & 0xF, 10));
                this.pw.write(Character.forDigit(c & 0xF, 10));
                continue;
            }
            this.pw.write(c);
        }
        this.pw.write(34);
    }

    @Override
    public void visit(Json.NumbeR number) {
        this.pw.print(number.value);
    }

    @Override
    public void visit(Json.ObjecT object) {
        if (object.members.isEmpty()) {
            this.pw.print("{}");
            return;
        }
        String prefix2 = this.prefix + INDENT;
        JsonUnparseVisitor visitor2 = new JsonUnparseVisitor(this.pw, prefix2);
        this.pw.println('{');
        boolean first = true;
        for (Json.Member member : object.members) {
            if (first) {
                first = false;
            } else {
                this.pw.println(',');
            }
            this.pw.print(prefix2);
            this.visit(member.name);
            this.pw.print(" : ");
            member.value.accept(visitor2);
        }
        this.pw.println();
        this.pw.print(this.prefix + '}');
    }

    @Override
    public void visit(Json.Array array) {
        if (array.elements.isEmpty()) {
            this.pw.print("[]");
            return;
        }
        String prefix2 = this.prefix + INDENT;
        JsonUnparseVisitor visitor2 = new JsonUnparseVisitor(this.pw, prefix2);
        this.pw.println('[');
        boolean first = true;
        for (Json.Value value : array.elements) {
            if (first) {
                first = false;
            } else {
                this.pw.println(',');
            }
            this.pw.print(prefix2);
            value.accept(visitor2);
        }
        this.pw.println();
        this.pw.print(this.prefix + ']');
    }

    @Override
    public void visit(Json.True truE) {
        this.pw.print("true");
    }

    @Override
    public void visit(Json.False falsE) {
        this.pw.print("false");
    }

    @Override
    public void visit(Json.Null nulL) {
        this.pw.print("null");
    }
}

