/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.lang.security;

import de.unkrig.commons.lang.AssertionUtil;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.util.Arrays;

public final class SecureCharsets {
    private SecureCharsets() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static char[] secureDecode(byte[] ba, Charset cs) {
        if (ba.length == 0) {
            return new char[0];
        }
        try {
            CharsetDecoder cd = cs.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
            char[] ca = new char[ba.length * (int)Math.ceil(cd.maxCharsPerByte())];
            ByteBuffer bb = ByteBuffer.wrap(ba);
            CharBuffer cb = CharBuffer.wrap(ca);
            try {
                cd.reset();
                CoderResult cr = cd.decode(bb, cb, true);
                if (!cr.isUnderflow()) {
                    cr.throwException();
                }
                if (!(cr = cd.flush(cb)).isUnderflow()) {
                    cr.throwException();
                }
            }
            catch (CharacterCodingException cce) {
                throw new AssertionError((Object)cce);
            }
            if (cb.position() != ca.length) {
                char[] tmp = ca;
                ca = Arrays.copyOf(ca, cb.position());
                Arrays.fill(tmp, '\u0000');
            }
            char[] cArray = ca;
            return cArray;
        }
        finally {
            Arrays.fill(ba, (byte)0);
        }
    }

    public static byte[] secureEncode(char[] ca, Charset charset) {
        CharsetEncoder ce = charset.newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        byte[] ba = new byte[ca.length * (int)Math.ceil(ce.maxBytesPerChar())];
        ByteBuffer bb = ByteBuffer.wrap(ba);
        CharBuffer cb = CharBuffer.wrap(ca);
        ce.reset();
        try {
            CoderResult cr = ce.encode(cb, bb, true);
            if (!cr.isUnderflow()) {
                cr.throwException();
            }
            if (!(cr = ce.flush(bb)).isUnderflow()) {
                cr.throwException();
            }
        }
        catch (CharacterCodingException cce) {
            throw new AssertionError((Object)cce);
        }
        if (bb.position() != ba.length) {
            byte[] tmp = ba;
            ba = Arrays.copyOf(ba, bb.position());
            Arrays.fill(tmp, (byte)0);
        }
        return ba;
    }

    static {
        AssertionUtil.enableAssertionsForThisClass();
    }
}

