/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.antology.task;

import de.unkrig.antology.AbstractUrlConnectionTask;
import de.unkrig.antology.ParametrizedHeaderValue;
import de.unkrig.antology.type.JsonAsProperties;
import de.unkrig.antology.type.Subelement;
import de.unkrig.antology.util.Compat;
import de.unkrig.commons.io.IoUtil;
import de.unkrig.commons.lang.AssertionUtil;
import de.unkrig.commons.nullanalysis.Nullable;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.filters.util.ChainReaderHelper;
import org.apache.tools.ant.types.FilterChain;

public class UrlConnectionTask
extends AbstractUrlConnectionTask {
    private static final Logger LOGGER;
    public static final Charset HTTP_DEFAULT_CHARSET;
    @Nullable
    private Input input;
    @Nullable
    private Output output;
    @Nullable
    private String httpRequestMethod;

    public void setHttpRequestMethod(String method) {
        this.httpRequestMethod = method;
    }

    public void addConfiguredOutput(OutputElement oe) {
        if (this.output != null) {
            throw new BuildException("Only one '<output>' subelement allowed");
        }
        if (oe.output == null) {
            throw new BuildException("One of 'value=\"...\"', 'file=\"...\"', '<multipartFormData>', '<applicationXWwwFormUrlencoded>' or element text must be defined for '<output>'");
        }
        this.output = oe.output;
    }

    public void addConfiguredInput(InputElement ie) {
        if (this.input != null) {
            throw new BuildException("Only one '<input>' subelement allowed");
        }
        this.input = ie.getInput();
    }

    public void execute() throws BuildException {
        try {
            this.execute2();
        }
        catch (BuildException be) {
            throw be;
        }
        catch (Exception e) {
            throw new BuildException(this.getTaskName() + ": " + e.getMessage(), (Throwable)e);
        }
    }

    private void execute2() throws IOException {
        URLConnection conn = this.openConnection();
        for (int attempt = 0; attempt < 10; ++attempt) {
            URL redirectLocation;
            this.log("conn=" + conn, 4);
            this.configureUrlConnection(conn);
            if (this.input != null) {
                conn.setDoInput(true);
            }
            if (this.output != null) {
                conn.setDoOutput(true);
            }
            this.log("conn=" + conn, 4);
            if (conn instanceof HttpURLConnection) {
                redirectLocation = this.execute3((HttpURLConnection)conn);
                if (redirectLocation == null) {
                    return;
                }
            } else {
                this.execute3(conn);
                return;
            }
            conn = this.openConnection(redirectLocation);
        }
        throw new IOException("Giving up after 10 REDIRECTs (last location was '" + conn + "')");
    }

    private void execute3(URLConnection conn) throws IOException {
        if (this.output != null) {
            this.output.write(conn);
        }
        if (this.input != null) {
            this.input.read(conn);
        }
    }

    @Nullable
    private URL execute3(HttpURLConnection httpConn) throws IOException {
        this.log("output=" + this.output, 4);
        this.configureHttpUrlConnection(httpConn);
        if (this.httpRequestMethod != null) {
            httpConn.setRequestMethod(this.httpRequestMethod);
        }
        this.log("httpConn=" + httpConn, 4);
        long now = System.currentTimeMillis();
        try {
            List<String> headerFieldValues;
            String headerFieldName;
            this.log("Request header:", 4);
            for (Map.Entry<String, List<String>> e : httpConn.getRequestProperties().entrySet()) {
                headerFieldName = e.getKey();
                headerFieldValues = e.getValue();
                for (String headerFieldValue : headerFieldValues) {
                    this.log("  " + headerFieldName + ": " + headerFieldValue, 4);
                }
            }
            Output output = this.output;
            if (output != null) {
                this.log("Wrinting request body...", 4);
                output.write(httpConn);
                this.log("... done.", 4);
            }
            this.log("Waiting for response header...", 4);
            long l = System.currentTimeMillis();
            try {
                httpConn.getResponseCode();
            }
            catch (IOException ioe) {
                this.log(ioe.toString() + " after " + (System.currentTimeMillis() - l) + " ms", 4);
                throw ioe;
            }
            catch (RuntimeException re) {
                this.log(re.toString() + " after " + (System.currentTimeMillis() - l) + " ms", 4);
                throw re;
            }
            this.log("... response header received after " + (System.currentTimeMillis() - l) + " ms.", 4);
            this.log("Response header:", 4);
            for (Map.Entry<String, List<String>> e : httpConn.getHeaderFields().entrySet()) {
                headerFieldName = e.getKey();
                headerFieldValues = e.getValue();
                for (String headerFieldValue : headerFieldValues) {
                    this.log("  " + headerFieldName + ": " + headerFieldValue, 4);
                }
            }
            int responseCode = httpConn.getResponseCode();
            if (this.httpFollowRedirects2 && responseCode >= 300 && responseCode < 400) {
                URL redirectionLocationUrl;
                String redirectionLocation = httpConn.getHeaderField("Location");
                if (redirectionLocation == null) {
                    throw new IOException("Response with code " + responseCode + " lacks the 'Location:' header field");
                }
                try {
                    redirectionLocationUrl = new URL(httpConn.getURL(), redirectionLocation);
                }
                catch (MalformedURLException mue) {
                    throw new IOException("Invalid redirection location \"" + redirectionLocation + "\"", mue);
                }
                if (responseCode == 303) {
                    URLConnection conn = redirectionLocationUrl.openConnection();
                    if (this.input != null) {
                        this.input.read(conn);
                    }
                    return null;
                }
                return redirectionLocationUrl;
            }
            if (responseCode < 200 || responseCode >= 400) {
                throw new IOException("HTTP request failed");
            }
            Input input = this.input;
            if (input != null) {
                this.log("Reading response body...", 4);
                input.read(httpConn);
                this.log("... done.", 4);
            }
            return null;
        }
        catch (BuildException be) {
            throw be;
        }
        catch (Exception e) {
            this.log(e, 0);
            InputStream errorStream = httpConn.getErrorStream();
            if (errorStream != null) {
                String line;
                BufferedReader br = new BufferedReader(new InputStreamReader(errorStream, HTTP_DEFAULT_CHARSET));
                while ((line = br.readLine()) != null) {
                    this.log(line, 4);
                }
            }
            throw new IOException("After " + (System.currentTimeMillis() - now) + " milliseconds: " + httpConn.getURL().toString() + ", response code=" + httpConn.getResponseCode() + ", response message=" + httpConn.getResponseMessage() + (e.getMessage() == null ? "" : ": " + e.getMessage()), e);
        }
    }

    private static Charset getConnectionCharset(URLConnection urlConnection) {
        String contentType = urlConnection.getContentType();
        if (contentType != null) {
            LOGGER.log(Level.FINE, "''{0}'': Request content type is ''{1}''", new Object[]{urlConnection, contentType});
            String charsetToken = new ParametrizedHeaderValue(contentType).getParameter("charset");
            if (charsetToken != null) {
                LOGGER.log(Level.FINE, "''{0}'': Charset is ''{1}''", new Object[]{urlConnection, charsetToken});
                try {
                    return Charset.forName(charsetToken);
                }
                catch (Exception e) {
                    LOGGER.log(Level.FINE, "''{0}'': Invalid charset ''{1}''", new Object[]{urlConnection, charsetToken});
                }
            }
        }
        LOGGER.log(Level.FINE, "''{0}'': Assuming default charset ''{1}''", new Object[]{urlConnection, HTTP_DEFAULT_CHARSET});
        return HTTP_DEFAULT_CHARSET;
    }

    static {
        AssertionUtil.enableAssertionsForThisClass();
        LOGGER = Logger.getLogger(UrlConnectionTask.class.getName());
        HTTP_DEFAULT_CHARSET = Charset.forName("ISO-8859-1");
    }

    public static class MultipartFormDataField
    extends ProjectComponent {
        @Nullable
        private String name;
        @Nullable
        private String fileName;
        @Nullable
        private Writable value;
        private final List<Subelement.Name_Value> headers = new ArrayList<Subelement.Name_Value>();

        public void setName(String name) {
            this.name = name;
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public void setValue(final String text) {
            if (this.value != null) {
                throw new BuildException("'value=\"...\"' and 'file=\"...\"' are mutually exclusive");
            }
            this.value = new Writable(){

                @Override
                public void write(OutputStream os) throws IOException {
                    os.write(text.getBytes());
                }

                public String toString() {
                    return '\"' + text + '\"';
                }
            };
        }

        public void setFile(final File file) {
            if (this.value != null) {
                throw new BuildException("'value=\"...\"' and 'file=\"...\"' are mutually exclusive");
            }
            this.value = new Writable(){

                @Override
                public void write(OutputStream os) throws IOException {
                    IoUtil.copy(file, os, false);
                }

                public String toString() {
                    return file.toString();
                }
            };
        }

        public void addConfiguredHeader(Subelement.Name_Value header) {
            this.headers.add(header);
        }

        public String toString() {
            return "name='" + this.name + "', fileName='" + this.fileName + "', value=" + this.value + ", headers=" + this.headers;
        }
    }

    public static interface Writable {
        public void write(OutputStream var1) throws IOException;
    }

    public static interface Output {
        public void write(URLConnection var1) throws IOException;
    }

    public static interface Input {
        public void read(URLConnection var1) throws IOException;
    }

    public static final class InputElement
    extends ProjectComponent {
        @Nullable
        private Input input;
        private final Vector<FilterChain> filterChains = new Vector();
        private Charset charset = Charset.defaultCharset();
        private boolean append;

        public void setDiscard(boolean discard) {
            if (!discard) {
                return;
            }
            this.setInput(new Input(){

                @Override
                public void read(URLConnection conn) throws IOException {
                    InputStream is = conn.getInputStream();
                    assert (is != null);
                    if (InputElement.this.filterChains.isEmpty()) {
                        is.skip(Long.MAX_VALUE);
                    } else {
                        InputElement.this.wrapInFilterChains(new InputStreamReader(is, UrlConnectionTask.getConnectionCharset(conn))).skip(Long.MAX_VALUE);
                    }
                }
            });
        }

        public void setStdout(boolean stdout) {
            if (!stdout) {
                return;
            }
            this.setInput(new OutputStreamInput(System.out));
        }

        public void setStderr(boolean stderr) {
            if (!stderr) {
                return;
            }
            this.setInput(new OutputStreamInput(System.err));
        }

        public void setFile(final File file) {
            this.setInput(new Input(){

                @Override
                public void read(URLConnection conn) throws IOException {
                    InputStream is = conn.getInputStream();
                    assert (is != null);
                    if (InputElement.this.filterChains.isEmpty()) {
                        IoUtil.copy(is, true, file, InputElement.this.append);
                    } else {
                        IoUtil.copy(InputElement.this.wrapInFilterChains(new InputStreamReader(is, UrlConnectionTask.getConnectionCharset(conn))), true, file, InputElement.this.append, InputElement.this.charset);
                    }
                }
            });
        }

        public void setAppend(boolean value) {
            this.append = value;
        }

        public void setProperty(final String propertyName) {
            this.setInput(new Input(){

                @Override
                public void read(URLConnection conn) throws IOException {
                    InputStream is = conn.getInputStream();
                    assert (is != null);
                    StringWriter sw = new StringWriter();
                    IoUtil.copy(InputElement.this.wrapInFilterChains(new InputStreamReader(is, UrlConnectionTask.getConnectionCharset(conn))), true, sw, false);
                    InputElement.this.getProject().setProperty(propertyName, sw.toString());
                }
            });
        }

        public void addConfiguredJsonAsProperties(final JsonAsProperties jsonAsProperties) {
            this.setInput(new Input(){

                @Override
                public void read(URLConnection conn) throws IOException {
                    InputStream is = conn.getInputStream();
                    assert (is != null);
                    try {
                        jsonAsProperties.execute(new InputStreamReader(is, UrlConnectionTask.getConnectionCharset(conn)));
                    }
                    catch (Exception e) {
                        throw new BuildException("Parsing JSON input: " + e, (Throwable)e);
                    }
                }
            });
        }

        public void addConfigured(FilterChain filterChain) {
            this.filterChains.add(filterChain);
        }

        public void setEncoding(String encoding) {
            this.charset = Charset.forName(encoding);
        }

        private void setInput(Input input) {
            if (this.input != null) {
                throw new BuildException("Only one of 'discard=true', 'stdout=true', 'stderr=true', 'file=...', 'property=...' and '<jsonAsProperties>' allowed");
            }
            this.input = input;
        }

        private Input getInput() {
            Input input = this.input;
            if (input == null) {
                throw new BuildException("Exactly one of 'discard=true', 'stdout=true', 'stderr=true', 'file=...', 'property=...' and '<jsonAsProperties>' must be configured");
            }
            return input;
        }

        private Reader wrapInFilterChains(Reader r) {
            ChainReaderHelper crh = new ChainReaderHelper();
            crh.setBufferSize(8192);
            crh.setPrimaryReader(r);
            crh.setFilterChains(this.filterChains);
            return new BufferedReader(Compat.getAssembledReader(crh));
        }

        private class OutputStreamInput
        implements Input {
            private final OutputStream out;

            OutputStreamInput(OutputStream out) {
                this.out = out;
            }

            @Override
            public void read(URLConnection conn) throws IOException {
                InputStream is = conn.getInputStream();
                assert (is != null);
                if (InputElement.this.filterChains.isEmpty()) {
                    IoUtil.copy(is, true, this.out, false);
                    this.out.flush();
                } else {
                    OutputStreamWriter w = new OutputStreamWriter(this.out);
                    IoUtil.copy(InputElement.this.wrapInFilterChains(new InputStreamReader(is, UrlConnectionTask.getConnectionCharset(conn))), true, w, false);
                    ((Writer)w).flush();
                }
            }
        }
    }

    public static class OutputElement
    extends ProjectComponent {
        @Nullable
        private Output output;
        private Charset charset = Charset.defaultCharset();

        public void setValue(final String text) {
            this.setOutput(new Output(){

                @Override
                public void write(URLConnection conn) throws IOException {
                    OutputStream os = conn.getOutputStream();
                    assert (os != null);
                    os.write(text.getBytes(OutputElement.this.charset));
                }

                public String toString() {
                    return "Value '" + text + "'";
                }
            });
        }

        public void setEncoding(String charsetName) {
            this.charset = Charset.forName(charsetName);
        }

        public void setFile(final File file) {
            this.setOutput(new Output(){

                @Override
                public void write(URLConnection conn) throws IOException {
                    OutputStream os = conn.getOutputStream();
                    assert (os != null);
                    IoUtil.copy(file, os, true);
                }

                public String toString() {
                    return "File '" + file + "'";
                }
            });
        }

        public void addConfiguredMultipartFormData(MultipartFormDataField field) {
            class MultipartFormDataOutput
            extends ProjectComponent
            implements Output {
                final List<MultipartFormDataField> fields = new ArrayList<MultipartFormDataField>();

                MultipartFormDataOutput() {
                }

                @Override
                public void write(URLConnection conn) throws IOException {
                    String boundary;
                    List<String> values = conn.getRequestProperties().get("Content-Type");
                    if (values != null) {
                        if (values.size() != 1) {
                            throw new BuildException("More than one 'Content-Type' header");
                        }
                        String value = values.get(0);
                        assert (value != null);
                        ParametrizedHeaderValue phv = new ParametrizedHeaderValue(value);
                        if (!"multipart/form-data".equalsIgnoreCase(phv.getToken())) {
                            throw new BuildException("Invalid content type '" + value + "'");
                        }
                        String p = phv.getParameter("boundary");
                        if (p == null) {
                            throw new BuildException("Content type '" + value + "' lacks 'boundary' parameter");
                        }
                        boundary = p;
                    } else {
                        StringBuilder sb = new StringBuilder();
                        for (int i = 0; i < 10; ++i) {
                            sb.append((char)(97 + new Random().nextInt(26)));
                        }
                        boundary = sb.toString();
                        conn.addRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
                    }
                    OutputStream os = conn.getOutputStream();
                    this.log("fields=" + this.fields, 4);
                    for (MultipartFormDataField field : this.fields) {
                        Writable value = field.value;
                        assert (value != null);
                        this.log("field=" + (Object)((Object)field), 4);
                        os.write(("\r\n--" + boundary + "\r\n").getBytes());
                        String s = "Content-Disposition: form-data";
                        if (field.name != null) {
                            s = s + "; name=\"" + field.name + "\"";
                        }
                        if (field.fileName != null) {
                            s = s + "; filename=\"" + field.fileName + "\"";
                        }
                        s = s + "\r\n";
                        os.write(s.getBytes());
                        for (Subelement.Name_Value header : field.headers) {
                            os.write((header.name + ": " + header.value + "\r\n").getBytes());
                        }
                        os.write("\r\n".getBytes());
                        this.log("field.value=" + value, 4);
                        value.write(os);
                    }
                    os.write(("\r\n--" + boundary + "--\r\n").getBytes());
                }

                public String toString() {
                    return "multipart/form-data: " + this.fields;
                }
            }
            MultipartFormDataOutput mfdo;
            String name = field.name;
            if (name == null) {
                throw new BuildException("'multipart/form-data' fields lacks name");
            }
            if (field.value == null) {
                throw new BuildException("'multipart/form-data' fields '" + name + "' lacks value");
            }
            if (this.output instanceof MultipartFormDataOutput) {
                mfdo = (MultipartFormDataOutput)this.output;
                assert (mfdo != null);
            } else {
                mfdo = new MultipartFormDataOutput();
                mfdo.setProject(this.getProject());
                this.setOutput(mfdo);
            }
            mfdo.fields.add(field);
        }

        public void addConfiguredApplicationXWwwFormUrlencoded(Subelement.Name_Value field) {
            class ApplicationXWwwFormUrlencodedOutput
            implements Output {
                final List<Subelement.Name_Value> fields = new ArrayList<Subelement.Name_Value>();

                ApplicationXWwwFormUrlencodedOutput() {
                }

                @Override
                public void write(URLConnection conn) throws IOException {
                    List<String> values = conn.getRequestProperties().get("Content-Type");
                    if (values != null) {
                        if (values.size() != 1) {
                            throw new BuildException("More than one 'Content-Type' header");
                        }
                        String value = values.get(0);
                        assert (value != null);
                        ParametrizedHeaderValue phv = new ParametrizedHeaderValue(value);
                        if (!"application/x-www-form-urlencoded".equalsIgnoreCase(phv.getToken())) {
                            throw new BuildException("Invalid content type '" + phv.getToken() + "'");
                        }
                    } else {
                        conn.addRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                    }
                    OutputStream os = conn.getOutputStream();
                    boolean first = true;
                    for (Subelement.Name_Value field : this.fields) {
                        if (first) {
                            first = false;
                        } else {
                            os.write(38);
                        }
                        os.write(URLEncoder.encode(field.name, "UTF-8").getBytes());
                        os.write(61);
                        os.write(URLEncoder.encode(field.value, "UTF-8").getBytes());
                    }
                }

                public String toString() {
                    return "application/x-www-form-urlencoded: " + this.fields;
                }
            }
            ApplicationXWwwFormUrlencodedOutput axwfuo;
            if (this.output instanceof ApplicationXWwwFormUrlencodedOutput) {
                axwfuo = (ApplicationXWwwFormUrlencodedOutput)this.output;
                assert (axwfuo != null);
            } else {
                axwfuo = new ApplicationXWwwFormUrlencodedOutput();
                this.setOutput(axwfuo);
            }
            axwfuo.fields.add(field);
        }

        public void addText(String text) {
            if (!(text = text.trim()).isEmpty()) {
                this.setValue(this.getProject().replaceProperties(text));
            }
        }

        private void setOutput(Output output) {
            if (this.output != null) {
                throw new BuildException("Only one of 'value=...', 'file=...', '<multipartFormData>', '<applicationXWwwFormUrlencoded>' or element text must be defined");
            }
            this.output = output;
        }
    }
}

