/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.antology.task;

import de.unkrig.commons.lang.AssertionUtil;
import de.unkrig.commons.lang.ExceptionUtil;
import de.unkrig.commons.nullanalysis.NotNullByDefault;
import de.unkrig.commons.nullanalysis.Nullable;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class PropertyXml2Task
extends Task {
    @Nullable
    private File file;
    private String prefix = "";
    private static final Pattern PATTERN;

    public void setFile(File file) {
        this.file = file;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void execute() {
        try {
            this.execute2();
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    private void execute2() throws ParserConfigurationException, TransformerException {
        Hashtable allProperties = this.getProject().getProperties();
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        documentBuilder.setEntityResolver(new EntityResolver(){

            @Override
            @NotNullByDefault(value=false)
            public InputSource resolveEntity(String publicId, String systemId) {
                return new InputSource("((" + publicId + "||" + systemId + "))");
            }
        });
        PropertyXml2Task.createSubelements(allProperties, this.prefix, document, document);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        DOMSource source = new DOMSource(document);
        StreamResult result = this.file != null ? new StreamResult(this.file) : new StreamResult(System.out);
        transformer.transform(source, result);
    }

    private static Element createElement(Map<String, Object> allProperties, String prefix, Document document) {
        Element element;
        document.createElement("company");
        String elementName = null;
        HashMap<String, String> attributes = new HashMap<String, String>();
        for (Map.Entry<String, Object> e : allProperties.entrySet()) {
            String s;
            String en;
            String propertyName = e.getKey();
            Object propertyValue = e.getValue();
            if (!propertyName.startsWith(prefix)) continue;
            int pos = propertyName.indexOf(46, prefix.length());
            String string = en = pos == -1 ? propertyName.substring(prefix.length()) : propertyName.substring(prefix.length(), pos);
            if (elementName == null) {
                elementName = en;
            } else if (!en.equals(elementName)) {
                throw new BuildException("Property \"" + propertyName + "\": Inconsistent element name: \"" + elementName + "\" vs. \"" + en + "\"");
            }
            if (!(s = propertyName.substring(++pos)).startsWith("_")) continue;
            attributes.put(s.substring(1), (String)propertyValue);
        }
        if (elementName == null) {
            throw new BuildException("No valid subelement for property name prefix \"" + prefix + "\"");
        }
        try {
            element = document.createElement(elementName);
        }
        catch (DOMException de) {
            throw ExceptionUtil.wrap("Element \"" + elementName + "\"", de, RuntimeException.class);
        }
        for (Map.Entry att : attributes.entrySet()) {
            String attributeName = (String)att.getKey();
            String attributeValue = (String)att.getValue();
            element.setAttribute(attributeName, attributeValue);
        }
        PropertyXml2Task.createSubelements(allProperties, prefix + elementName + '.', element, document);
        return element;
    }

    private static void createSubelements(Map<String, Object> allProperties, String prefix, Node parent, Document document) {
        HashSet<Integer> indexes = new HashSet<Integer>();
        for (String propertyName : allProperties.keySet()) {
            String s;
            Matcher m;
            if (!propertyName.startsWith(prefix) || !(m = PATTERN.matcher(s = propertyName.substring(prefix.length()))).matches()) continue;
            int idx = Integer.parseInt(m.group(1));
            indexes.add(idx);
        }
        int[] indexes2 = new int[indexes.size()];
        int i = 0;
        Iterator iterator = indexes.iterator();
        while (iterator.hasNext()) {
            int index = (Integer)iterator.next();
            indexes2[i++] = index;
        }
        Arrays.sort(indexes2);
        for (int index : indexes2) {
            String prefix2 = prefix + index + '.';
            String text = (String)allProperties.get(prefix2 + '$');
            if (text != null) {
                parent.appendChild(document.createTextNode(text));
                continue;
            }
            String comment = (String)allProperties.get(prefix2 + '#');
            if (comment != null) {
                parent.appendChild(document.createComment(comment));
                continue;
            }
            String cdata = (String)allProperties.get(prefix2 + '!');
            if (cdata != null) {
                parent.appendChild(document.createCDATASection(cdata));
                continue;
            }
            String pi = (String)allProperties.get(prefix2 + '?');
            if (pi != null) {
                int spc = pi.indexOf(32);
                if (spc == -1) {
                    throw new BuildException("Value of property \"" + prefix2 + "?\" lacks a space");
                }
                String target = pi.substring(0, spc);
                String data = pi.substring(spc + 1);
                parent.appendChild(document.createProcessingInstruction(target, data));
                continue;
            }
            parent.appendChild(PropertyXml2Task.createElement(allProperties, prefix2, document));
        }
    }

    static {
        AssertionUtil.enableAssertionsForThisClass();
        PATTERN = Pattern.compile("(\\d+)\\..*");
    }
}

