/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.antology;

import de.unkrig.antology.type.Subelement;
import de.unkrig.commons.lang.AssertionUtil;
import de.unkrig.commons.nullanalysis.Nullable;
import de.unkrig.commons.util.time.PointOfTime;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;

public class AbstractUrlConnectionTask
extends Task {
    @Nullable
    private URL url;
    protected boolean httpFollowRedirects2;
    private final List<Subelement.Name_Value> requestProperties = new ArrayList<Subelement.Name_Value>();
    @Nullable
    private Boolean allowUserInteraction;
    private int connectTimeout = -1;
    private int readTimeout = -1;
    private long ifModifiedSince = -1L;
    @Nullable
    private Boolean useCaches;
    private int httpChunkLength = -1;
    private int httpContentLength = -1;
    @Nullable
    private Boolean httpFollowRedirects;
    @Nullable
    private Proxy proxy;
    private static final Pattern INET_SOCKET_ADDRESS_SPEC_PATTERN;

    public void setAllowUserInteraction(boolean v) {
        this.allowUserInteraction = v;
    }

    public void setConnectTimeout(int milliseconds) {
        this.connectTimeout = milliseconds;
    }

    public void setReadTimeout(int milliseconds) {
        this.readTimeout = milliseconds;
    }

    public void setIfModifiedSince(PointOfTime value) {
        this.ifModifiedSince = value.milliseconds();
    }

    public void setUseCaches(boolean v) {
        this.useCaches = v;
    }

    public void setHttpChunkLength(int chunkLength) {
        this.httpChunkLength = chunkLength;
    }

    public void setHttpContentLength(int contentLength) {
        this.httpContentLength = contentLength;
    }

    public void setHttpFollowRedirects(boolean v) {
        this.httpFollowRedirects = v;
    }

    public void setHttpFollowRedirects2(boolean v) {
        this.httpFollowRedirects2 = v;
    }

    public void setUrl(URL url) {
        if (this.url != null) {
            throw new BuildException("Cannot set more than one source");
        }
        this.url = url;
    }

    public void setDirect(boolean value) {
        this.setProxy(value ? Proxy.NO_PROXY : null);
    }

    public void setHttpProxy(String value) {
        this.setProxy(new Proxy(Proxy.Type.HTTP, AbstractUrlConnectionTask.parseInetSocketAddress(value)));
    }

    public void setSocksProxy(String value) {
        this.setProxy(new Proxy(Proxy.Type.SOCKS, AbstractUrlConnectionTask.parseInetSocketAddress(value)));
    }

    private static InetSocketAddress parseInetSocketAddress(String s) {
        Matcher m = INET_SOCKET_ADDRESS_SPEC_PATTERN.matcher(s);
        if (!m.matches()) {
            throw new BuildException("Invalid socket address spec; must match \"" + INET_SOCKET_ADDRESS_SPEC_PATTERN + "\"");
        }
        String hostname = m.group(1);
        int port = Integer.parseInt(m.group(2));
        return new InetSocketAddress(hostname, port);
    }

    private void setProxy(@Nullable Proxy proxy) {
        if (this.proxy != null) {
            throw new BuildException("'direct=\"true\"', 'httpProxy=\"...\"' and 'socksProxy=\"...\"' are mutually exclusive");
        }
        this.proxy = proxy;
    }

    @Nullable
    protected Proxy getProxy() {
        return this.proxy;
    }

    public void addConfiguredUrl(UrlElement urlElement) throws MalformedURLException {
        this.setUrl(urlElement.getURL());
    }

    public void addConfiguredRequestProperty(Subelement.Name_Value requestProperty) {
        this.requestProperties.add(requestProperty);
    }

    protected void configureUrlConnection(URLConnection conn) {
        for (Subelement.Name_Value requestProperty : this.requestProperties) {
            conn.addRequestProperty(requestProperty.name, requestProperty.value);
        }
        if (this.allowUserInteraction != null) {
            conn.setAllowUserInteraction(this.allowUserInteraction);
        }
        if (this.connectTimeout != -1) {
            conn.setConnectTimeout(this.connectTimeout);
        }
        if (this.readTimeout != -1) {
            conn.setReadTimeout(this.readTimeout);
        }
        if (this.ifModifiedSince != -1L) {
            conn.setIfModifiedSince(this.ifModifiedSince);
        }
        if (this.useCaches != null) {
            conn.setUseCaches(this.useCaches);
        }
    }

    protected URLConnection openConnection() throws IOException {
        URL url = this.url;
        if (url == null) {
            throw new BuildException("No URL configured - configure 'url=...' or '<url>'");
        }
        return this.openConnection(url);
    }

    protected URLConnection openConnection(URL url) throws IOException {
        return this.proxy == null ? url.openConnection() : url.openConnection(this.proxy);
    }

    protected void configureHttpUrlConnection(HttpURLConnection httpConn) {
        Boolean httpFollowRedirects;
        if (this.httpChunkLength != -1) {
            httpConn.setChunkedStreamingMode(this.httpChunkLength);
        }
        if (this.httpContentLength != -1) {
            httpConn.setFixedLengthStreamingMode(this.httpContentLength);
        }
        if ((httpFollowRedirects = this.httpFollowRedirects) != null) {
            httpConn.setInstanceFollowRedirects(httpFollowRedirects);
        }
    }

    static {
        AssertionUtil.enableAssertionsForThisClass();
        INET_SOCKET_ADDRESS_SPEC_PATTERN = Pattern.compile("(.*):(\\d+)");
    }

    public static class UrlElement
    extends ProjectComponent {
        @Nullable
        private URL context;
        @Nullable
        private String spec;
        @Nullable
        private String protocol;
        @Nullable
        private String host;
        private int port = -1;
        @Nullable
        private String userInfo;
        @Nullable
        private String path;
        @Nullable
        private String query;
        @Nullable
        private String ref;

        public void addText(String text) {
            if ((text = text.trim()).isEmpty()) {
                return;
            }
            if (this.spec != null) {
                throw new BuildException("Element has more than one text");
            }
            this.spec = this.getProject().replaceProperties(text);
        }

        public void setContext(String contextUrl) throws MalformedURLException {
            if (this.context != null) {
                throw new BuildException("'context=...' and '<context>' are mutually exclusive");
            }
            this.context = new URL(contextUrl);
        }

        public void setProtocol(String schema) {
            this.protocol = schema;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public void setPort(int portNumber) {
            this.port = portNumber;
        }

        public void setUserInfo(String userInfo) {
            this.userInfo = userInfo;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public void setQuery(String queryString) {
            this.query = queryString;
        }

        public void setRef(String anchor) {
            this.ref = anchor;
        }

        public void addConfiguredFormField(Subelement.Name_Value subelement) throws UnsupportedEncodingException {
            String s = URLEncoder.encode(subelement.name, "UTF-8") + '=' + URLEncoder.encode(subelement.value, "UTF-8");
            this.query = this.query == null ? s : this.query + '&' + s;
        }

        public void addConfiguredContext(UrlElement context) throws MalformedURLException {
            if (this.context != null) {
                throw new BuildException("'context=...' and '<context>' are mutually exclusive");
            }
            this.context = context.getURL();
        }

        @Nullable
        private static <T> T or(@Nullable T t1, @Nullable T t2) {
            return t1 != null ? t1 : t2;
        }

        private static int or(int i1, int i2) {
            return i1 != -1 ? i1 : i2;
        }

        public URL getURL() throws MalformedURLException {
            URL url = new URL(this.context, this.spec != null ? this.spec : "http://localhost/");
            String protocol = UrlElement.or(this.protocol, url.getProtocol());
            String userInfo = UrlElement.or(this.userInfo, url.getUserInfo());
            String host = UrlElement.or(this.host, url.getHost());
            int port = UrlElement.or(this.port, url.getPort());
            String path = UrlElement.or(this.path, url.getPath());
            String query = UrlElement.or(this.query, url.getQuery());
            String ref = UrlElement.or(this.ref, url.getRef());
            String userInfoHost = userInfo == null ? host : userInfo + '@' + host;
            String file = path;
            if (query != null) {
                file = file + '?' + query;
            }
            if (ref != null) {
                file = file + '#' + ref;
            }
            return new URL(protocol, userInfoHost, port, file);
        }
    }
}

