/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.application;

import com.google.common.base.Stopwatch;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.VcsIgnoreManager;
import com.intellij.openapi.vcs.changes.VcsIgnoreManagerImpl;
import com.intellij.openapi.vcs.changes.VcsManagedFilesHolder;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.update.ComparableObject;
import com.intellij.util.ui.update.DisposableUpdate;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.perforce.PerforceBundle;
import org.jetbrains.idea.perforce.ServerVersion;
import org.jetbrains.idea.perforce.application.FileGrouper;
import org.jetbrains.idea.perforce.application.P4IgnoresMappingsHelper;
import org.jetbrains.idea.perforce.application.PerforceClient;
import org.jetbrains.idea.perforce.application.PerforceManager;
import org.jetbrains.idea.perforce.perforce.ExecResult;
import org.jetbrains.idea.perforce.perforce.PerforceRunner;
import org.jetbrains.idea.perforce.perforce.PerforceSettings;
import org.jetbrains.idea.perforce.perforce.View;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;

public final class PerforceUnversionedTracker {
    private static final Logger LOG = Logger.getInstance(PerforceUnversionedTracker.class);
    private final Object LOCK = new Object();
    private final Set<FilePath> myUnversionedFiles = new HashSet<FilePath>();
    private final Set<FilePath> myIgnoredFiles = new HashSet<FilePath>();
    private final Set<VirtualFile> myDirtyLocalFiles = new HashSet<VirtualFile>();
    private final Project myProject;
    private final MergingUpdateQueue myQueue;
    private boolean myInUpdate;
    private Disposable myParentDisposable;

    public PerforceUnversionedTracker(Project project) {
        this.myProject = project;
        this.myQueue = VcsIgnoreManagerImpl.getInstanceImpl((Project)this.myProject).getIgnoreRefreshQueue();
    }

    public void activate(Disposable parentDisposable) {
        Disposer.register((Disposable)parentDisposable, this::deactivate);
        this.myParentDisposable = parentDisposable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivate() {
        Object object = this.LOCK;
        synchronized (object) {
            this.myUnversionedFiles.clear();
            this.myIgnoredFiles.clear();
            this.myDirtyLocalFiles.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLocalOnly(@NotNull VirtualFile file) {
        if (file == null) {
            PerforceUnversionedTracker.$$$reportNull$$$0(0);
        }
        Object object = this.LOCK;
        synchronized (object) {
            if (this.myDirtyLocalFiles.contains(file)) {
                return true;
            }
        }
        FilePath path = VcsUtil.getFilePath((VirtualFile)file);
        return this.isUnversioned(path) || this.isIgnored(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUnversioned(@NotNull FilePath file) {
        if (file == null) {
            PerforceUnversionedTracker.$$$reportNull$$$0(1);
        }
        Object object = this.LOCK;
        synchronized (object) {
            return this.myUnversionedFiles.contains(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isIgnored(@NotNull FilePath file) {
        if (file == null) {
            PerforceUnversionedTracker.$$$reportNull$$$0(2);
        }
        if (this.isPotentiallyIgnoredFile(file)) {
            return true;
        }
        Object object = this.LOCK;
        synchronized (object) {
            return this.myIgnoredFiles.contains(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<FilePath> getIgnoredFiles() {
        Object object = this.LOCK;
        synchronized (object) {
            return new ArrayList<FilePath>(this.myIgnoredFiles);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<FilePath> getUnversionedFiles() {
        Object object = this.LOCK;
        synchronized (object) {
            return new ArrayList<FilePath>(this.myUnversionedFiles);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInUpdateMode() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.myInUpdate;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleUpdate() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.myDirtyLocalFiles.isEmpty()) {
                return;
            }
            this.myInUpdate = true;
        }
        ((VcsManagedFilesHolder.VcsManagedFilesHolderListener)BackgroundTaskUtil.syncPublisher((Project)this.myProject, (Topic)VcsManagedFilesHolder.TOPIC)).updatingModeChanged();
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.update();
        } else {
            this.myQueue.queue((Update)DisposableUpdate.createDisposable((Disposable)this.myParentDisposable, (Object)new ComparableObject.Impl(new Object[]{this, "update"}), this::update));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update() {
        ArrayList<VirtualFile> dirtyFiles;
        Stopwatch sw = Stopwatch.createStarted();
        Object object = this.LOCK;
        synchronized (object) {
            LOG.debug("update started for " + this.myDirtyLocalFiles.size() + " files");
            if (this.myDirtyLocalFiles.isEmpty()) {
                this.myInUpdate = false;
                return;
            }
            dirtyFiles = new ArrayList<VirtualFile>(this.myDirtyLocalFiles);
        }
        MultiMap<P4Connection, VirtualFile> map = FileGrouper.distributeFilesByConnection(dirtyFiles, this.myProject);
        HashSet<VirtualFile> ignoredSet = new HashSet<VirtualFile>();
        try {
            for (P4Connection connection : map.keySet()) {
                ignoredSet.addAll(PerforceUnversionedTracker.getFilesOutsideClientSpec(this.myProject, connection, map.get((Object)connection)));
            }
        }
        catch (VcsException e) {
            LOG.warn("Failed to get ignored files", (Throwable)e);
        }
        Object object2 = this.LOCK;
        synchronized (object2) {
            for (VirtualFile file : map.values()) {
                FilePath path = VcsUtil.getFilePath((VirtualFile)file);
                if (ignoredSet.contains(file)) {
                    this.myIgnoredFiles.add(path);
                    continue;
                }
                this.myUnversionedFiles.add(path);
            }
            this.myDirtyLocalFiles.clear();
            this.myInUpdate = false;
        }
        sw.stop();
        LOG.debug("update finished in %d seconds".formatted(sw.elapsed().toSeconds()));
        ((VcsManagedFilesHolder.VcsManagedFilesHolderListener)BackgroundTaskUtil.syncPublisher((Project)this.myProject, (Topic)VcsManagedFilesHolder.TOPIC)).updatingModeChanged();
        ChangeListManagerImpl.getInstanceImpl((Project)this.myProject).notifyUnchangedFileStatusChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markUnversioned(List<VirtualFile> files) {
        Object object = this.LOCK;
        synchronized (object) {
            this.myDirtyLocalFiles.addAll(files);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markUnknown(@NotNull Set<VirtualFile> files) {
        if (files == null) {
            PerforceUnversionedTracker.$$$reportNull$$$0(3);
        }
        for (VirtualFile file : files) {
            FilePath path = VcsUtil.getFilePath((VirtualFile)file);
            Object object = this.LOCK;
            synchronized (object) {
                this.myUnversionedFiles.remove(path);
                this.myIgnoredFiles.remove(path);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markUnknown(@Nullable FilePath path) {
        if (path != null) {
            Object object = this.LOCK;
            synchronized (object) {
                this.myUnversionedFiles.remove(path);
                this.myIgnoredFiles.remove(path);
            }
        }
    }

    private static Set<VirtualFile> getExcludedFiles(Project project, P4Connection connection, Collection<VirtualFile> files) throws VcsException {
        PerforceClient client = PerforceManager.getInstance(project).getClient(connection);
        String clientName = client.getName();
        if (clientName == null) {
            return Collections.emptySet();
        }
        List roots = ContainerUtil.map(client.getRoots(), FileUtil::toSystemIndependentName);
        List<View> views = client.getViews();
        return new LinkedHashSet<VirtualFile>(ContainerUtil.filter(files, f -> {
            String clientSpecPath = PerforceUnversionedTracker.getClientSpecPath(f, clientName, roots);
            return clientSpecPath != null && View.isExcluded(clientSpecPath, views);
        }));
    }

    @Nullable
    private static String getClientSpecPath(VirtualFile file, String clientName, List<String> roots) {
        String path = file.getPath();
        for (String root : roots) {
            if (!FileUtil.startsWith((String)path, (String)root)) continue;
            return "//" + clientName + "/" + StringUtil.trimStart((String)path.substring(root.length()), (String)"/");
        }
        return null;
    }

    @NotNull
    private static Set<VirtualFile> getIgnoredFiles(Project project, P4Connection connection, List<VirtualFile> toCheckIgnored) throws VcsException {
        if (toCheckIgnored.isEmpty() || !AdvancedSettings.getBoolean((String)"vcs.process.ignored")) {
            Set<VirtualFile> set = Collections.emptySet();
            if (set == null) {
                PerforceUnversionedTracker.$$$reportNull$$$0(4);
            }
            return set;
        }
        ServerVersion serverVersion = PerforceManager.getInstance(project).getServerVersion(connection);
        if (serverVersion != null && serverVersion.supportsIgnoresCommand()) {
            PerforceSettings settings = PerforceSettings.getSettings(project);
            if (settings.USE_PATTERN_MATCHING_IGNORE) {
                Set<VirtualFile> set = PerforceUnversionedTracker.getIgnoredByPatterns(project, connection, toCheckIgnored);
                if (set == null) {
                    PerforceUnversionedTracker.$$$reportNull$$$0(5);
                }
                return set;
            }
            return PerforceUnversionedTracker.getIgnoredFilesByIgnores(project, connection, toCheckIgnored);
        }
        return PerforceUnversionedTracker.getIgnoredFilesByPreviewAdd(project, connection, toCheckIgnored);
    }

    private static Set<VirtualFile> getIgnoredByPatterns(Project project, P4Connection connection, List<VirtualFile> toCheckIgnored) {
        Stopwatch sw = Stopwatch.createStarted();
        P4IgnoresMappingsHelper mappingsHelper = P4IgnoresMappingsHelper.create(project, connection);
        HashSet<VirtualFile> ignoredFiles = new HashSet<VirtualFile>();
        for (VirtualFile file : toCheckIgnored) {
            if (!mappingsHelper.isIgnored(file)) continue;
            ignoredFiles.add(file);
        }
        sw.stop();
        LOG.debug("checking %d ignored files by pattern matching took %d s".formatted(toCheckIgnored.size(), sw.elapsed().toSeconds()));
        return ignoredFiles;
    }

    @NotNull
    private static Set<VirtualFile> getIgnoredFilesByPreviewAdd(Project project, P4Connection connection, List<VirtualFile> toCheckIgnored) throws VcsException {
        String path;
        Stopwatch sw = Stopwatch.createStarted();
        ExecResult execResult = PerforceRunner.getInstance(project).previewAdd(connection, toCheckIgnored);
        LinkedHashSet<VirtualFile> ignored = new LinkedHashSet<VirtualFile>();
        for (String line : execResult.getStderr().split("\n")) {
            if (line.isEmpty() || line.contains("no permission for operation on file(s)")) continue;
            path = StringUtil.trimEnd((String)line, (String)" - file(s) not in client view.");
            if (path.equals(line)) {
                PerforceRunner.checkError(execResult, PerforceSettings.getSettings(project), null);
                continue;
            }
            ContainerUtil.addIfNotNull(ignored, (Object)VfsUtil.findFileByIoFile((File)new File(path), (boolean)false));
        }
        for (String line : execResult.getStdout().split("\n")) {
            if (line.isEmpty() || (path = StringUtil.trimEnd((String)line, (String)(" " + PerforceBundle.message("file.ignored.cannot.be.added", new Object[0])))).equals(line)) continue;
            ContainerUtil.addIfNotNull(ignored, (Object)VfsUtil.findFileByIoFile((File)new File(path), (boolean)false));
        }
        sw.stop();
        LOG.debug("checking %d ignored files by add preview took %d s".formatted(toCheckIgnored.size(), sw.elapsed().toSeconds()));
        LinkedHashSet<VirtualFile> linkedHashSet = ignored;
        if (linkedHashSet == null) {
            PerforceUnversionedTracker.$$$reportNull$$$0(6);
        }
        return linkedHashSet;
    }

    @NotNull
    private static Set<VirtualFile> getIgnoredFilesByIgnores(Project project, P4Connection connection, List<VirtualFile> toCheckIgnored) {
        Stopwatch sw = Stopwatch.createStarted();
        LinkedHashSet<VirtualFile> ignored = new LinkedHashSet<VirtualFile>();
        for (List group : JBIterable.from(toCheckIgnored).split(100).map(JBIterable::toList)) {
            ExecResult execResult = PerforceRunner.getInstance(project).ignores(connection, group);
            if (execResult.getExitCode() == -1) {
                LOG.warn("P4 Ignores returned -1");
                continue;
            }
            for (String line : execResult.getStdout().split("\n")) {
                if (line.isEmpty()) continue;
                String path = StringUtil.trimEnd((String)line, (String)(" " + PerforceBundle.message("file.ignored", new Object[0])));
                ContainerUtil.addIfNotNull(ignored, (Object)VfsUtil.findFileByIoFile((File)new File(path), (boolean)false));
            }
        }
        sw.stop();
        LOG.debug("checking %d ignored files by p4 ignores took %d s".formatted(toCheckIgnored.size(), sw.elapsed().toSeconds()));
        LinkedHashSet<VirtualFile> linkedHashSet = ignored;
        if (linkedHashSet == null) {
            PerforceUnversionedTracker.$$$reportNull$$$0(7);
        }
        return linkedHashSet;
    }

    public static Set<VirtualFile> getFilesOutsideClientSpec(Project project, P4Connection connection, Collection<VirtualFile> files) throws VcsException {
        files = ContainerUtil.filter(files, file -> !file.getPath().contains("..."));
        Set<VirtualFile> excluded = PerforceUnversionedTracker.getExcludedFiles(project, connection, files);
        LinkedHashSet<VirtualFile> result = new LinkedHashSet<VirtualFile>(excluded);
        result.addAll(PerforceUnversionedTracker.getIgnoredFiles(project, connection, ContainerUtil.filter((Collection)files, f -> !excluded.contains(f))));
        return result;
    }

    private boolean isPotentiallyIgnoredFile(FilePath file) {
        return Registry.is((String)"p4.ignore.all.potentially.ignored") && VcsIgnoreManager.getInstance((Project)this.myProject).isPotentiallyIgnoredFile(file);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/perforce/application/PerforceUnversionedTracker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/perforce/application/PerforceUnversionedTracker";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getIgnoredFiles";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getIgnoredFilesByPreviewAdd";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getIgnoredFilesByIgnores";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isLocalOnly";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isUnversioned";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isIgnored";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "markUnknown";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 7 -> new IllegalStateException(string);
        };
    }
}

