/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.core.jupyter.execution;

import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.connections.action.JupyterRestartKernelListener;
import com.intellij.jupyter.core.jupyter.connections.execution.JupyterExecutionTask;
import com.intellij.jupyter.core.jupyter.connections.execution.core.JupyterCellExecutionCallbackFactory;
import com.intellij.jupyter.core.jupyter.connections.execution.core.JupyterExecutionCallback;
import com.intellij.jupyter.core.jupyter.helper.JupyterHelper;
import com.intellij.kotlin.jupyter.core.editor.highlighting.events.ExecutionCallbackRegistered;
import com.intellij.kotlin.jupyter.core.editor.highlighting.events.ExecutionCallbackUnregistered;
import com.intellij.kotlin.jupyter.core.editor.highlighting.service.NotebookCellExecutionHighlightingHelper;
import com.intellij.kotlin.jupyter.core.editor.highlighting.service.NotebookHighlightingService;
import com.intellij.kotlin.jupyter.core.jupyter.execution.KotlinNotebookCellExecutionCallback;
import com.intellij.kotlin.jupyter.core.util.IsKotlinNotebookKt;
import com.intellij.notebooks.visualization.NotebookIntervalPointer;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.psi.jupyter.psi.JupyterPsiCell;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00062\b\u0010\u0010\u001a\u0004\u0018\u00010\bH\u0002\u00a2\u0006\u0002\u0010\u0011J\u001e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\bJ\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0016\u0010\u0019\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u0006R,\u0010\u0004\u001a \u0012\u0004\u0012\u00020\u0006\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\t0\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/kotlin/jupyter/core/jupyter/execution/KotlinNotebookCellExecutionCallbackFactory;", "Lcom/intellij/jupyter/core/jupyter/connections/execution/core/JupyterCellExecutionCallbackFactory;", "<init>", "()V", "callbacksCounters", "", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "Lkotlin/Pair;", "", "Ljava/util/PriorityQueue;", "executionDataLock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "registerNextIndexForCallback", "project", "Lcom/intellij/openapi/project/Project;", "file", "cellOrd", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;Ljava/lang/Integer;)I", "unregisterCallback", "", "index", "create", "Lcom/intellij/jupyter/core/jupyter/connections/execution/core/JupyterExecutionCallback;", "task", "Lcom/intellij/jupyter/core/jupyter/connections/execution/JupyterExecutionTask;", "createUnboundCallback", "virtualFile", "intellij.kotlin.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nKotlinNotebookCellExecutionCallbackFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinNotebookCellExecutionCallbackFactory.kt\ncom/intellij/kotlin/jupyter/core/jupyter/execution/KotlinNotebookCellExecutionCallbackFactory\n+ 2 sync.kt\ncom/intellij/kotlin/jupyter/core/util/SyncKt\n*L\n1#1,112:1\n36#2,2:113\n*S KotlinDebug\n*F\n+ 1 KotlinNotebookCellExecutionCallbackFactory.kt\ncom/intellij/kotlin/jupyter/core/jupyter/execution/KotlinNotebookCellExecutionCallbackFactory\n*L\n30#1:113,2\n*E\n"})
public final class KotlinNotebookCellExecutionCallbackFactory
implements JupyterCellExecutionCallbackFactory {
    @NotNull
    private final Map<BackedNotebookVirtualFile, Pair<Integer, PriorityQueue<Integer>>> callbacksCounters;
    @NotNull
    private final ReentrantReadWriteLock executionDataLock;

    public KotlinNotebookCellExecutionCallbackFactory() {
        ApplicationManager.getApplication().getMessageBus().connect().subscribe(JupyterRestartKernelListener.Companion.getTOPIC(), arg_0 -> KotlinNotebookCellExecutionCallbackFactory._init_$lambda$1(this, arg_0));
        this.callbacksCounters = new LinkedHashMap();
        this.executionDataLock = new ReentrantReadWriteLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int registerNextIndexForCallback(Project project, BackedNotebookVirtualFile file, Integer cellOrd) {
        int n;
        ReentrantReadWriteLock reentrantReadWriteLock = this.executionDataLock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n2 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int j = 0; j < n2; ++j) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            Pair pair = this.callbacksCounters.get(file);
            if (pair == null) {
                pair = TuplesKt.to((Object)0, new PriorityQueue());
            }
            Pair pair2 = pair;
            int cnt = ((Number)pair2.component1()).intValue();
            PriorityQueue pq = (PriorityQueue)pair2.component2();
            if (pq.size() > 1 && !pq.contains(-1)) {
                pq.add(-1);
            }
            pq.add(cnt);
            NotebookCellExecutionHighlightingHelper $this$registerNextIndexForCallback_u24lambda_u243_u24lambda_u242 = NotebookHighlightingService.Companion.getForFile(project, file).getDataController().getExecutionHighlightingHelper();
            boolean bl2 = false;
            ExecutionCallbackRegistered eventData = new ExecutionCallbackRegistered(cellOrd);
            $this$registerNextIndexForCallback_u24lambda_u243_u24lambda_u242.onEventHappened(eventData);
            this.callbacksCounters.put(file, (Pair<Integer, PriorityQueue<Integer>>)TuplesKt.to((Object)(cnt + 1), (Object)pq));
            n = cnt;
        }
        finally {
            for (int j = 0; j < n2; ++j) {
                readLock.lock();
            }
            writeLock.unlock();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void unregisterCallback(@NotNull Project project, @NotNull BackedNotebookVirtualFile file, int index) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ReentrantReadWriteLock reentrantReadWriteLock = this.executionDataLock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int j = 0; j < n; ++j) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            Pair<Integer, PriorityQueue<Integer>> pair = this.callbacksCounters.get(file);
            if (pair != null) {
                boolean isAfterSeriesRuns;
                PriorityQueue pq = (PriorityQueue)pair.component2();
                pq.remove(index);
                boolean bl2 = isAfterSeriesRuns = pq.size() == 1 && pq.contains(-1);
                if (isAfterSeriesRuns) {
                    pq.remove(-1);
                }
                NotebookCellExecutionHighlightingHelper $this$unregisterCallback_u24lambda_u245_u24lambda_u244 = NotebookHighlightingService.Companion.getForFile(project, file).getDataController().getExecutionHighlightingHelper();
                boolean bl3 = false;
                ExecutionCallbackUnregistered eventData = new ExecutionCallbackUnregistered(index, isAfterSeriesRuns, pq);
                $this$unregisterCallback_u24lambda_u245_u24lambda_u244.onEventHappened(eventData);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            for (int j = 0; j < n; ++j) {
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    @Nullable
    public JupyterExecutionCallback create(@NotNull JupyterExecutionTask task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Project project = task.getProject();
        if (project == null) {
            return null;
        }
        Project cellProject = project;
        BackedNotebookVirtualFile file = task.getNotebookVirtualFile();
        if (!IsKotlinNotebookKt.isKotlinNotebook(file.getFile())) {
            return null;
        }
        Pair jupyterPsiCellData = (Pair)ActionsKt.runReadAction(() -> KotlinNotebookCellExecutionCallbackFactory.create$lambda$6(task, cellProject));
        Pair pair = jupyterPsiCellData;
        if (pair == null || (pair = (JupyterPsiCell)pair.getFirst()) == null) {
            return null;
        }
        Pair cell = pair;
        int index = this.registerNextIndexForCallback(cellProject, file, (Integer)jupyterPsiCellData.getSecond());
        return (JupyterExecutionCallback)new KotlinNotebookCellExecutionCallback(cellProject, file, (JupyterPsiCell)cell, index, System.currentTimeMillis());
    }

    @NotNull
    public final JupyterExecutionCallback createUnboundCallback(@NotNull Project project, @NotNull BackedNotebookVirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        int index = this.registerNextIndexForCallback(project, virtualFile, null);
        return (JupyterExecutionCallback)new KotlinNotebookCellExecutionCallback(project, virtualFile, null, index, System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void _init_$lambda$1(KotlinNotebookCellExecutionCallbackFactory this$0, BackedNotebookVirtualFile notebookFile) {
        Intrinsics.checkNotNullParameter((Object)notebookFile, (String)"notebookFile");
        ReentrantReadWriteLock $this$withWriteLock$iv = this$0.executionDataLock;
        boolean $i$f$withWriteLock = false;
        ReentrantReadWriteLock reentrantReadWriteLock = $this$withWriteLock$iv;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int j = 0; j < n; ++j) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            boolean bl2 = false;
            this$0.callbacksCounters.remove(notebookFile);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            for (int j = 0; j < n; ++j) {
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    private static final Pair create$lambda$6(JupyterExecutionTask $task, Project $cellProject) {
        NotebookIntervalPointer notebookIntervalPointer = $task.getOptions().getCellPointer();
        if (notebookIntervalPointer == null || (notebookIntervalPointer = notebookIntervalPointer.get()) == null) {
            return null;
        }
        int cellIndex = notebookIntervalPointer.getOrdinal();
        List list = JupyterHelper.INSTANCE.getPsiCells($cellProject, $task.getNotebookVirtualFile());
        return TuplesKt.to((Object)(list != null ? (JupyterPsiCell)CollectionsKt.getOrNull((List)list, (int)cellIndex) : null), (Object)cellIndex);
    }
}

