/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.gui.form;

import com.jeta.forms.gui.form.GridCellEvent;
import com.jeta.forms.gui.form.GridComponent;
import com.jeta.forms.gui.form.GridView;

public class GridViewEvent {
    private int m_id;
    private GridView m_source;
    private GridCellEvent m_comp_event;
    public static final int ROW_ADDED = 1;
    public static final int ROW_DELETED = 2;
    public static final int ROW_SPEC_CHANGED = 3;
    public static final int COLUMN_ADDED = 4;
    public static final int COLUMN_DELETED = 5;
    public static final int COLUMN_SPEC_CHANGED = 7;
    public static final int CELL_CHANGED = 8;
    public static final int EDIT_COMPONENT = 9;
    public static final int CELL_SELECTED = 10;
    public static final int ROW_GROUPS_CHANGED = 11;
    public static final int COLUMN_GROUPS_CHANGED = 12;

    public GridViewEvent(GridView gridView, int n) {
        this.m_id = n;
        this.m_source = gridView;
    }

    public GridViewEvent(GridView gridView, int n, GridComponent gridComponent) {
        this.m_id = n;
        this.m_source = gridView;
        this.m_comp_event = new GridCellEvent(n, gridComponent, null);
    }

    public GridViewEvent(GridView gridView, int n, GridCellEvent gridCellEvent) {
        this.m_id = n;
        this.m_source = gridView;
        this.m_comp_event = gridCellEvent;
    }

    public int getId() {
        return this.m_id;
    }

    public String getCommand() {
        if (this.m_comp_event != null) {
            return this.m_comp_event.getCommand();
        }
        return null;
    }

    public GridComponent getComponent() {
        if (this.m_comp_event != null) {
            return this.m_comp_event.getSource();
        }
        return null;
    }

    public GridCellEvent getComponentEvent() {
        return this.m_comp_event;
    }

    public GridView getSource() {
        return this.m_source;
    }

    public void print() {
        String string = "UNKNOWN";
        if (this.m_id == 1) {
            string = "ROW_ADDED";
        } else if (this.m_id == 2) {
            string = "ROW_DELETED";
        } else if (this.m_id == 3) {
            string = "ROW_SPEC_CHANGED";
        } else if (this.m_id == 4) {
            string = "COLUMN_ADDED";
        } else if (this.m_id == 5) {
            string = "COLUMN_DELETED";
        } else if (this.m_id == 7) {
            string = "COLUMN_SPEC_CHANGED";
        } else if (this.m_id == 8) {
            string = "CELL_CHANGED";
        } else if (this.m_id == 9) {
            string = "EDIT_COMPONENT";
        } else if (this.m_id == 10) {
            string = "CELL_SELECTED";
        } else if (this.m_id == 11) {
            string = "ROW_GROUPS_CHANGED";
        } else if (this.m_id == 12) {
            string = "COLUMN_GROUPS_CHANGED";
        }
        System.out.println("GridViewEvent:  id = " + string + "  component: " + this.getComponent());
    }
}

