package trademark

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// FilterUnavailableCodes invokes the trademark.FilterUnavailableCodes API synchronously
// api document: https://help.aliyun.com/api/trademark/filterunavailablecodes.html
func (client *Client) FilterUnavailableCodes(request *FilterUnavailableCodesRequest) (response *FilterUnavailableCodesResponse, err error) {
	response = CreateFilterUnavailableCodesResponse()
	err = client.DoAction(request, response)
	return
}

// FilterUnavailableCodesWithChan invokes the trademark.FilterUnavailableCodes API asynchronously
// api document: https://help.aliyun.com/api/trademark/filterunavailablecodes.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) FilterUnavailableCodesWithChan(request *FilterUnavailableCodesRequest) (<-chan *FilterUnavailableCodesResponse, <-chan error) {
	responseChan := make(chan *FilterUnavailableCodesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.FilterUnavailableCodes(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// FilterUnavailableCodesWithCallback invokes the trademark.FilterUnavailableCodes API asynchronously
// api document: https://help.aliyun.com/api/trademark/filterunavailablecodes.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) FilterUnavailableCodesWithCallback(request *FilterUnavailableCodesRequest, callback func(response *FilterUnavailableCodesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *FilterUnavailableCodesResponse
		var err error
		defer close(result)
		response, err = client.FilterUnavailableCodes(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// FilterUnavailableCodesRequest is the request struct for api FilterUnavailableCodes
type FilterUnavailableCodesRequest struct {
	*requests.RpcRequest
	Codes string `position:"Query" name:"Codes"`
}

// FilterUnavailableCodesResponse is the response struct for api FilterUnavailableCodes
type FilterUnavailableCodesResponse struct {
	*responses.BaseResponse
	RequestId string                       `json:"RequestId" xml:"RequestId"`
	Data      DataInFilterUnavailableCodes `json:"Data" xml:"Data"`
}

// CreateFilterUnavailableCodesRequest creates a request to invoke FilterUnavailableCodes API
func CreateFilterUnavailableCodesRequest() (request *FilterUnavailableCodesRequest) {
	request = &FilterUnavailableCodesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Trademark", "2018-07-24", "FilterUnavailableCodes", "trademark", "openAPI")
	return
}

// CreateFilterUnavailableCodesResponse creates a response to parse from FilterUnavailableCodes response
func CreateFilterUnavailableCodesResponse() (response *FilterUnavailableCodesResponse) {
	response = &FilterUnavailableCodesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
