package scsp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// EnableRole invokes the scsp.EnableRole API synchronously
func (client *Client) EnableRole(request *EnableRoleRequest) (response *EnableRoleResponse, err error) {
	response = CreateEnableRoleResponse()
	err = client.DoAction(request, response)
	return
}

// EnableRoleWithChan invokes the scsp.EnableRole API asynchronously
func (client *Client) EnableRoleWithChan(request *EnableRoleRequest) (<-chan *EnableRoleResponse, <-chan error) {
	responseChan := make(chan *EnableRoleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.EnableRole(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// EnableRoleWithCallback invokes the scsp.EnableRole API asynchronously
func (client *Client) EnableRoleWithCallback(request *EnableRoleRequest, callback func(response *EnableRoleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *EnableRoleResponse
		var err error
		defer close(result)
		response, err = client.EnableRole(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// EnableRoleRequest is the request struct for api EnableRole
type EnableRoleRequest struct {
	*requests.RpcRequest
	ClientToken string           `position:"Body"`
	InstanceId  string           `position:"Body"`
	RoleId      requests.Integer `position:"Body"`
}

// EnableRoleResponse is the response struct for api EnableRole
type EnableRoleResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateEnableRoleRequest creates a request to invoke EnableRole API
func CreateEnableRoleRequest() (request *EnableRoleRequest) {
	request = &EnableRoleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("scsp", "2020-07-02", "EnableRole", "", "")
	request.Method = requests.POST
	return
}

// CreateEnableRoleResponse creates a response to parse from EnableRole response
func CreateEnableRoleResponse() (response *EnableRoleResponse) {
	response = &EnableRoleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
