package opensearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// PreviewModel invokes the opensearch.PreviewModel API synchronously
func (client *Client) PreviewModel(request *PreviewModelRequest) (response *PreviewModelResponse, err error) {
	response = CreatePreviewModelResponse()
	err = client.DoAction(request, response)
	return
}

// PreviewModelWithChan invokes the opensearch.PreviewModel API asynchronously
func (client *Client) PreviewModelWithChan(request *PreviewModelRequest) (<-chan *PreviewModelResponse, <-chan error) {
	responseChan := make(chan *PreviewModelResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.PreviewModel(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// PreviewModelWithCallback invokes the opensearch.PreviewModel API asynchronously
func (client *Client) PreviewModelWithCallback(request *PreviewModelRequest, callback func(response *PreviewModelResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *PreviewModelResponse
		var err error
		defer close(result)
		response, err = client.PreviewModel(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// PreviewModelRequest is the request struct for api PreviewModel
type PreviewModelRequest struct {
	*requests.RoaRequest
	ModelName        string `position:"Path" name:"modelName"`
	Query            string `position:"Query" name:"query"`
	AppGroupIdentity string `position:"Path" name:"appGroupIdentity"`
}

// PreviewModelResponse is the response struct for api PreviewModel
type PreviewModelResponse struct {
	*responses.BaseResponse
	RequestId  string                   `json:"requestId" xml:"requestId"`
	TotalCount int64                    `json:"totalCount" xml:"totalCount"`
	Result     []map[string]interface{} `json:"result" xml:"result"`
}

// CreatePreviewModelRequest creates a request to invoke PreviewModel API
func CreatePreviewModelRequest() (request *PreviewModelRequest) {
	request = &PreviewModelRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("OpenSearch", "2017-12-25", "PreviewModel", "/v4/openapi/app-groups/[appGroupIdentity]/algorithm/models/[modelName]/actions/preview", "opensearch", "openAPI")
	request.Method = requests.GET
	return
}

// CreatePreviewModelResponse creates a response to parse from PreviewModel response
func CreatePreviewModelResponse() (response *PreviewModelResponse) {
	response = &PreviewModelResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
