package mse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddGatewayServiceVersion invokes the mse.AddGatewayServiceVersion API synchronously
func (client *Client) AddGatewayServiceVersion(request *AddGatewayServiceVersionRequest) (response *AddGatewayServiceVersionResponse, err error) {
	response = CreateAddGatewayServiceVersionResponse()
	err = client.DoAction(request, response)
	return
}

// AddGatewayServiceVersionWithChan invokes the mse.AddGatewayServiceVersion API asynchronously
func (client *Client) AddGatewayServiceVersionWithChan(request *AddGatewayServiceVersionRequest) (<-chan *AddGatewayServiceVersionResponse, <-chan error) {
	responseChan := make(chan *AddGatewayServiceVersionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddGatewayServiceVersion(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddGatewayServiceVersionWithCallback invokes the mse.AddGatewayServiceVersion API asynchronously
func (client *Client) AddGatewayServiceVersionWithCallback(request *AddGatewayServiceVersionRequest, callback func(response *AddGatewayServiceVersionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddGatewayServiceVersionResponse
		var err error
		defer close(result)
		response, err = client.AddGatewayServiceVersion(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddGatewayServiceVersionRequest is the request struct for api AddGatewayServiceVersion
type AddGatewayServiceVersionRequest struct {
	*requests.RpcRequest
	GatewayUniqueId string           `position:"Query" name:"GatewayUniqueId"`
	ServiceVersion  string           `position:"Query" name:"ServiceVersion"`
	AcceptLanguage  string           `position:"Query" name:"AcceptLanguage"`
	ServiceId       requests.Integer `position:"Query" name:"ServiceId"`
}

// AddGatewayServiceVersionResponse is the response struct for api AddGatewayServiceVersion
type AddGatewayServiceVersionResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string `json:"Message" xml:"Message"`
	Code           int    `json:"Code" xml:"Code"`
	Success        bool   `json:"Success" xml:"Success"`
	Data           int64  `json:"Data" xml:"Data"`
}

// CreateAddGatewayServiceVersionRequest creates a request to invoke AddGatewayServiceVersion API
func CreateAddGatewayServiceVersionRequest() (request *AddGatewayServiceVersionRequest) {
	request = &AddGatewayServiceVersionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mse", "2019-05-31", "AddGatewayServiceVersion", "", "")
	request.Method = requests.POST
	return
}

// CreateAddGatewayServiceVersionResponse creates a response to parse from AddGatewayServiceVersion response
func CreateAddGatewayServiceVersionResponse() (response *AddGatewayServiceVersionResponse) {
	response = &AddGatewayServiceVersionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
