package drds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SubmitSwitchTask invokes the drds.SubmitSwitchTask API synchronously
func (client *Client) SubmitSwitchTask(request *SubmitSwitchTaskRequest) (response *SubmitSwitchTaskResponse, err error) {
	response = CreateSubmitSwitchTaskResponse()
	err = client.DoAction(request, response)
	return
}

// SubmitSwitchTaskWithChan invokes the drds.SubmitSwitchTask API asynchronously
func (client *Client) SubmitSwitchTaskWithChan(request *SubmitSwitchTaskRequest) (<-chan *SubmitSwitchTaskResponse, <-chan error) {
	responseChan := make(chan *SubmitSwitchTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SubmitSwitchTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SubmitSwitchTaskWithCallback invokes the drds.SubmitSwitchTask API asynchronously
func (client *Client) SubmitSwitchTaskWithCallback(request *SubmitSwitchTaskRequest, callback func(response *SubmitSwitchTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SubmitSwitchTaskResponse
		var err error
		defer close(result)
		response, err = client.SubmitSwitchTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SubmitSwitchTaskRequest is the request struct for api SubmitSwitchTask
type SubmitSwitchTaskRequest struct {
	*requests.RpcRequest
	DrdsInstanceId string `position:"Query" name:"DrdsInstanceId"`
	ExpandType     string `position:"Query" name:"ExpandType"`
	JobId          string `position:"Query" name:"JobId"`
	DbName         string `position:"Query" name:"DbName"`
	ParentJobId    string `position:"Query" name:"ParentJobId"`
}

// SubmitSwitchTaskResponse is the response struct for api SubmitSwitchTask
type SubmitSwitchTaskResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateSubmitSwitchTaskRequest creates a request to invoke SubmitSwitchTask API
func CreateSubmitSwitchTaskRequest() (request *SubmitSwitchTaskRequest) {
	request = &SubmitSwitchTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Drds", "2019-01-23", "SubmitSwitchTask", "drds", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSubmitSwitchTaskResponse creates a response to parse from SubmitSwitchTask response
func CreateSubmitSwitchTaskResponse() (response *SubmitSwitchTaskResponse) {
	response = &SubmitSwitchTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
