package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CheckMetaTableTask invokes the dataworks_public.CheckMetaTableTask API synchronously
func (client *Client) CheckMetaTableTask(request *CheckMetaTableTaskRequest) (response *CheckMetaTableTaskResponse, err error) {
	response = CreateCheckMetaTableTaskResponse()
	err = client.DoAction(request, response)
	return
}

// CheckMetaTableTaskWithChan invokes the dataworks_public.CheckMetaTableTask API asynchronously
func (client *Client) CheckMetaTableTaskWithChan(request *CheckMetaTableTaskRequest) (<-chan *CheckMetaTableTaskResponse, <-chan error) {
	responseChan := make(chan *CheckMetaTableTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CheckMetaTableTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CheckMetaTableTaskWithCallback invokes the dataworks_public.CheckMetaTableTask API asynchronously
func (client *Client) CheckMetaTableTaskWithCallback(request *CheckMetaTableTaskRequest, callback func(response *CheckMetaTableTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CheckMetaTableTaskResponse
		var err error
		defer close(result)
		response, err = client.CheckMetaTableTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CheckMetaTableTaskRequest is the request struct for api CheckMetaTableTask
type CheckMetaTableTaskRequest struct {
	*requests.RpcRequest
}

// CheckMetaTableTaskResponse is the response struct for api CheckMetaTableTask
type CheckMetaTableTaskResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      bool   `json:"Data" xml:"Data"`
}

// CreateCheckMetaTableTaskRequest creates a request to invoke CheckMetaTableTask API
func CreateCheckMetaTableTaskRequest() (request *CheckMetaTableTaskRequest) {
	request = &CheckMetaTableTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "CheckMetaTableTask", "", "")
	request.Method = requests.POST
	return
}

// CreateCheckMetaTableTaskResponse creates a response to parse from CheckMetaTableTask response
func CreateCheckMetaTableTaskResponse() (response *CheckMetaTableTaskResponse) {
	response = &CheckMetaTableTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
