package cdrs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListStructureStatistics invokes the cdrs.ListStructureStatistics API synchronously
func (client *Client) ListStructureStatistics(request *ListStructureStatisticsRequest) (response *ListStructureStatisticsResponse, err error) {
	response = CreateListStructureStatisticsResponse()
	err = client.DoAction(request, response)
	return
}

// ListStructureStatisticsWithChan invokes the cdrs.ListStructureStatistics API asynchronously
func (client *Client) ListStructureStatisticsWithChan(request *ListStructureStatisticsRequest) (<-chan *ListStructureStatisticsResponse, <-chan error) {
	responseChan := make(chan *ListStructureStatisticsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListStructureStatistics(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListStructureStatisticsWithCallback invokes the cdrs.ListStructureStatistics API asynchronously
func (client *Client) ListStructureStatisticsWithCallback(request *ListStructureStatisticsRequest, callback func(response *ListStructureStatisticsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListStructureStatisticsResponse
		var err error
		defer close(result)
		response, err = client.ListStructureStatistics(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListStructureStatisticsRequest is the request struct for api ListStructureStatistics
type ListStructureStatisticsRequest struct {
	*requests.RpcRequest
	CorpId       string `position:"Body" name:"CorpId"`
	BackCategory string `position:"Body" name:"BackCategory"`
}

// ListStructureStatisticsResponse is the response struct for api ListStructureStatistics
type ListStructureStatisticsResponse struct {
	*responses.BaseResponse
	Code       string  `json:"Code" xml:"Code"`
	Message    string  `json:"Message" xml:"Message"`
	RequestId  string  `json:"RequestId" xml:"RequestId"`
	PageNumber int64   `json:"PageNumber" xml:"PageNumber"`
	PageSize   int64   `json:"PageSize" xml:"PageSize"`
	TotalCount int64   `json:"TotalCount" xml:"TotalCount"`
	Data       []Datas `json:"Data" xml:"Data"`
}

// CreateListStructureStatisticsRequest creates a request to invoke ListStructureStatistics API
func CreateListStructureStatisticsRequest() (request *ListStructureStatisticsRequest) {
	request = &ListStructureStatisticsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CDRS", "2020-11-01", "ListStructureStatistics", "", "")
	request.Method = requests.POST
	return
}

// CreateListStructureStatisticsResponse creates a response to parse from ListStructureStatistics response
func CreateListStructureStatisticsResponse() (response *ListStructureStatisticsResponse) {
	response = &ListStructureStatisticsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
