package aegis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateWhiteListStrategyStatus invokes the aegis.UpdateWhiteListStrategyStatus API synchronously
// api document: https://help.aliyun.com/api/aegis/updatewhiteliststrategystatus.html
func (client *Client) UpdateWhiteListStrategyStatus(request *UpdateWhiteListStrategyStatusRequest) (response *UpdateWhiteListStrategyStatusResponse, err error) {
	response = CreateUpdateWhiteListStrategyStatusResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateWhiteListStrategyStatusWithChan invokes the aegis.UpdateWhiteListStrategyStatus API asynchronously
// api document: https://help.aliyun.com/api/aegis/updatewhiteliststrategystatus.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateWhiteListStrategyStatusWithChan(request *UpdateWhiteListStrategyStatusRequest) (<-chan *UpdateWhiteListStrategyStatusResponse, <-chan error) {
	responseChan := make(chan *UpdateWhiteListStrategyStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateWhiteListStrategyStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateWhiteListStrategyStatusWithCallback invokes the aegis.UpdateWhiteListStrategyStatus API asynchronously
// api document: https://help.aliyun.com/api/aegis/updatewhiteliststrategystatus.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateWhiteListStrategyStatusWithCallback(request *UpdateWhiteListStrategyStatusRequest, callback func(response *UpdateWhiteListStrategyStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateWhiteListStrategyStatusResponse
		var err error
		defer close(result)
		response, err = client.UpdateWhiteListStrategyStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateWhiteListStrategyStatusRequest is the request struct for api UpdateWhiteListStrategyStatus
type UpdateWhiteListStrategyStatusRequest struct {
	*requests.RpcRequest
	SourceIp    string           `position:"Query" name:"SourceIp"`
	StrategyIds string           `position:"Query" name:"StrategyIds"`
	Lang        string           `position:"Query" name:"Lang"`
	Status      requests.Integer `position:"Query" name:"Status"`
}

// UpdateWhiteListStrategyStatusResponse is the response struct for api UpdateWhiteListStrategyStatus
type UpdateWhiteListStrategyStatusResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateWhiteListStrategyStatusRequest creates a request to invoke UpdateWhiteListStrategyStatus API
func CreateUpdateWhiteListStrategyStatusRequest() (request *UpdateWhiteListStrategyStatusRequest) {
	request = &UpdateWhiteListStrategyStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("aegis", "2016-11-11", "UpdateWhiteListStrategyStatus", "vipaegis", "openAPI")
	return
}

// CreateUpdateWhiteListStrategyStatusResponse creates a response to parse from UpdateWhiteListStrategyStatus response
func CreateUpdateWhiteListStrategyStatusResponse() (response *UpdateWhiteListStrategyStatusResponse) {
	response = &UpdateWhiteListStrategyStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
