/* This file is part of OpenBubbles.
 *
 * OpenBubbles is an SDL clone of Bubbles.
 * Copyright (C) 2004  Benny Sperisen
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * bounce.cpp is the implementation file of bounce.h.
 *
 * Written by:
 *  Benny Sperisen
 *  lasindi@gmail.com
 *  www.freewebs.com/lasindi
 *
 * Code added by Jason Woofenden
 *
 *****************************************************************************/

#include "bounce.h"

double realarctan(double y,double x)
{
  double temp;
  if(x==0) // You'll get an error if you divide by 0.
    if(y>=0)
      return PI/2;
    else
      return 3*PI/2;
  else
  {
    temp=atan((double)y/x); // Take the normal arctan.
    // Put the angle in the appropriate quadrant.
    if(x < 0)
      return temp+PI;
    else
      return temp;
  }
}

void quadraticFormula(double a,double b,double c,char & numberOfSolutions,
                      double & solution1,double & solution2)
{
  double determinant=pow(b,2.0)-4*a*c;
  if(determinant>0)
  {
    numberOfSolutions=2;
    solution1=(-b+sqrt(determinant))/(2*a);
    solution2=(-b-sqrt(determinant))/(2*a);
  }
  else if(determinant==0)
  {
    numberOfSolutions=1;
    solution1=-b/(2*a);
  }
  else
    numberOfSolutions=0;
}
