   /*******************************************************/
   /*      "C" Language Integrated Production System      */
   /*                                                     */
   /*             CLIPS Version 6.40  08/25/16            */
   /*                                                     */
   /*              CLASS COMMANDS HEADER FILE             */
   /*******************************************************/

/*************************************************************/
/* Purpose:                                                  */
/*                                                           */
/* Principal Programmer(s):                                  */
/*      Brian L. Dantes                                      */
/*                                                           */
/* Contributing Programmer(s):                               */
/*                                                           */
/* Revision History:                                         */
/*                                                           */
/*      6.23: Corrected compilation errors for files         */
/*            generated by constructs-to-c. DR0861           */
/*                                                           */
/*      6.24: Renamed BOOLEAN macro type to intBool.         */
/*                                                           */
/*      6.30: Borland C (IBM_TBC) and Metrowerks CodeWarrior */
/*            (MAC_MCW, IBM_MCW) are no longer supported.    */
/*                                                           */
/*            Added const qualifiers to remove C++           */
/*            deprecation warnings.                          */
/*                                                           */
/*            Converted API macros to function calls.        */
/*                                                           */
/*            Changed find construct functionality so that   */
/*            imported modules are search when locating a    */
/*            named construct.                               */
/*                                                           */
/*      6.40: Removed LOCALE definition.                     */
/*                                                           */
/*            Pragma once and other inclusion changes.       */
/*                                                           */
/*            Added support for booleans with <stdbool.h>.   */
/*                                                           */
/*            Removed use of void pointers for specific      */
/*            data structures.                               */
/*                                                           */
/*            ALLOW_ENVIRONMENT_GLOBALS no longer supported. */
/*                                                           */
/*            UDF redesign.                                  */
/*                                                           */
/*************************************************************/

#ifndef _H_classcom

#pragma once

#define _H_classcom

typedef enum
  {
   CONVENIENCE_MODE,
   CONSERVATION_MODE
  } ClassDefaultsMode;

#include "cstrccom.h"
#include "moduldef.h"
#include "object.h"
#include "symbol.h"

   const char             *DefclassName(Defclass *);
   const char             *DefclassPPForm(Defclass *);
   struct defmoduleItemHeader
                          *GetDefclassModule(Environment *,Defclass *);
   const char             *DefclassModule(Defclass *);
   CLIPSLexeme            *GetDefclassNamePointer(Defclass *);
   void                    SetNextDefclass(Defclass *,Defclass *);
   void                    SetDefclassPPForm(Environment *,Defclass *,char *);

   Defclass               *FindDefclass(Environment *,const char *);
   Defclass               *FindDefclassInModule(Environment *,const char *);
   Defclass               *LookupDefclassByMdlOrScope(Environment *,const char *);
   Defclass               *LookupDefclassInScope(Environment *,const char *);
   Defclass               *LookupDefclassAnywhere(Environment *,Defmodule *,const char *);
   bool                    DefclassInScope(Environment *,Defclass *,Defmodule *);
   Defclass               *GetNextDefclass(Environment *,Defclass *);
   bool                    DefclassIsDeletable(Defclass *);

   void                    UndefclassCommand(Environment *,UDFContext *,UDFValue *);
   ClassDefaultsMode       SetClassDefaultsMode(Environment *,ClassDefaultsMode);
   ClassDefaultsMode       GetClassDefaultsMode(Environment *);
   void                    GetClassDefaultsModeCommand(Environment *,UDFContext *,UDFValue *);
   void                    SetClassDefaultsModeCommand(Environment *,UDFContext *,UDFValue *);

#if DEBUGGING_FUNCTIONS
   void                    PPDefclassCommand(Environment *,UDFContext *,UDFValue *);
   void                    ListDefclassesCommand(Environment *,UDFContext *,UDFValue *);
   void                    ListDefclasses(Environment *,const char *,Defmodule *);
   bool                    DefclassGetWatchInstances(Defclass *);
   void                    DefclassSetWatchInstances(Defclass *,bool);
   bool                    DefclassGetWatchSlots(Defclass *);
   void                    DefclassSetWatchSlots(Defclass *,bool);
   bool                    DefclassWatchAccess(Environment *,int,bool,Expression *);
   bool                    DefclassWatchPrint(Environment *,const char *,int,Expression *);
#endif

   void                    GetDefclassListFunction(Environment *,UDFContext *,UDFValue *);
   void                    GetDefclassList(Environment *,CLIPSValue *,Defmodule *);
   bool                    Undefclass(Defclass *,Environment *);
   bool                    HasSuperclass(Defclass *,Defclass *);

   CLIPSLexeme            *CheckClassAndSlot(UDFContext *,const char *,Defclass **);

#if (! BLOAD_ONLY) && (! RUN_TIME)
   void                    SaveDefclasses(Environment *,Defmodule *,const char *,void *);
#endif

#endif /* _H_classcom */
