/*
 * Decompiled with CFR 0.152.
 */
package net.sf.clipsrules.jni;

import net.sf.clipsrules.jni.CLIPSType;
import net.sf.clipsrules.jni.Environment;
import net.sf.clipsrules.jni.PrimitiveValue;

public class FactAddressValue
extends PrimitiveValue {
    private Environment owner;
    private Long value;

    public FactAddressValue(long l, Environment environment) {
        this.value = l;
        this.owner = environment;
    }

    @Override
    public Long getValue() {
        return this.value;
    }

    @Override
    public CLIPSType getCLIPSType() {
        return CLIPSType.FACT_ADDRESS;
    }

    public Environment getEnvironment() {
        return this.owner;
    }

    public long getFactAddress() {
        return this.getValue();
    }

    public PrimitiveValue getSlotValue(String string) {
        return Environment.getFactSlot(this, string);
    }

    public long getFactIndex() {
        return Environment.factIndex(this);
    }

    @Override
    public void retain() {
        this.owner.retainFact(this);
    }

    @Override
    public void release() {
        this.owner.releaseFact(this);
    }

    @Override
    public String toString() {
        return "<Fact-" + this.getFactIndex() + ">";
    }

    @Override
    public boolean isFactAddress() {
        return true;
    }
}

