/*
 * Decompiled with CFR 0.152.
 */
package net.sf.clipsrules.jni.examples.ide;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import net.sf.clipsrules.jni.Environment;

public class WatchMenu
extends JMenu
implements ActionListener,
MenuListener {
    private Environment clips;
    private static final String watchActivationsAction = "WatchActivations";
    private static final String watchCompilationsAction = "WatchCompilations";
    private static final String watchDeffunctionsAction = "WatchDeffunctions";
    private static final String watchFactsAction = "WatchFacts";
    private static final String watchFocusAction = "WatchFocus";
    private static final String watchGenericFunctionsAction = "WatchGenericFunctions";
    private static final String watchGlobalsAction = "WatchGlobals";
    private static final String watchInstancesAction = "WatchInstances";
    private static final String watchMessageHandlersAction = "WatchMessageHandlers";
    private static final String watchMessagesAction = "WatchMessages";
    private static final String watchMethodsAction = "WatchMethods";
    private static final String watchRulesAction = "WatchRules";
    private static final String watchSlotsAction = "WatchSlots";
    private static final String watchStatisticsAction = "WatchStatistics";
    private static final String watchAllAction = "WatchAll";
    private static final String watchNoneAction = "WatchNone";
    private JCheckBoxMenuItem jmiWatchActivations = null;
    private JCheckBoxMenuItem jmiWatchCompilations = null;
    private JCheckBoxMenuItem jmiWatchDeffunctions = null;
    private JCheckBoxMenuItem jmiWatchFacts = null;
    private JCheckBoxMenuItem jmiWatchFocus = null;
    private JCheckBoxMenuItem jmiWatchGenericFunctions = null;
    private JCheckBoxMenuItem jmiWatchGlobals = null;
    private JCheckBoxMenuItem jmiWatchInstances = null;
    private JCheckBoxMenuItem jmiWatchMessageHandlers = null;
    private JCheckBoxMenuItem jmiWatchMessages = null;
    private JCheckBoxMenuItem jmiWatchMethods = null;
    private JCheckBoxMenuItem jmiWatchRules = null;
    private JCheckBoxMenuItem jmiWatchSlots = null;
    private JCheckBoxMenuItem jmiWatchStatistics = null;
    private JMenuItem jmiWatchAll = null;
    private JMenuItem jmiWatchNone = null;

    WatchMenu(Environment environment) {
        super("Watch");
        this.clips = environment;
        this.addMenuListener(this);
        this.jmiWatchActivations = new JCheckBoxMenuItem("Activations");
        this.jmiWatchActivations.addActionListener(this);
        this.jmiWatchActivations.setActionCommand(watchActivationsAction);
        this.add(this.jmiWatchActivations);
        this.jmiWatchCompilations = new JCheckBoxMenuItem("Compilations");
        this.jmiWatchCompilations.addActionListener(this);
        this.jmiWatchCompilations.setActionCommand(watchCompilationsAction);
        this.add(this.jmiWatchCompilations);
        this.jmiWatchDeffunctions = new JCheckBoxMenuItem("Deffunctions");
        this.jmiWatchDeffunctions.addActionListener(this);
        this.jmiWatchDeffunctions.setActionCommand(watchDeffunctionsAction);
        this.add(this.jmiWatchDeffunctions);
        this.jmiWatchFacts = new JCheckBoxMenuItem("Facts");
        this.jmiWatchFacts.addActionListener(this);
        this.jmiWatchFacts.setActionCommand(watchFactsAction);
        this.add(this.jmiWatchFacts);
        this.jmiWatchFocus = new JCheckBoxMenuItem("Focus");
        this.jmiWatchFocus.addActionListener(this);
        this.jmiWatchFocus.setActionCommand(watchFocusAction);
        this.add(this.jmiWatchFocus);
        this.jmiWatchGenericFunctions = new JCheckBoxMenuItem("Generic Functions");
        this.jmiWatchGenericFunctions.addActionListener(this);
        this.jmiWatchGenericFunctions.setActionCommand(watchGenericFunctionsAction);
        this.add(this.jmiWatchGenericFunctions);
        this.jmiWatchGlobals = new JCheckBoxMenuItem("Globals");
        this.jmiWatchGlobals.addActionListener(this);
        this.jmiWatchGlobals.setActionCommand(watchGlobalsAction);
        this.add(this.jmiWatchGlobals);
        this.jmiWatchInstances = new JCheckBoxMenuItem("Instances");
        this.jmiWatchInstances.addActionListener(this);
        this.jmiWatchInstances.setActionCommand(watchInstancesAction);
        this.add(this.jmiWatchInstances);
        this.jmiWatchMessageHandlers = new JCheckBoxMenuItem("Message Handlers");
        this.jmiWatchMessageHandlers.addActionListener(this);
        this.jmiWatchMessageHandlers.setActionCommand(watchMessageHandlersAction);
        this.add(this.jmiWatchMessageHandlers);
        this.jmiWatchMessages = new JCheckBoxMenuItem("Messages");
        this.jmiWatchMessages.addActionListener(this);
        this.jmiWatchMessages.setActionCommand(watchMessagesAction);
        this.add(this.jmiWatchMessages);
        this.jmiWatchMethods = new JCheckBoxMenuItem("Methods");
        this.jmiWatchMethods.addActionListener(this);
        this.jmiWatchMethods.setActionCommand(watchMethodsAction);
        this.add(this.jmiWatchMethods);
        this.jmiWatchRules = new JCheckBoxMenuItem("Rules");
        this.jmiWatchRules.addActionListener(this);
        this.jmiWatchRules.setActionCommand(watchRulesAction);
        this.add(this.jmiWatchRules);
        this.jmiWatchSlots = new JCheckBoxMenuItem("Slots");
        this.jmiWatchSlots.addActionListener(this);
        this.jmiWatchSlots.setActionCommand(watchSlotsAction);
        this.add(this.jmiWatchSlots);
        this.jmiWatchStatistics = new JCheckBoxMenuItem("Statistics");
        this.jmiWatchStatistics.addActionListener(this);
        this.jmiWatchStatistics.setActionCommand(watchStatisticsAction);
        this.add(this.jmiWatchStatistics);
        this.addSeparator();
        this.jmiWatchAll = new JMenuItem("All");
        this.jmiWatchAll.addActionListener(this);
        this.jmiWatchAll.setActionCommand(watchAllAction);
        this.add(this.jmiWatchAll);
        this.jmiWatchNone = new JMenuItem("None");
        this.jmiWatchNone.addActionListener(this);
        this.jmiWatchNone.setActionCommand(watchNoneAction);
        this.add(this.jmiWatchNone);
    }

    public void onActionPerformed(ActionEvent actionEvent) throws Exception {
        if (actionEvent.getActionCommand().equals(watchActivationsAction)) {
            this.toggleWatch("activations");
        } else if (actionEvent.getActionCommand().equals(watchCompilationsAction)) {
            this.toggleWatch("compilations");
        } else if (actionEvent.getActionCommand().equals(watchDeffunctionsAction)) {
            this.toggleWatch("deffunctions");
        } else if (actionEvent.getActionCommand().equals(watchFactsAction)) {
            this.toggleWatch("facts");
        } else if (actionEvent.getActionCommand().equals(watchFocusAction)) {
            this.toggleWatch("focus");
        } else if (actionEvent.getActionCommand().equals(watchGenericFunctionsAction)) {
            this.toggleWatch("generic-functions");
        } else if (actionEvent.getActionCommand().equals(watchGlobalsAction)) {
            this.toggleWatch("globals");
        } else if (actionEvent.getActionCommand().equals(watchInstancesAction)) {
            this.toggleWatch("instances");
        } else if (actionEvent.getActionCommand().equals(watchMessageHandlersAction)) {
            this.toggleWatch("message-handlers");
        } else if (actionEvent.getActionCommand().equals(watchMessagesAction)) {
            this.toggleWatch("messages");
        } else if (actionEvent.getActionCommand().equals(watchMethodsAction)) {
            this.toggleWatch("methods");
        } else if (actionEvent.getActionCommand().equals(watchRulesAction)) {
            this.toggleWatch("rules");
        } else if (actionEvent.getActionCommand().equals(watchSlotsAction)) {
            this.toggleWatch("slots");
        } else if (actionEvent.getActionCommand().equals(watchStatisticsAction)) {
            this.toggleWatch("statistics");
        } else if (actionEvent.getActionCommand().equals(watchAllAction)) {
            this.watchAll();
        } else if (actionEvent.getActionCommand().equals(watchNoneAction)) {
            this.watchNone();
        }
    }

    public void toggleWatch(String string) {
        boolean bl = this.clips.getWatchItem(string);
        this.clips.setWatchItem(string, !bl);
    }

    public void watchAll() {
        this.clips.watch("all");
    }

    public void watchNone() {
        this.clips.unwatch("all");
    }

    public void updateWatchMenu() {
        if (this.clips.getWatchItem("activations")) {
            this.jmiWatchActivations.setState(true);
        } else {
            this.jmiWatchActivations.setState(false);
        }
        if (this.clips.getWatchItem("compilations")) {
            this.jmiWatchCompilations.setState(true);
        } else {
            this.jmiWatchCompilations.setState(false);
        }
        if (this.clips.getWatchItem("deffunctions")) {
            this.jmiWatchDeffunctions.setState(true);
        } else {
            this.jmiWatchDeffunctions.setState(false);
        }
        if (this.clips.getWatchItem("facts")) {
            this.jmiWatchFacts.setState(true);
        } else {
            this.jmiWatchFacts.setState(false);
        }
        if (this.clips.getWatchItem("focus")) {
            this.jmiWatchFocus.setState(true);
        } else {
            this.jmiWatchFocus.setState(false);
        }
        if (this.clips.getWatchItem("generic-functions")) {
            this.jmiWatchGenericFunctions.setState(true);
        } else {
            this.jmiWatchGenericFunctions.setState(false);
        }
        if (this.clips.getWatchItem("globals")) {
            this.jmiWatchGlobals.setState(true);
        } else {
            this.jmiWatchGlobals.setState(false);
        }
        if (this.clips.getWatchItem("instances")) {
            this.jmiWatchInstances.setState(true);
        } else {
            this.jmiWatchInstances.setState(false);
        }
        if (this.clips.getWatchItem("message-handlers")) {
            this.jmiWatchMessageHandlers.setState(true);
        } else {
            this.jmiWatchMessageHandlers.setState(false);
        }
        if (this.clips.getWatchItem("messages")) {
            this.jmiWatchMessages.setState(true);
        } else {
            this.jmiWatchMessages.setState(false);
        }
        if (this.clips.getWatchItem("methods")) {
            this.jmiWatchMethods.setState(true);
        } else {
            this.jmiWatchMethods.setState(false);
        }
        if (this.clips.getWatchItem("rules")) {
            this.jmiWatchRules.setState(true);
        } else {
            this.jmiWatchRules.setState(false);
        }
        if (this.clips.getWatchItem("slots")) {
            this.jmiWatchSlots.setState(true);
        } else {
            this.jmiWatchSlots.setState(false);
        }
        if (this.clips.getWatchItem("statistics")) {
            this.jmiWatchStatistics.setState(true);
        } else {
            this.jmiWatchStatistics.setState(false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        try {
            this.onActionPerformed(actionEvent);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void menuCanceled(MenuEvent menuEvent) {
    }

    @Override
    public void menuSelected(MenuEvent menuEvent) {
        this.updateWatchMenu();
    }

    @Override
    public void menuDeselected(MenuEvent menuEvent) {
    }
}

