/*
 * Decompiled with CFR 0.152.
 */
package net.sf.clipsrules.jni.examples.ide;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.Border;
import net.sf.clipsrules.jni.examples.ide.FontDialog;
import net.sf.clipsrules.jni.examples.ide.FontSample;

public class FontPreferencesDialog
extends JDialog
implements ActionListener {
    HashMap<String, Font> fonts;
    HashMap<String, FontSample> samples;
    HashMap<String, Font> originalFonts;
    private static final String dialogFontDesc = "Set the dialog window font";
    private static final String editorFontDesc = "Set the editor window font";
    private static final String browserFontDesc = "Set the browser window font";

    public FontPreferencesDialog(Frame frame, String string, HashMap<String, Font> hashMap) {
        super(frame, string, true);
        this.fonts = hashMap;
        this.samples = new HashMap();
        this.originalFonts = new HashMap<String, Font>(this.fonts);
        JPanel jPanel = this.createFontDialogBox("dialog");
        JPanel jPanel2 = this.createFontDialogBox("editor");
        JPanel jPanel3 = this.createFontDialogBox("browser");
        Border border = BorderFactory.createEmptyBorder(20, 20, 5, 20);
        jPanel.setBorder(border);
        jPanel2.setBorder(border);
        jPanel3.setBorder(border);
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.addTab("Dialog", null, jPanel, dialogFontDesc);
        jTabbedPane.addTab("Editor", null, jPanel2, editorFontDesc);
        jTabbedPane.addTab("Browser", null, jPanel3, browserFontDesc);
        this.add((Component)jTabbedPane, "Center");
        JButton jButton = new JButton("Defaults");
        jButton.addActionListener(this);
        jButton.setActionCommand("Defaults");
        JButton jButton2 = new JButton("Cancel");
        jButton2.addActionListener(this);
        jButton2.setActionCommand("Cancel");
        JButton jButton3 = new JButton("Done");
        jButton3.addActionListener(this);
        jButton3.setActionCommand("Done");
        this.getRootPane().setDefaultButton(jButton3);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 2));
        jPanel4.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel4.add(jButton);
        jPanel4.add(Box.createHorizontalGlue());
        jPanel4.add(jButton2);
        jPanel4.add(Box.createRigidArea(new Dimension(10, 0)));
        jPanel4.add(jButton3);
        this.add((Component)jPanel4, "South");
        this.pack();
        this.setLocationRelativeTo(frame);
    }

    private JPanel createFontDialogBox(final String string) {
        JButton jButton = new JButton("Change...");
        JFrame jFrame = (JFrame)this.getParent();
        JLabel jLabel = new JLabel("Font:");
        final FontSample fontSample = new FontSample(this.fonts.get(string), 2);
        this.samples.put(string, fontSample);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 2));
        jPanel.add(jLabel);
        jPanel.add(Box.createHorizontalStrut(10));
        jPanel.add(jButton);
        jPanel.add(Box.createHorizontalGlue());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 3));
        jPanel2.add(jPanel);
        jPanel2.add(Box.createVerticalStrut(10));
        jPanel2.add(fontSample);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FontDialog fontDialog = new FontDialog(FontPreferencesDialog.this, (Component)FontPreferencesDialog.this, "Font Chooser", FontPreferencesDialog.this.fonts.get(string));
                Font font = fontDialog.showDialog();
                if (font != null) {
                    fontSample.refreshSampleText(font);
                    FontPreferencesDialog.this.fonts.put(string, font);
                }
            }
        });
        return jPanel2;
    }

    public HashMap<String, Font> showDialog(HashMap<String, Font> hashMap) {
        this.setMinimumSize(new Dimension(390, 170));
        this.setVisible(true);
        return hashMap;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if ("Defaults".equals(actionEvent.getActionCommand())) {
            Font font = new Font("Monospaced", 0, 12);
            Font font2 = new Font("Monospaced", 0, 12);
            Font font3 = new Font("Dialog", 0, 12);
            this.fonts.put("dialog", font);
            this.fonts.put("editor", font2);
            this.fonts.put("browser", font3);
            this.samples.get("dialog").refreshSampleText(font);
            this.samples.get("editor").refreshSampleText(font2);
            this.samples.get("browser").refreshSampleText(font3);
        } else if ("Done".equals(actionEvent.getActionCommand())) {
            this.setVisible(false);
        } else if ("Cancel".equals(actionEvent.getActionCommand())) {
            this.fonts.putAll(this.originalFonts);
            this.setVisible(false);
        }
    }
}

