/*
 * Decompiled with CFR 0.152.
 */
package net.sf.clipsrules.jni.examples.ide;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import net.sf.clipsrules.jni.CommandExecutionEvent;
import net.sf.clipsrules.jni.CommandExecutionListener;
import net.sf.clipsrules.jni.Environment;
import net.sf.clipsrules.jni.PrimitiveValue;
import net.sf.clipsrules.jni.UserFunction;
import net.sf.clipsrules.jni.UserFunctionExamples;
import net.sf.clipsrules.jni.examples.ide.AgendaBrowserFrame;
import net.sf.clipsrules.jni.examples.ide.AgendaBrowserManager;
import net.sf.clipsrules.jni.examples.ide.BoundsDesktopManager;
import net.sf.clipsrules.jni.examples.ide.ConstructInspectorFrame;
import net.sf.clipsrules.jni.examples.ide.DialogFrame;
import net.sf.clipsrules.jni.examples.ide.EditMenu;
import net.sf.clipsrules.jni.examples.ide.EntityBrowserFrame;
import net.sf.clipsrules.jni.examples.ide.EnvironmentMenu;
import net.sf.clipsrules.jni.examples.ide.FactBrowserManager;
import net.sf.clipsrules.jni.examples.ide.FileMenu;
import net.sf.clipsrules.jni.examples.ide.FramePlacer;
import net.sf.clipsrules.jni.examples.ide.HelpMenu;
import net.sf.clipsrules.jni.examples.ide.IDEPreferences;
import net.sf.clipsrules.jni.examples.ide.InstanceBrowserManager;
import net.sf.clipsrules.jni.examples.ide.TextFrame;
import net.sf.clipsrules.jni.examples.ide.TextMenu;
import net.sf.clipsrules.jni.examples.ide.WatchMenu;

public class CLIPSIDE
extends JFrame
implements ActionListener,
CommandExecutionListener,
MenuListener,
InternalFrameListener {
    private static final String windowProperty = "windowProperty";
    private static final String menuItemProperty = "menuItemProperty";
    static final String selectWindowAction = "SelectWindow";
    private FileMenu jmFile;
    private EditMenu jmEdit;
    private TextMenu jmText;
    private EnvironmentMenu jmEnvironment;
    private JMenu jmWindow;
    private IDEPreferences preferences;
    private JMenuItem jmiAgendaBrowser;
    private JMenuItem jmiFactBrowser;
    private JMenuItem jmiInstanceBrowser;
    private JMenuItem jmiConstructInspector;
    private Environment clips;
    private ConstructInspectorFrame constructInspector;
    private FramePlacer placer;
    private AgendaBrowserManager agendaBrowserManager;
    private FactBrowserManager factBrowserManager;
    private InstanceBrowserManager instanceBrowserManager;
    private DialogFrame dialogWindow;
    private JDesktopPane ideDesktopPane;

    CLIPSIDE() {
        super("CLIPS IDE");
        try {
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.preferences = new IDEPreferences();
        this.clips = new Environment();
        this.createMenuBar(this.clips);
        this.ideDesktopPane = new JDesktopPane();
        this.ideDesktopPane.setDesktopManager(new BoundsDesktopManager());
        this.add(this.ideDesktopPane);
        this.setDefaultCloseOperation(0);
        this.createWindowClosingAdaptor();
        this.setLocation(50, 50);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setSize((int)((double)dimension.width * 0.8), (int)((double)dimension.height * 0.8));
        this.setVisible(true);
        this.placer = new FramePlacer(this.ideDesktopPane);
        this.createDialogWindow(this.clips);
        this.dialogWindow.addCommandExecutionListener(this);
        this.jmEnvironment.setDialog(this.dialogWindow);
        this.agendaBrowserManager = new AgendaBrowserManager(this);
        this.factBrowserManager = new FactBrowserManager(this);
        this.instanceBrowserManager = new InstanceBrowserManager(this);
        this.clips.addUserFunction("clear-window", "v", 0, 0, null, new UserFunction(){

            @Override
            public PrimitiveValue evaluate(List<PrimitiveValue> list) {
                CLIPSIDE.this.dialogWindow.clearScrollback();
                return null;
            }
        });
        UserFunctionExamples.addUserFunctions(this.clips);
    }

    private void createWindowClosingAdaptor() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                int n = 0;
                int n2 = CLIPSIDE.this.jmWindow.getItemCount();
                for (int i = 0; i < n2; ++i) {
                    TextFrame textFrame;
                    JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)CLIPSIDE.this.jmWindow.getItem(i);
                    JInternalFrame jInternalFrame = (JInternalFrame)jCheckBoxMenuItem.getClientProperty(CLIPSIDE.windowProperty);
                    if (!(jInternalFrame instanceof TextFrame) || !(textFrame = (TextFrame)jInternalFrame).isChanged()) continue;
                    ++n;
                }
                if (n == 1) {
                    int n3 = JOptionPane.showConfirmDialog(null, "You have a document with unsaved changes. Do you want to quit?", null, 0);
                    if (n3 == 0) {
                        CLIPSIDE.this.dispose();
                        System.exit(0);
                    }
                } else if (n > 1) {
                    int n4 = JOptionPane.showConfirmDialog(null, "You have " + n + " documents with unsaved changes. Do you want to quit?", null, 0);
                    if (n4 == 0) {
                        CLIPSIDE.this.dispose();
                        System.exit(0);
                    }
                } else {
                    CLIPSIDE.this.dispose();
                    System.exit(0);
                }
            }
        });
    }

    public IDEPreferences getPreferences() {
        return this.preferences;
    }

    public Environment getEnvironment() {
        return this.clips;
    }

    public DialogFrame getDialogWindow() {
        return this.dialogWindow;
    }

    public JDesktopPane getDesktopPane() {
        return this.ideDesktopPane;
    }

    public ConstructInspectorFrame getConstructInspector() {
        return this.constructInspector;
    }

    public FramePlacer getPlacer() {
        return this.placer;
    }

    public void createDialogWindow(Environment environment) {
        this.dialogWindow = new DialogFrame(environment, this.preferences.getCurrentDirectory(), this.preferences.getDialogFont());
        this.dialogWindow.addInternalFrameListener(this);
        this.placer.placeInternalFrame(this.dialogWindow);
        this.ideDesktopPane.add(this.dialogWindow);
        this.dialogWindow.setVisible(true);
    }

    public void selectDialogWindow() {
        try {
            this.dialogWindow.setSelected(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        CLIPSIDE cLIPSIDE = new CLIPSIDE();
    }

    public void assignBrowserFont(Font font) {
        this.agendaBrowserManager.assignFontAllBrowsers(font);
        this.factBrowserManager.assignFontAllBrowsers(font);
        this.instanceBrowserManager.assignFontAllBrowsers(font);
    }

    public void assignEditorFont(Font font) {
        int n = this.jmWindow.getItemCount();
        for (int i = 0; i < n; ++i) {
            JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)this.jmWindow.getItem(i);
            JInternalFrame jInternalFrame = (JInternalFrame)jCheckBoxMenuItem.getClientProperty(windowProperty);
            if (!(jInternalFrame instanceof TextFrame)) continue;
            TextFrame textFrame = (TextFrame)jInternalFrame;
            textFrame.assignFont(font);
        }
        if (this.constructInspector != null) {
            this.constructInspector.setFont(font);
        }
    }

    @Override
    public void commandExecutionEventOccurred(CommandExecutionEvent commandExecutionEvent) {
        if (commandExecutionEvent.getExecutionEvent().equals("start")) {
            this.agendaBrowserManager.updateAgendaBrowserButtons(true);
        }
        if (commandExecutionEvent.getExecutionEvent().equals("finish")) {
            this.agendaBrowserManager.updateAgendaBrowserButtons(false);
        }
        if (commandExecutionEvent.getExecutionEvent().equals("periodic") || commandExecutionEvent.getExecutionEvent().equals("finish")) {
            if (this.dialogWindow.getEnvironment().getAgendaChanged() || this.dialogWindow.getEnvironment().getFocusChanged()) {
                this.dialogWindow.getEnvironment().setAgendaChanged(false);
                this.dialogWindow.getEnvironment().setFocusChanged(false);
                this.agendaBrowserManager.updateAllBrowsers();
            }
            if (this.dialogWindow.getEnvironment().getFactListChanged()) {
                this.dialogWindow.getEnvironment().setFactListChanged(false);
                this.factBrowserManager.updateAllBrowsers();
            }
            if (this.dialogWindow.getEnvironment().getInstancesChanged()) {
                this.dialogWindow.getEnvironment().setInstancesChanged(false);
                this.instanceBrowserManager.updateAllBrowsers();
            }
        }
    }

    public void executeBatch() {
        this.dialogWindow.executeBatch();
    }

    public void onActionPerformed(ActionEvent actionEvent) throws Exception {
        if (actionEvent.getSource() == this.jmiAgendaBrowser) {
            this.agendaBrowserManager.createBrowser(this.preferences.getBrowserFont());
        } else if (actionEvent.getSource() == this.jmiFactBrowser) {
            this.factBrowserManager.createBrowser(this.preferences.getBrowserFont());
        } else if (actionEvent.getSource() == this.jmiInstanceBrowser) {
            this.instanceBrowserManager.createBrowser(this.preferences.getBrowserFont());
        } else if (actionEvent.getSource() == this.jmiConstructInspector) {
            this.constructInspector();
        } else if (actionEvent.getActionCommand().equals(selectWindowAction)) {
            this.selectWindow(actionEvent.getSource());
        }
    }

    public void constructInspector() {
        String string = "";
        if (this.constructInspector != null) {
            return;
        }
        JInternalFrame jInternalFrame = this.ideDesktopPane.getSelectedFrame();
        if (jInternalFrame instanceof AgendaBrowserFrame) {
            string = this.agendaBrowserManager.browserSelectionText((AgendaBrowserFrame)jInternalFrame);
        } else if (jInternalFrame instanceof EntityBrowserFrame) {
            EntityBrowserFrame entityBrowserFrame = (EntityBrowserFrame)jInternalFrame;
            if (entityBrowserFrame.getEntityName().equals("Fact")) {
                string = this.factBrowserManager.browserSelectionText(entityBrowserFrame);
            } else if (entityBrowserFrame.getEntityName().equals("Instance")) {
                string = this.instanceBrowserManager.browserSelectionText(entityBrowserFrame);
            }
        }
        this.constructInspector = new ConstructInspectorFrame(this.preferences.getEditorFont());
        this.constructInspector.setText(string);
        this.constructInspector.addInternalFrameListener(this);
        this.constructInspector.setLocation(10, 10);
        this.ideDesktopPane.add((Component)this.constructInspector, JLayeredPane.PALETTE_LAYER);
        this.constructInspector.setVisible(true);
    }

    public void selectWindow(Object object) {
        JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)object;
        JInternalFrame jInternalFrame = (JInternalFrame)jCheckBoxMenuItem.getClientProperty(windowProperty);
        if (jInternalFrame.isSelected()) {
            jCheckBoxMenuItem.setState(true);
            return;
        }
        try {
            jInternalFrame.setSelected(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        try {
            this.onActionPerformed(actionEvent);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void menuCanceled(MenuEvent menuEvent) {
    }

    @Override
    public void menuSelected(MenuEvent menuEvent) {
        if (this.constructInspector == null) {
            this.jmiConstructInspector.setEnabled(true);
        } else {
            this.jmiConstructInspector.setEnabled(false);
        }
        JInternalFrame jInternalFrame = this.ideDesktopPane.getSelectedFrame();
        if (jInternalFrame == null || jInternalFrame.isIcon()) {
            return;
        }
    }

    @Override
    public void menuDeselected(MenuEvent menuEvent) {
    }

    @Override
    public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
        JInternalFrame jInternalFrame = internalFrameEvent.getInternalFrame();
        if (jInternalFrame instanceof TextFrame) {
            TextFrame textFrame = (TextFrame)jInternalFrame;
            textFrame.closeTextFrame(this.preferences);
        }
    }

    @Override
    public void internalFrameClosed(InternalFrameEvent internalFrameEvent) {
        JComponent jComponent;
        JInternalFrame jInternalFrame = internalFrameEvent.getInternalFrame();
        jInternalFrame.removeInternalFrameListener(this);
        if (jInternalFrame instanceof ConstructInspectorFrame) {
            this.constructInspector = null;
            return;
        }
        if (jInternalFrame instanceof TextFrame) {
            this.jmText.setTextFrame(null);
        } else if (jInternalFrame instanceof AgendaBrowserFrame) {
            this.agendaBrowserManager.removeBrowser((AgendaBrowserFrame)jInternalFrame);
        } else if (jInternalFrame instanceof EntityBrowserFrame) {
            jComponent = (EntityBrowserFrame)jInternalFrame;
            if (((EntityBrowserFrame)jComponent).getEntityName().equals("Fact")) {
                this.factBrowserManager.removeBrowser((EntityBrowserFrame)jComponent);
            } else if (((EntityBrowserFrame)jComponent).getEntityName().equals("Instance")) {
                this.instanceBrowserManager.removeBrowser((EntityBrowserFrame)jComponent);
            }
        }
        jComponent = (JCheckBoxMenuItem)jInternalFrame.getClientProperty(menuItemProperty);
        jInternalFrame.putClientProperty(menuItemProperty, null);
        jComponent.putClientProperty(windowProperty, null);
        this.jmWindow.remove((JMenuItem)jComponent);
    }

    @Override
    public void internalFrameOpened(InternalFrameEvent internalFrameEvent) {
        JInternalFrame jInternalFrame = internalFrameEvent.getInternalFrame();
        if (jInternalFrame instanceof ConstructInspectorFrame) {
            return;
        }
        if (jInternalFrame instanceof TextFrame) {
            this.jmText.setTextFrame((TextFrame)jInternalFrame);
        } else {
            this.jmText.setTextFrame(null);
        }
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(jInternalFrame.getTitle());
        jCheckBoxMenuItem.setState(false);
        jCheckBoxMenuItem.putClientProperty(windowProperty, jInternalFrame);
        jCheckBoxMenuItem.addActionListener(this);
        jCheckBoxMenuItem.setActionCommand(selectWindowAction);
        this.jmWindow.add(jCheckBoxMenuItem);
        jInternalFrame.putClientProperty(menuItemProperty, jCheckBoxMenuItem);
    }

    @Override
    public void internalFrameIconified(InternalFrameEvent internalFrameEvent) {
        JInternalFrame jInternalFrame = internalFrameEvent.getInternalFrame();
        if (jInternalFrame instanceof ConstructInspectorFrame) {
            return;
        }
        if (jInternalFrame instanceof TextFrame) {
            this.jmText.setTextFrame(null);
        }
        JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)jInternalFrame.getClientProperty(menuItemProperty);
        jCheckBoxMenuItem.setState(false);
    }

    @Override
    public void internalFrameDeiconified(InternalFrameEvent internalFrameEvent) {
        JInternalFrame jInternalFrame = internalFrameEvent.getInternalFrame();
        if (jInternalFrame instanceof ConstructInspectorFrame) {
            return;
        }
        if (jInternalFrame instanceof TextFrame) {
            this.jmText.setTextFrame((TextFrame)jInternalFrame);
        } else {
            this.jmText.setTextFrame(null);
        }
        JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)jInternalFrame.getClientProperty(menuItemProperty);
        jCheckBoxMenuItem.setState(true);
    }

    @Override
    public void internalFrameActivated(InternalFrameEvent internalFrameEvent) {
        Object object;
        JInternalFrame jInternalFrame = internalFrameEvent.getInternalFrame();
        if (jInternalFrame instanceof ConstructInspectorFrame) {
            return;
        }
        if (jInternalFrame instanceof TextFrame) {
            this.jmText.setTextFrame((TextFrame)jInternalFrame);
        } else {
            this.jmText.setTextFrame(null);
        }
        if (this.constructInspector != null) {
            if (jInternalFrame instanceof AgendaBrowserFrame) {
                object = this.agendaBrowserManager.browserSelectionText((AgendaBrowserFrame)jInternalFrame);
                this.constructInspector.setText((String)object);
            } else if (jInternalFrame instanceof EntityBrowserFrame) {
                object = (EntityBrowserFrame)jInternalFrame;
                if (((EntityBrowserFrame)object).getEntityName().equals("Fact")) {
                    String string = this.factBrowserManager.browserSelectionText((EntityBrowserFrame)object);
                    this.constructInspector.setText(string);
                } else if (((EntityBrowserFrame)object).getEntityName().equals("Instance")) {
                    String string = this.instanceBrowserManager.browserSelectionText((EntityBrowserFrame)object);
                    this.constructInspector.setText(string);
                }
            }
        }
        object = (JCheckBoxMenuItem)jInternalFrame.getClientProperty(menuItemProperty);
        ((JCheckBoxMenuItem)object).setState(true);
    }

    @Override
    public void internalFrameDeactivated(InternalFrameEvent internalFrameEvent) {
        JInternalFrame jInternalFrame = internalFrameEvent.getInternalFrame();
        if (jInternalFrame instanceof ConstructInspectorFrame) {
            return;
        }
        if (jInternalFrame instanceof TextFrame) {
            this.jmText.setTextFrame(null);
        }
        JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)jInternalFrame.getClientProperty(menuItemProperty);
        jCheckBoxMenuItem.setState(false);
    }

    private void createMenuBar(Environment environment) {
        JMenuBar jMenuBar = new JMenuBar();
        this.jmFile = new FileMenu(this);
        jMenuBar.add(this.jmFile);
        this.jmEdit = new EditMenu(this);
        jMenuBar.add(this.jmEdit);
        this.jmText = new TextMenu(this, null);
        jMenuBar.add(this.jmText);
        this.jmEnvironment = new EnvironmentMenu(this.preferences);
        jMenuBar.add(this.jmEnvironment);
        JMenu jMenu = new JMenu("Debug");
        jMenu.addMenuListener(this);
        jMenu.add(new WatchMenu(environment));
        jMenu.addSeparator();
        this.jmiAgendaBrowser = new JMenuItem("Agenda Browser");
        this.jmiAgendaBrowser.addActionListener(this);
        jMenu.add(this.jmiAgendaBrowser);
        this.jmiFactBrowser = new JMenuItem("Fact Browser");
        this.jmiFactBrowser.addActionListener(this);
        jMenu.add(this.jmiFactBrowser);
        this.jmiInstanceBrowser = new JMenuItem("Instance Browser");
        this.jmiInstanceBrowser.addActionListener(this);
        jMenu.add(this.jmiInstanceBrowser);
        this.jmiConstructInspector = new JMenuItem("Construct Inspector");
        this.jmiConstructInspector.addActionListener(this);
        jMenu.add(this.jmiConstructInspector);
        jMenuBar.add(jMenu);
        this.jmWindow = new JMenu("Window");
        this.jmWindow.addMenuListener(this);
        jMenuBar.add(this.jmWindow);
        jMenuBar.add(new HelpMenu(this));
        this.setJMenuBar(jMenuBar);
    }
}

