(import (core) (test-lite))

(test-begin "Test Arithmetics")
(newline)

;(define (SECTION . x) (test-comment x))
(define (SECTION . x) #t)

(SECTION "number format")
(test-equal (equal? 3000 3000.0) #f)
(test-equal (string->number "-") #f)
(test-equal (string->number "+") #f)
(test-equal (string->number "e")  #f)
(test-equal (string->number ".") #f)
(test-equal (string->number "10+") #f)
(test-equal (string->number "10-") #f)
(test-equal (string->number "10e") #f)
(test-equal (string->number "e+10") #f)
(test-equal (string->number "e-10") #f)
(test-equal (string->number "+e") #f)
(test-equal (string->number "-e") #f)
(test-equal (string->number ".e+5") #f)
(test-equal (string->number "i") #f)
;(test-equal (string->number "1####.3") #f)
;(test-equal (string->number "1####4##") #f)

(test-equal (string->number "100/1") 100)
(test-equal (string->number "0/100") 0)
(test-equal (string->number ".3e+5") 30000.0)
(test-equal (string->number "10.") 10.0)
(test-equal (string->number ".5") 0.5)
(test-equal (string->number "1e5") 100000.0)
(test-equal (string->number "1e+5") 100000.0)
(test-equal (string->number "1.e5") 100000.0)
(test-equal (string->number "1.e+5") 100000.0)
;(test-equal (string->number "1231####") 1231####.#)

(test-equal (string->number "#e1e+5") 100000)
(test-equal (string->number "#e1.e+5") 100000)
(test-equal (string->number "#e12345.0") 12345)
(test-equal (string->number "#e0.25") 1/4)
;(test-equal (string->number "#e1231####.#") #e1231####)
;(test-equal (string->number "#e1231####.#e+2") 1231000000)
;(test-equal (string->number "#e1231####.#e+10") 123100000000000000)
;(test-equal (string->number "#e1231####.#e-20") 1231/10000000000000000)
;(test-equal (string->number "10000/4000") 5/2)
;(test-equal (string->number "1####/4###") 2.5)


(SECTION "binary basic fixnum")
(test-equal (+ 5 3) 8)
(test-equal (+ -5 3) -2)
(test-equal (+ 5 -3) 2)
(test-equal (+ -5 -3) -8)
(test-equal (- 5 3) 2)
(test-equal (- -5 3) -8)
(test-equal (- 5 -3) 8)
(test-equal (- -5 -3) -2)
(test-equal (* 5 3) 15)
(test-equal (* -5 3) -15)
(test-equal (* 5 -3) -15)
(test-equal (* -5 -3) 15)
(test-equal (/ 5 3) 5/3)
(test-equal (/ -5 3) -5/3)
(test-equal (/ 5 -3) -5/3)
(test-equal (/ -5 -3) 5/3)
(test-equal (quotient 5 3) 1)
(test-equal (quotient -5 3) -1)
(test-equal (quotient 5 -3) -1)
(test-equal (quotient -5 -3) 1)
(test-equal (modulo 5 3) 2)
(test-equal (modulo -5 3) 1)
(test-equal (modulo 5 -3) -1)
(test-equal (modulo -5 -3) -2)
(test-equal (remainder 5 3) 2)
(test-equal (remainder -5 3) -2)
(test-equal (remainder 5 -3) 2)
(test-equal (remainder -5 -3) -2)

(SECTION "binary basic bignum")
(test-equal (+ 50000000000 30000000000) 80000000000)
(test-equal (+ -50000000000 30000000000) -20000000000)
(test-equal (+ 50000000000 -30000000000) 20000000000)
(test-equal (+ -50000000000 -30000000000) -80000000000)
(test-equal (- 50000000000 30000000000) 20000000000)
(test-equal (- -50000000000 30000000000) -80000000000)
(test-equal (- 50000000000 -30000000000) 80000000000)
(test-equal (- -50000000000 -30000000000) -20000000000)
(test-equal (* 50000000000 30000000000) 1500000000000000000000)
(test-equal (* -50000000000 30000000000) -1500000000000000000000)
(test-equal (* 50000000000 -30000000000) -1500000000000000000000)
(test-equal (* -50000000000 -30000000000) 1500000000000000000000)
(test-equal (/ 50000000000 30000000000) 5/3)
(test-equal (/ -50000000000 30000000000) -5/3)
(test-equal (/ 50000000000 -30000000000) -5/3)
(test-equal (/ -50000000000 -30000000000) 5/3)
(test-equal (quotient 50000000000 30000000000) 1)
(test-equal (quotient -50000000000 30000000000) -1)
(test-equal (quotient 50000000000 -30000000000) -1)
(test-equal (quotient -50000000000 -30000000000) 1)
(test-equal (modulo 50000000000 30000000000) 20000000000)
(test-equal (modulo -50000000000 30000000000) 10000000000)
(test-equal (modulo 50000000000 -30000000000) -10000000000)
(test-equal (modulo -50000000000 -30000000000) -20000000000)
(test-equal (remainder 50000000000 30000000000) 20000000000)
(test-equal (remainder -50000000000 30000000000) -20000000000)
(test-equal (remainder 50000000000 -30000000000) 20000000000)
(test-equal (remainder -50000000000 -30000000000) -20000000000) ; //

(SECTION "binary basic mix 1")
(test-equal (+ 34343 3748345893498345) 3748345893532688)
(test-equal (+ -34343 3748345893498345) 3748345893464002)
(test-equal (+ 34343 -3748345893498345) -3748345893464002)
(test-equal (+ -34343 -3748345893498345) -3748345893532688)
(test-equal (- 34343 3748345893498345) -3748345893464002)
(test-equal (- -34343 3748345893498345) -3748345893532688)
(test-equal (- 34343 -3748345893498345) 3748345893532688)
(test-equal (- -34343 -3748345893498345) 3748345893464002)
(test-equal (* 34343 3748345893498345) 128729443020413662335)
(test-equal (* -34343 3748345893498345) -128729443020413662335)
(test-equal (* 34343 -3748345893498345) -128729443020413662335)
(test-equal (* -34343 -3748345893498345) 128729443020413662335)
(test-equal (/ 34343 3748345893498345) 34343/3748345893498345)
(test-equal (/ -34343 3748345893498345) -34343/3748345893498345)
(test-equal (/ 34343 -3748345893498345) -34343/3748345893498345)
(test-equal (/ -34343 -3748345893498345) 34343/3748345893498345)
(test-equal (quotient 34343 3748345893498345) 0)
(test-equal (quotient -34343 3748345893498345) 0)
(test-equal (quotient 34343 -3748345893498345) 0)
(test-equal (quotient -34343 -3748345893498345) 0)
(test-equal (modulo 34343 3748345893498345) 34343)
(test-equal (modulo -34343 3748345893498345) 3748345893464002)
(test-equal (modulo 34343 -3748345893498345) -3748345893464002)
(test-equal (modulo -34343 -3748345893498345) -34343)
(test-equal (remainder 34343 3748345893498345) 34343)
(test-equal (remainder -34343 3748345893498345) -34343)
(test-equal (remainder 34343 -3748345893498345) 34343)
(test-equal (remainder -34343 -3748345893498345) -34343)

(SECTION "binary basic mix 2")
(test-equal (+ 3748345893498345 34343) 3748345893532688)
(test-equal (+ -3748345893498345 34343) -3748345893464002)
(test-equal (+ 3748345893498345 -34343) 3748345893464002)
(test-equal (+ -3748345893498345 -34343) -3748345893532688)
(test-equal (- 3748345893498345 34343) 3748345893464002)
(test-equal (- -3748345893498345 34343) -3748345893532688)
(test-equal (- 3748345893498345 -34343) 3748345893532688)
(test-equal (- -3748345893498345 -34343) -3748345893464002)
(test-equal (* 3748345893498345 34343) 128729443020413662335)
(test-equal (* -3748345893498345 34343) -128729443020413662335)
(test-equal (* 3748345893498345 -34343) -128729443020413662335)
(test-equal (* -3748345893498345 -34343) 128729443020413662335)
(test-equal (/ 3748345893498345 34343) 3748345893498345/34343)
(test-equal (/ -3748345893498345 34343) -3748345893498345/34343)
(test-equal (/ 3748345893498345 -34343) -3748345893498345/34343)
(test-equal (/ -3748345893498345 -34343) 3748345893498345/34343)
(test-equal (quotient 3748345893498345 34343) 109144393136)
(test-equal (quotient -3748345893498345 34343) -109144393136)
(test-equal (quotient 3748345893498345 -34343) -109144393136)
(test-equal (quotient -3748345893498345 -34343) 109144393136)
(test-equal (modulo 3748345893498345 34343) 28697)
(test-equal (modulo -3748345893498345 34343) 5646)
(test-equal (modulo 3748345893498345 -34343) -5646)
(test-equal (modulo -3748345893498345 -34343) -28697)
(test-equal (remainder 3748345893498345 34343) 28697)
(test-equal (remainder -3748345893498345 34343) -28697)
(test-equal (remainder 3748345893498345 -34343) 28697)
(test-equal (remainder -3748345893498345 -34343) -28697)

(SECTION "binary basic zero 1")
(test-equal (+ 0 34343) 34343)
(test-equal (+ 0 -34343) -34343)
(test-equal (- 0 34343) -34343)
(test-equal (- 0 -34343) 34343)
(test-equal (* 0 34343) 0)
(test-equal (* 0 -34343) 0)
(test-equal (/ 0 34343) 0)
(test-equal (/ 0 -34343) 0)
(test-equal (quotient 0 34343) 0)
(test-equal (quotient 0 -34343) 0)
(test-equal (modulo 0 34343) 0)
(test-equal (modulo 0 -34343) 0)
(test-equal (remainder 0 34343) 0)
(test-equal (remainder 0 -34343) 0)

(SECTION "binary basic zero 2")
(test-equal (+ 0 3748345893498345) 3748345893498345)
(test-equal (+ 0 -3748345893498345) -3748345893498345)
(test-equal (- 0 3748345893498345) -3748345893498345)
(test-equal (- 0 -3748345893498345) 3748345893498345)
(test-equal (* 0 3748345893498345) 0)
(test-equal (* 0 -3748345893498345) 0)
(test-equal (/ 0 3748345893498345) 0)
(test-equal (/ 0 -3748345893498345) 0)
(test-equal (quotient 0 3748345893498345) 0)
(test-equal (quotient 0 -3748345893498345) 0)
(test-equal (modulo 0 3748345893498345) 0)
(test-equal (modulo 0 -3748345893498345) 0)
(test-equal (remainder 0 3748345893498345) 0)
(test-equal (remainder 0 -3748345893498345) 0)

(SECTION "binary basic zero 3")
(test-equal (+ 34343 0) 34343)
(test-equal (+ -34343 0) -34343)
(test-equal (- 34343 0) 34343)
(test-equal (- -34343 0) -34343)
(test-equal (* 34343 0) 0)
(test-equal (* -34343 0) 0)

(SECTION "binary basic zero 4")
(test-equal (+ 3748345893498345 0) 3748345893498345)
(test-equal (+ -3748345893498345 0) -3748345893498345)
(test-equal (- 3748345893498345 0) 3748345893498345)
(test-equal (- -3748345893498345 0) -3748345893498345)
(test-equal (* 3748345893498345 0) 0)
(test-equal (* -3748345893498345 0) 0)

(SECTION "binary basic one 1")
(test-equal (+ 1 34343) 34344)
(test-equal (+ 1 -34343) -34342)
(test-equal (- 1 34343) -34342)
(test-equal (- 1 -34343) 34344)
(test-equal (* 1 34343) 34343)
(test-equal (* 1 -34343) -34343)
(test-equal (/ 1 34343) 1/34343)
(test-equal (/ 1 -34343) -1/34343)
(test-equal (quotient 1 34343) 0)
(test-equal (quotient 1 -34343) 0)
(test-equal (modulo 1 34343) 1)
(test-equal (modulo 1 -34343) -34342)
(test-equal (remainder 1 34343) 1)
(test-equal (remainder 1 -34343) 1)

(SECTION "binary basic one 2")
(test-equal (+ 1 3748345893498345) 3748345893498346)
(test-equal (+ 1 -3748345893498345) -3748345893498344)
(test-equal (- 1 3748345893498345) -3748345893498344)
(test-equal (- 1 -3748345893498345) 3748345893498346)
(test-equal (* 1 3748345893498345) 3748345893498345)
(test-equal (* 1 -3748345893498345) -3748345893498345)
(test-equal (/ 1 3748345893498345) 1/3748345893498345)
(test-equal (/ 1 -3748345893498345) -1/3748345893498345)
(test-equal (quotient 1 3748345893498345) 0)
(test-equal (quotient 1 -3748345893498345) 0)
(test-equal (modulo 1 3748345893498345) 1)
(test-equal (modulo 1 -3748345893498345) -3748345893498344)
(test-equal (remainder 1 3748345893498345) 1)
(test-equal (remainder 1 -3748345893498345) 1)

(SECTION "binary basic one 3")
(test-equal (+ -1 34343) 34342)
(test-equal (+ -1 -34343) -34344)
(test-equal (- -1 34343) -34344)
(test-equal (- -1 -34343) 34342)
(test-equal (* -1 34343) -34343)
(test-equal (* -1 -34343) 34343)
(test-equal (/ -1 34343) -1/34343)
(test-equal (/ -1 -34343) 1/34343)
(test-equal (quotient -1 34343) 0)
(test-equal (quotient -1 -34343) 0)
(test-equal (modulo -1 34343) 34342)
(test-equal (modulo -1 -34343) -1)
(test-equal (remainder -1 34343) -1)
(test-equal (remainder -1 -34343) -1)

(SECTION "binary basic one 4")
(test-equal (+ -1 3748345893498345) 3748345893498344)
(test-equal (+ -1 -3748345893498345) -3748345893498346)
(test-equal (- -1 3748345893498345) -3748345893498346)
(test-equal (- -1 -3748345893498345) 3748345893498344)
(test-equal (* -1 3748345893498345) -3748345893498345)
(test-equal (* -1 -3748345893498345) 3748345893498345)
(test-equal (/ -1 3748345893498345) -1/3748345893498345)
(test-equal (/ -1 -3748345893498345) 1/3748345893498345)
(test-equal (quotient -1 3748345893498345) 0)
(test-equal (quotient -1 -3748345893498345) 0)
(test-equal (modulo -1 3748345893498345) 3748345893498344)
(test-equal (modulo -1 -3748345893498345) -1)
(test-equal (remainder -1 3748345893498345) -1)
(test-equal (remainder -1 -3748345893498345) -1)

(SECTION "binary basic one 5")
(test-equal (+ 34343 1) 34344)
(test-equal (+ -34343 1) -34342)
(test-equal (+ 34343 -1) 34342)
(test-equal (+ -34343 -1) -34344)
(test-equal (- 34343 1) 34342)
(test-equal (- -34343 1) -34344)
(test-equal (- 34343 -1) 34344)
(test-equal (- -34343 -1) -34342)
(test-equal (* 34343 1) 34343)
(test-equal (* -34343 1) -34343)
(test-equal (* 34343 -1) -34343)
(test-equal (* -34343 -1) 34343)
(test-equal (/ 34343 1) 34343)
(test-equal (/ -34343 1) -34343)
(test-equal (/ 34343 -1) -34343)
(test-equal (/ -34343 -1) 34343)
(test-equal (quotient 34343 1) 34343)
(test-equal (quotient -34343 1) -34343)
(test-equal (quotient 34343 -1) -34343)
(test-equal (quotient -34343 -1) 34343)
(test-equal (modulo 34343 1) 0)
(test-equal (modulo -34343 1) 0)
(test-equal (modulo 34343 -1) 0)
(test-equal (modulo -34343 -1) 0)
(test-equal (remainder 34343 1) 0)
(test-equal (remainder -34343 1) 0)
(test-equal (remainder 34343 -1) 0)
(test-equal (remainder -34343 -1) 0)

(SECTION "binary basic one 6")
(test-equal (+ 3748345893498345 1) 3748345893498346)
(test-equal (+ -3748345893498345 1) -3748345893498344)
(test-equal (+ 3748345893498345 -1) 3748345893498344)
(test-equal (+ -3748345893498345 -1) -3748345893498346)
(test-equal (- 3748345893498345 1) 3748345893498344)
(test-equal (- -3748345893498345 1) -3748345893498346)
(test-equal (- 3748345893498345 -1) 3748345893498346)
(test-equal (- -3748345893498345 -1) -3748345893498344)
(test-equal (* 3748345893498345 1) 3748345893498345)
(test-equal (* -3748345893498345 1) -3748345893498345)
(test-equal (* 3748345893498345 -1) -3748345893498345)
(test-equal (* -3748345893498345 -1) 3748345893498345)
(test-equal (/ 3748345893498345 1) 3748345893498345)
(test-equal (/ -3748345893498345 1) -3748345893498345)
(test-equal (/ 3748345893498345 -1) -3748345893498345)
(test-equal (/ -3748345893498345 -1) 3748345893498345)
(test-equal (quotient 3748345893498345 1) 3748345893498345)
(test-equal (quotient -3748345893498345 1) -3748345893498345)
(test-equal (quotient 3748345893498345 -1) -3748345893498345)
(test-equal (quotient -3748345893498345 -1) 3748345893498345)
(test-equal (modulo 3748345893498345 1) 0)
(test-equal (modulo -3748345893498345 1) 0)
(test-equal (modulo 3748345893498345 -1) 0)
(test-equal (modulo -3748345893498345 -1) 0)
(test-equal (remainder 3748345893498345 1) 0)
(test-equal (remainder -3748345893498345 1) 0)
(test-equal (remainder 3748345893498345 -1) 0)
(test-equal (remainder -3748345893498345 -1) 0)

(SECTION "binary basic rational 1")
(test-equal (+ 2/5 3/4) 23/20)
(test-equal (+ -2/5 3/4) 7/20)
(test-equal (+ 2/5 -3/4) -7/20)
(test-equal (+ -2/5 -3/4) -23/20)
(test-equal (- 2/5 3/4) -7/20)
(test-equal (- -2/5 3/4) -23/20)
(test-equal (- 2/5 -3/4) 23/20)
(test-equal (- -2/5 -3/4) 7/20)
(test-equal (* 2/5 3/4) 3/10)
(test-equal (* -2/5 3/4) -3/10)
(test-equal (* 2/5 -3/4) -3/10)
(test-equal (* -2/5 -3/4) 3/10)
(test-equal (/ 2/5 3/4) 8/15)
(test-equal (/ -2/5 3/4) -8/15)
(test-equal (/ 2/5 -3/4) -8/15)
(test-equal (/ -2/5 -3/4) 8/15)

(SECTION "binary basic rational 2")
(test-equal (+ 201501210210/7 3/415484104) 1708582648551377589/59354872)
(test-equal (+ -201501210210/7 3/415484104) -11960078539859643117/415484104)
(test-equal (+ 201501210210/7 -3/415484104) 11960078539859643117/415484104)
(test-equal (+ -201501210210/7 -3/415484104) -1708582648551377589/59354872)
(test-equal (- 201501210210/7 3/415484104) 11960078539859643117/415484104)
(test-equal (- -201501210210/7 3/415484104) -1708582648551377589/59354872)
(test-equal (- 201501210210/7 -3/415484104) 1708582648551377589/59354872)
(test-equal (- -201501210210/7 -3/415484104) -11960078539859643117/415484104)
(test-equal (* 201501210210/7 3/415484104) 302251815315/1454194364)
(test-equal (* -201501210210/7 3/415484104) -302251815315/1454194364)
(test-equal (* 201501210210/7 -3/415484104) -302251815315/1454194364)
(test-equal (* -201501210210/7 -3/415484104) 302251815315/1454194364)
(test-equal (/ 201501210210/7 3/415484104) 3986692846619881040)
(test-equal (/ -201501210210/7 3/415484104) -3986692846619881040)
(test-equal (/ 201501210210/7 -3/415484104) -3986692846619881040)
(test-equal (/ -201501210210/7 -3/415484104) 3986692846619881040)

(SECTION "binary basic rational 3")
(test-equal (+ 1/7 1/21) 4/21)
(test-equal (+ -1/7 1/21) -2/21)
(test-equal (+ 1/7 -1/21) 2/21)
(test-equal (+ -1/7 -1/21) -4/21)
(test-equal (- 1/7 1/21) 2/21)
(test-equal (- -1/7 1/21) -4/21)
(test-equal (- 1/7 -1/21) 4/21)
(test-equal (- -1/7 -1/21) -2/21)
(test-equal (* 1/7 1/21) 1/147)
(test-equal (* -1/7 1/21) -1/147)
(test-equal (* 1/7 -1/21) -1/147)
(test-equal (* -1/7 -1/21) 1/147)
(test-equal (/ 1/7 1/21) 3)
(test-equal (/ -1/7 1/21) -3)
(test-equal (/ 1/7 -1/21) -3)
(test-equal (/ -1/7 -1/21) 3)

(SECTION "binary basic rational 4")
(test-equal (/ 3/7 5/21) 9/5)
(test-equal (/ -3/7 5/21) -9/5)
(test-equal (/ 3/7 -5/21) -9/5)
(test-equal (/ -3/7 -5/21) 9/5)
(test-equal (/ 0 5/21) 0)
(test-equal (/ 0 5/21) 0)
(test-equal (/ 0 -5/21) 0)
(test-equal (/ 0 -5/21) 0)

(SECTION "n-ary mix types")
(test-equal (+ 3/7 404 45151561541) 316060933618/7)
(test-equal (+ 3/7 45151561541 404 ) 316060933618/7)
(test-equal (+ 404 3/7 45151561541) 316060933618/7)
(test-equal (+ 404 45151561541 3/7) 316060933618/7)
(test-equal (+ 45151561541 3/7 404) 316060933618/7)
(test-equal (+ 45151561541 404 3/7) 316060933618/7)
(test-equal (- 3/7 404 45151561541) -316060933612/7)
(test-equal (- 3/7 45151561541 404 ) -316060933612/7)
(test-equal (- 404 3/7 45151561541) -316060927962/7)
(test-equal (- 404 45151561541 3/7) -316060927962/7)
(test-equal (- 45151561541 3/7 404) 316060927956/7)
(test-equal (- 45151561541 404 3/7) 316060927956/7)
(test-equal (* 3/7 404 45151561541) 54723692587692/7)
(test-equal (* 3/7 45151561541 404 ) 54723692587692/7)
(test-equal (* 404 3/7 45151561541) 54723692587692/7)
(test-equal (* 404 45151561541 3/7) 54723692587692/7)
(test-equal (* 45151561541 3/7 404) 54723692587692/7)
(test-equal (* 45151561541 404 3/7) 54723692587692/7)
(test-equal (/ 3/7 404 45151561541) 3/127688616037948)
(test-equal (/ 3/7 45151561541 404 ) 3/127688616037948)
(test-equal (/ 404 3/7 45151561541) 2828/135454684623)
(test-equal (/ 404 45151561541 3/7) 2828/135454684623)
(test-equal (/ 45151561541 3/7 404) 316060930787/1212)
(test-equal (/ 45151561541 404 3/7) 316060930787/1212)

(SECTION "unary negate")
(test-equal (- 45645) -45645)
(test-equal (- -45645) 45645)
(test-equal (- 4564500505) -4564500505)
(test-equal (- -4564500505) 4564500505)
(test-equal (- 5/21) -5/21)
(test-equal (- -5/21) 5/21)
(test-equal (- 0.25) -0.25)
(test-equal (- -0.25) 0.25)
(test-equal (- 0.25+0.5i) -0.25-0.5i)
(test-equal (- -0.25+0.5i) 0.25-0.5i)
(test-equal (- 0.25-0.5i) -0.25+0.5i)
(test-equal (- -0.25-0.5i) 0.25+0.5i)

(SECTION "operator +")
(test-equal (+) 0)
(test-equal (+ 124) 124)
(test-equal (+ -1244515154154515) -1244515154154515)
(test-equal (+ 1.25e21) 1.25e21)
(test-equal (+ -3/8) -3/8)
(test-equal (+ -3/8+3i) -3/8+3i)
                                        ;
(test-equal (+ 25 75) 100)
(test-equal (+ 250000000000 750000000000) 1000000000000)
(test-equal (+ 23/500 6/71) 4633/35500)
(test-equal (+ 2351515156151/500 6/7561515611) 17781018562738889176261/3780757805500)
(test-equal (+ 0.25 0.75) 1.0)
(test-equal (+ 0.25+0.5i 0.75+0.25i) 1.0+0.75i)
(test-equal (+ 1/4+1/2i 3/4+1/4i) 1+3/4i)
                                        ;
(test-equal (+ 25 -25) 0)
(test-equal (+ 0.25 -0.25) 0.0)
(test-equal (+ 1/4 -1/4) 0)
(test-equal (+ 0.25+0.5i -0.25-0.5i) 0.0)
(test-equal (+ 0.25+0.5i 0.75-0.5i) 1.0)
(test-equal (+ 1/4+1/2i -1/4-1/2i) 0)
(test-equal (+ 1/4+1/2i 3/4-1/2i) 1)
                                        ;
(test-equal (+ 25 750000000000) 750000000025)
(test-equal (+ 25 6/71) 1781/71)
(test-equal (+ 25 6.25) 31.25)
(test-equal (+ 25 0.75+0.25i) 25.75+0.25i)
(test-equal (+ 25 3/4-1/2i) 103/4-1/2i)
                                        ;
(test-equal (+ 250000000000 750000000000) 1000000000000)
(test-equal (+ 250000000000 6/71) 17750000000006/71)
(test-equal (+ 250000000000 6.25) 2.5000000000625e11)
(test-equal (+ 250000000000 0.75+0.25i) 2.5000000000075e11+0.25i)
(test-equal (+ 250000000000 3/4-1/2i) 1000000000003/4-1/2i)
                                        ;
(test-equal (+ 23/500 750000000000) 375000000000023/500)
(test-equal (+ 23/500 6/71) 4633/35500)
(test-equal (+ 23/500 6.25) 6.296)
(test-equal (+ 23/500 0.75+0.25i) 0.796+0.25i)
(test-equal (+ 23/500 3/4-1/2i) 199/250-1/2i)
                                        ;
(test-equal (+ 2351515156151/3780757805500 750000000000) 2835568354127351515156151/3780757805500)
(test-equal (+ 2351515156151/3780757805500 6/71) 189642122919721/268433804190500)
(test-equal (+ 2351515156151/3780757805500 6.25) 6.871969265719737)
                                        ;
(test-equal (+ 0.25 750000000000) 7.5000000000025e11)
(test-equal (+ 0.25 6/71) 0.3345070422535211)
(test-equal (+ 0.25 6.25) 6.5)
(test-equal (+ 0.25 0.75+0.25i) 1.0+0.25i)
(test-equal (+ 0.25 3/4-1/2i) 1.0-0.5i)
                                        ;
(test-equal (+ 1/4+1/2i 750000000000) 3000000000001/4+1/2i)
(test-equal (+ 1/4+1/2i 6/71) 95/284+1/2i)
(test-equal (+ 1/4+1/2i 6.25) 6.5+0.5i)
(test-equal (+ 1/4+1/2i 0.75+0.25i) 1.0+0.75i)
(test-equal (+ 1/4+1/2i 3/4-1/2i) 1)
                                        ;
(test-equal (+ 0.25+0.5i 750000000000) 7.5000000000025e11+0.5i)
(test-equal (+ 0.25+0.5i 6/71) 0.3345070422535211+0.5i)
(test-equal (+ 0.25+0.5i 6.25) 6.5+0.5i)
(test-equal (+ 0.25+0.5i 0.75+0.25i) 1.0+0.75i)
(test-equal (+ 0.25+0.5i 3/4-1/2i) 1.0+0.0i)

(SECTION "operator -")
(test-equal (- 124) -124)
(test-equal (- -1244515154154515) 1244515154154515)
(test-equal (- 1.25e21) -1.25e21)
(test-equal (- -3/8) 3/8)
(test-equal (- -3/8+3i) 3/8-3i)
                                        ;
(test-equal (- 25 75) -50)
(test-equal (- 250000000000 750000000000) -500000000000)
(test-equal (- 23/500 6/71) -1367/35500)
(test-equal (- 2351515156151/500 6/7561515611) 17781018562738889170261/3780757805500)
(test-equal (- 0.25 0.75) -0.5)
(test-equal (- 0.25+0.5i 0.75+0.25i) -0.5+0.25i)
(test-equal (- 1/4+1/2i 3/4+1/4i) -1/2+1/4i)
                                        ;
(test-equal (- 25 25) 0)
(test-equal (- 0.25 0.25) 0.0)
(test-equal (- 1/4 1/4) 0)
(test-equal (- 0.25+0.5i 0.25+0.5i) 0.0)
(test-equal (- 0.25+0.5i -0.75+0.5i) 1.0)
(test-equal (- 1/4+1/2i 1/4+1/2i) 0)
(test-equal (- 1/4+1/2i -3/4+1/2i) 1)
                                        ;
(test-equal (- 25 750000000000) -749999999975)
(test-equal (- 25 6/71) 1769/71)
(test-equal (- 25 6.25) 18.75)
(test-equal (- 25 0.75+0.25i) 24.25-0.25i)
(test-equal (- 25 3/4-1/2i) 97/4+1/2i)
                                        ;
(test-equal (- 250000000000 750000000000) -500000000000)
(test-equal (- 250000000000 6/71) 17749999999994/71)
(test-equal (- 250000000000 6.25) 2.4999999999375e11)
(test-equal (- 250000000000 0.75+0.25i) 2.4999999999925e11-0.25i)
(test-equal (- 250000000000 3/4-1/2i) 999999999997/4+1/2i)
                                        ;
(test-equal (- 23/500 750000000000) -374999999999977/500)
(test-equal (- 23/500 6/71) -1367/35500)
(test-equal (- 23/500 6.25) -6.204)
(test-equal (- 23/500 0.75+0.25i) -0.704-0.25i)
(test-equal (- 23/500 3/4-1/2i) -88/125+1/2i)
                                        ;
(test-equal (- 2351515156151/3780757805500 750000000000) -2835568354122648484843849/3780757805500)
(test-equal (- 2351515156151/3780757805500 6/71) 144273029253721/268433804190500)
(test-equal (- 2351515156151/3780757805500 6.25) -5.628030734280263)
                                        ;
(test-equal (- 0.25 750000000000) -7.4999999999975e11)
(test-equal (- 0.25 6/71) 0.16549295774647887)
(test-equal (- 0.25 6.25) -6.0)
(test-equal (- 0.25 0.75+0.25i) -0.5-0.25i)
(test-equal (- 0.25 3/4-1/2i) -0.5+0.5i)
                                        ;
(test-equal (- 1/4+1/2i 750000000000) -2999999999999/4+1/2i)
(test-equal (- 1/4+1/2i 6/71) 47/284+1/2i)
(test-equal (- 1/4+1/2i 6.25) -6.0+0.5i)
(test-equal (- 1/4+1/2i 0.75+0.25i) -0.5+0.25i)
(test-equal (- 1/4+1/2i 3/4-1/2i) -1/2+1i)
                                        ;
(test-equal (- 0.25+0.5i 750000000000) -7.4999999999975e11+0.5i)
(test-equal (- 0.25+0.5i 6/71) 0.16549295774647887+0.5i)
(test-equal (- 0.25+0.5i 6.25) -6.0+0.5i)
(test-equal (- 0.25+0.5i 0.75+0.25i) -0.5+0.25i)
(test-equal (- 0.25+0.5i 3/4-1/2i) -0.5+1.0i)

(SECTION "operator *")
(test-equal (* 124) 124)
(test-equal (* -1244515154154515) -1244515154154515)
(test-equal (* 1.25e21) 1.25e21)
(test-equal (* -3/8) -3/8)
(test-equal (* -3/8+3i) -3/8+3i)
                                        ;
(test-equal (* 25 75) 1875)
(test-equal (* 250000000000 750000000000) 187500000000000000000000)
(test-equal (* 23/500 6/71) 69/17750)
(test-equal (* 2351515156151/500 6/7561515611) 7054545468453/1890378902750)
(test-equal (* 0.25 0.75) 0.1875)
(test-equal (* 0.25+0.5i 0.75+0.25i) 0.0625+0.4375i)
(test-equal (* 1/4+1/2i 3/4+1/4i) 1/16+7/16i)
                                        ;
(test-equal (* 25 25) 625)
(test-equal (* 0.25 0.25) 0.0625)
(test-equal (* 1/4 1/4) 1/16)
(test-equal (* 0.25+0.5i 0.25+0.5i) -0.1875+0.25i)
(test-equal (* 0.25+0.5i -0.75+0.5i) -0.4375-0.25i)
(test-equal (* 1/4+1/2i 1/4+1/2i) -3/16+1/4i)
(test-equal (* 1/4+1/2i -3/4+1/2i) -7/16-1/4i)
                                        ;
(test-equal (* 25 750000000000) 18750000000000)
(test-equal (* 25 6/71) 150/71)
(test-equal (* 25 6.25) 156.25)
(test-equal (* 25 0.75+0.25i) 18.75+6.25i)
(test-equal (* 25 3/4-1/2i) 75/4-25/2i)
                                        ;
(test-equal (* 250000000000 750000000000) 187500000000000000000000)
(test-equal (* 250000000000 6/71) 1500000000000/71)
(test-equal (* 250000000000 6.25) 1.5625e12)
(test-equal (* 250000000000 0.75+0.25i) 1.875e11+6.25e10i)
(test-equal (* 250000000000 3/4-1/2i) 187500000000-125000000000i)
                                        ;
(test-equal (* 23/500 750000000000) 34500000000)
(test-equal (* 23/500 6/71) 69/17750)
(test-equal (* 23/500 6.25) 0.2875)
(test-equal (* 23/500 0.75+0.25i) 0.0345+0.0115i)
(test-equal (* 23/500 3/4-1/2i) 69/2000-23/1000i)
                                        ;
(test-equal (* 2351515156151/3780757805500 750000000000) 3527272734226500000000/7561515611)
(test-equal (* 2351515156151/3780757805500 6/71) 7054545468453/134216902095250)
(test-equal (* 2351515156151/3780757805500 6.25) 3.8873079107483575)
                                        ;
(test-equal (* 0.25 750000000000) 1.875e11)
(test-equal (* 0.25 6/71) 0.02112676056338028)
(test-equal (* 0.25 6.25) 1.5625)
(test-equal (* 0.25 0.75+0.25i) 0.1875+0.0625i)
(test-equal (* 0.25 3/4-1/2i) 0.1875-0.125i)
                                        ;
(test-equal (* 1/4+1/2i 750000000000) 187500000000+375000000000i)
(test-equal (* 1/4+1/2i 6/71) 3/142+3/71i)
(test-equal (* 1/4+1/2i 6.25) 1.5625+3.125i)
(test-equal (* 1/4+1/2i 0.75+0.25i) 0.0625+0.4375i)
(test-equal (* 1/4+1/2i 3/4-1/2i) 7/16+1/4i)
                                        ;
(test-equal (* 0.25+0.5i 750000000000) 1.875e11+3.75e11i)
(test-equal (* 0.25+0.5i 6/71) 0.02112676056338028+0.04225352112676056i)
(test-equal (* 0.25+0.5i 6.25) 1.5625+3.125i)
(test-equal (* 0.25+0.5i 0.75+0.25i) 0.0625+0.4375i)
(test-equal (* 0.25+0.5i 3/4-1/2i) 0.4375+0.25i)

(SECTION "operator /")
(test-equal (/ 124) 1/124)
(test-equal (/ -1244515154154515) -1/1244515154154515)
(test-equal (/ 1.25e21) 8e-22)
(test-equal (/ -3/8) -8/3)
(test-equal (/ -3/8+3i) -8/195-64/195i)
                                        ;
(test-equal (/ 25 75) 1/3)
(test-equal (/ 250000000000 750000000000) 1/3)
(test-equal (/ 23/500 6/71) 1633/3000)
(test-equal (/ 2351515156151/500 6/7561515611) 17781018562738889173261/3000)
(test-equal (/ 0.25 0.75) 0.3333333333333333)
(test-equal (/ 0.25+0.5i 0.75+0.25i) 0.5+0.5i)
(test-equal (/ 1/4+1/2i 3/4+1/4i) 1/2+1/2i)
                                        ;
(test-equal (/ 25 25) 1)
(test-equal (/ 0.25 0.25) 1.0)
(test-equal (/ 1/4 1/4) 1)
(test-equal (/ 0.25+0.5i 0.25+0.5i) 1.0+0.0i)
(test-equal (/ 0.25+0.5i -0.75+0.5i) 0.07692307692307693-0.6153846153846154i)
(test-equal (/ 1/4+1/2i 1/4+1/2i) 1)
(test-equal (/ 1/4+1/2i -3/4+1/2i) 1/13-8/13i)
                                        ;
(test-equal (/ 25 750000000000) 1/30000000000)
(test-equal (/ 25 6/71) 1775/6)
(test-equal (/ 25 6.25) 4.0)
(test-equal (/ 25 0.75+0.25i) 30.0-10.0i)
(test-equal (/ 25 3/4-1/2i) 300/13+200/13i)
                                        ;
(test-equal (/ 250000000000 750000000000) 1/3)
(test-equal (/ 250000000000 6/71) 8875000000000/3)
(test-equal (/ 250000000000 6.25) 4e10)
(test-equal (/ 250000000000 0.75+0.25i) 3e11-1e11i)
(test-equal (/ 250000000000 3/4-1/2i) 3000000000000/13+2000000000000/13i)
                                        ;
(test-equal (/ 23/500 750000000000) 23/375000000000000)
(test-equal (/ 23/500 6/71) 1633/3000)
(test-equal (/ 23/500 6.25) 0.00736)
(test-equal (/ 23/500 0.50+0.25i) 0.0736-0.0368i)
(test-equal (/ 23/500 3/4-1/2i) 69/1625+46/1625i)
                                        ;
(test-equal (/ 2351515156151/3780757805500 750000000000) 2351515156151/2835568354125000000000000)
(test-equal (/ 2351515156151/3780757805500 6/71) 166957576086721/22684546833000)
(test-equal (/ 2351515156151/3780757805500 4.0) 0.1554923164299343)
                                        ;
(test-equal (/ 0.25 500000000000) 5e-13)
(test-equal (/ 0.25 6/71) 2.9583333333333335)
(test-equal (/ 0.25 6.25) 0.04)
(test-equal (/ 0.25 0.5+0.25i) 0.4-0.2i)
(test-equal (/ 0.25 1/4-1/2i) 0.2+0.4i)
                                        ;
(test-equal (/ 1/4+1/2i 750000000000) 1/3000000000000+1/1500000000000i)
(test-equal (/ 1/4+1/2i 6/71) 71/24+71/12i)
(test-equal (/ 1/4+1/2i 6.25) 0.04+0.08i)
(test-equal (/ 1/4+1/2i 0.75+0.25i) 0.5+0.5i)
(test-equal (/ 1/4+1/2i 3/4-1/2i) -1/13+8/13i)
                                        ;
(test-equal (/ 0.25+0.5i 500000000000) 5e-13+1e-12i)
(test-equal (/ 0.25+0.5i 1/4) 1.0+2.0i)
(test-equal (/ 0.25+0.5i 6.25) 0.04+0.08i)
(test-equal (/ 0.25+0.5i 0.75+0.25i) 0.5+0.5i)
(test-equal (/ 0.25+0.5i 1/4-1/2i) -0.6+0.8i)

(SECTION "boundary")
(test-equal (round 2/3) 1)
(test-equal (quotient (+ (expt 2 128) (expt 2 64)) (+ (expt 2 64) (expt 2 30))) 18446744072635809793) ; #xFFFFFFFFC0000001
(test-equal (quotient (+ (expt 2 256) (expt 2 64)) (expt 2 64)) 6277101735386680763835789423207666416102355444464034512897) ; #x1000000000000000000000000000000000000000000000001
(test-equal (exact 0.0) 0)
(test-equal (exact 1.0+0.0i) 1)
(test-equal (make-rectangular 3 3+0.0i) 3.0+3.0i)
(test-equal (* (string->number "#e1e-2000") (string->number "#e1e1998")) 1/100)
(test-equal (quotient #x1000000000000000 #x10000000) 4294967296)
(test-equal (quotient #x1000000010000000 #x10000000) 4294967297)
(test-equal (quotient #x10000000100000000000000 #x10000000) 1152921504875282432)
(test-equal (quotient #x1000000010000000000000 #x10000000) 72057594054705152)
(test-equal (quotient #x100000001000000000000 #x10000000) 4503599628419072)
(test-equal (quotient #x100000001000000000000000 #x10000000) 18446744078004518912)
(test-equal (expt 2 28) 268435456)
(test-equal (expt 2 29) 536870912)
(test-equal (expt 2 30) 1073741824)
(test-equal (expt 2 31) 2147483648)
(test-equal (expt 2 32) 4294967296)
(test-equal (expt 2 33) 8589934592)
(test-equal (expt 2 34) 17179869184)
(test-equal (number->string 1.0) "1.0")
(test-equal (number->string 0.25) "0.25")
(test-equal (number->string 25.0) "25.0")
(test-equal (number->string 1.1212121221212123e-308) "1.1212121221212123e-308")
(test-equal (number->string 1.1212121221212122e308) "1.1212121221212122e308")
(test-equal (number->string 1.1212121221212124e-30) "1.1212121221212124e-30")
(test-equal (number->string 1.1212121221212123e30) "1.1212121221212123e30")
(test-equal (number->string 1.1212121221212124e-3) "0.0011212121221212124")
(test-equal (number->string 1.1212121221212124e3) "1121.2121221212124")

(test-equal (number->string 3e-323) "3e-323")
(test-equal (number->string 3.1e-308) "3.1e-308")
(test-equal (number->string 3.1e307) "3.1e307")
(test-equal (number->string 3.1e-30) "3.1e-30")
(test-equal (number->string 3.1e30) "3.1e30")
(test-equal (number->string 3.1e-3) "0.0031")
(test-equal (number->string 3.1e3) "3100.0")
(test-equal (number->string 1.235) "1.235")
(test-equal (number->string 1000000.000000001) "1000000.000000001")
(test-equal (number->string 1000000.000000002) "1000000.000000002")
(test-equal (number->string 999999.999999999) "999999.999999999")
(test-equal (number->string 999999.999999998) "999999.999999998")

(SECTION "from kawa's num-test.scm")

;; A problem posed by Ken Dickey (kend@data.UUCP) on comp.lang.lisp
;; to check numerical exactness of Lisp implementations.
(test-eval! (define (dickey-test x y)
             (+  (* 1335/4 (expt y 6))
                 (* (expt x 2)
                    (- (* 11 (expt x 2) (expt y 2))
                       (expt y 6)
                       (* 121 (expt y 4))
                       2))
                 (* 11/2 (expt y 8))
                 (/ x (* 2 y)))))

(test-equal (dickey-test 77617 33096)  -54767/66192)
(test-equal (/ -1 #e1e13)  -1/10000000000000)
(test-equal (- (- (expt 2 63)))  9223372036854775808)
(test-equal (quotient (expt 10 200) (* 20 (expt 10 100)))  500000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000)
(test-equal (+ 17280012451545786657095548928 -17280012451545786657095548928) 0)
(test-equal (+ 1250137720722158536144460577767424 -17280012451545786657095548928) 1250120440709706990357803482218496)
(test-equal (quotient 10000000000000000000000000000000000 100000000000000000000) 100000000000000)
(test-equal (- 1250137720722158536144460577767424 17280012451545786657095548928) 1250120440709706990357803482218496)
(test-equal (- 17280012451545786657095548928 1250137720722158536144460577767424) -1250120440709706990357803482218496)
(test-equal (expt 2 63) 9223372036854775808)
(test-equal (exact (inexact 10000000000)) 10000000000)
(test-equal (inexact 14285714285714285714285) 1.4285714285714286e22)
(test-equal (exact 0.0) 0)
(test-equal (rationalize (exact 12345.1) (exact 0.00001)) 123451/10)
(test-equal (magnitude 4.) 4.0)
(test-equal (magnitude -4000.) 4e3)
(test-equal (magnitude 3-4i) 5)
(test-equal (gcd 4294967295 3) 3)
(test-equal (gcd 4294967298 3) 3)

;; From Norman Hardy <norm@netcom.com>
(test-eval! (begin (define (ssin x) (let ((a2 (quotient (* x x) dx)))
                                     (- x (let tail ((term x)(ndx 2))
                                            (let ((x (quotient (* a2 term) (* ndx (+ ndx 1) dx))))
                                              (if (zero? x) 0 (- x (tail x (+ ndx 2)))))))))
                  (define dx (expt 10 100))
                  (define pi 31415926535897932384626433832795028841971693993751058209749445923078164062862089986280348253421170679)))

(test-equal (ssin pi) 3)

(test-equal (= (expt 2. 100) (+ (expt 2 100) 1))  #f)
(test-equal (= (expt 2. 100) (inexact (+ (expt 2 100) 1)))  #t)
(test-equal (remainder 14853098170650239300 4000000000)  2650239300)

;; end from num-test.scm (kawa)

(test-end)