/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.helper;

import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.asamk.signal.manager.api.GroupIdV1;
import org.asamk.signal.manager.api.GroupIdV2;
import org.asamk.signal.manager.api.Profile;
import org.asamk.signal.manager.helper.Context;
import org.asamk.signal.manager.internal.SignalDependencies;
import org.asamk.signal.manager.storage.SignalAccount;
import org.asamk.signal.manager.storage.groups.GroupInfoV1;
import org.asamk.signal.manager.storage.groups.GroupInfoV2;
import org.asamk.signal.manager.storage.identities.IdentityInfo;
import org.asamk.signal.manager.storage.recipients.Recipient;
import org.asamk.signal.manager.storage.recipients.RecipientId;
import org.asamk.signal.manager.syncStorage.AccountRecordProcessor;
import org.asamk.signal.manager.syncStorage.ContactRecordProcessor;
import org.asamk.signal.manager.syncStorage.GroupV1RecordProcessor;
import org.asamk.signal.manager.syncStorage.GroupV2RecordProcessor;
import org.asamk.signal.manager.syncStorage.StorageSyncModels;
import org.asamk.signal.manager.syncStorage.StorageSyncValidations;
import org.asamk.signal.manager.syncStorage.WriteOperationResult;
import org.asamk.signal.manager.util.KeyUtils;
import org.asamk.signal.manager.util.Utils;
import org.signal.core.util.SetUtil;
import org.signal.libsignal.protocol.InvalidKeyException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.whispersystems.signalservice.api.push.exceptions.NotFoundException;
import org.whispersystems.signalservice.api.storage.RecordIkm;
import org.whispersystems.signalservice.api.storage.SignalRecord;
import org.whispersystems.signalservice.api.storage.SignalStorageManifest;
import org.whispersystems.signalservice.api.storage.SignalStorageRecord;
import org.whispersystems.signalservice.api.storage.StorageId;
import org.whispersystems.signalservice.api.storage.StorageKey;
import org.whispersystems.signalservice.api.storage.StorageRecordConvertersKt;
import org.whispersystems.signalservice.api.storage.StorageServiceRepository;
import org.whispersystems.signalservice.internal.storage.protos.AccountRecord;
import org.whispersystems.signalservice.internal.storage.protos.ContactRecord;
import org.whispersystems.signalservice.internal.storage.protos.GroupV1Record;
import org.whispersystems.signalservice.internal.storage.protos.GroupV2Record;
import org.whispersystems.signalservice.internal.storage.protos.ManifestRecord;
import org.whispersystems.signalservice.internal.storage.protos.StorageRecord;

public class StorageHelper {
    private static final Logger logger = LoggerFactory.getLogger(StorageHelper.class);
    private static final List<Integer> KNOWN_TYPES = List.of(Integer.valueOf(ManifestRecord.Identifier.Type.CONTACT.getValue()), Integer.valueOf(ManifestRecord.Identifier.Type.GROUPV1.getValue()), Integer.valueOf(ManifestRecord.Identifier.Type.GROUPV2.getValue()), Integer.valueOf(ManifestRecord.Identifier.Type.ACCOUNT.getValue()));
    private final SignalAccount account;
    private final SignalDependencies dependencies;
    private final Context context;

    public StorageHelper(Context context) {
        this.account = context.getAccount();
        this.dependencies = context.getDependencies();
        this.context = context;
    }

    public void syncDataWithStorage() throws IOException {
        StorageKey storageKey = this.account.getOrCreateStorageKey();
        if (storageKey == null) {
            if (!this.account.isPrimaryDevice()) {
                logger.debug("Storage key unknown, requesting from primary device.");
                this.context.getSyncHelper().requestSyncKeys();
            }
            return;
        }
        logger.trace("Reading manifest from remote storage");
        long localManifestVersion = this.account.getStorageManifestVersion();
        SignalStorageManifest localManifest = this.account.getStorageManifest().orElse(SignalStorageManifest.Companion.getEMPTY());
        StorageServiceRepository storageServiceRepository = this.dependencies.getStorageServiceRepository();
        StorageServiceRepository.ManifestIfDifferentVersionResult result = storageServiceRepository.getStorageManifestIfDifferentVersion(storageKey, localManifestVersion);
        boolean needsForcePush = false;
        StorageServiceRepository.ManifestIfDifferentVersionResult manifestIfDifferentVersionResult = result;
        Objects.requireNonNull(manifestIfDifferentVersionResult);
        StorageServiceRepository.ManifestIfDifferentVersionResult manifestIfDifferentVersionResult2 = manifestIfDifferentVersionResult;
        int n = 0;
        SignalStorageManifest remoteManifest = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{StorageServiceRepository.ManifestIfDifferentVersionResult.DifferentVersion.class, StorageServiceRepository.ManifestIfDifferentVersionResult.DecryptionError.class, StorageServiceRepository.ManifestIfDifferentVersionResult.SameVersion.class, StorageServiceRepository.ManifestIfDifferentVersionResult.NetworkError.class, StorageServiceRepository.ManifestIfDifferentVersionResult.StatusCodeError.class}, (Object)manifestIfDifferentVersionResult2, n)) {
            case 0 -> {
                StorageServiceRepository.ManifestIfDifferentVersionResult.DifferentVersion diff = (StorageServiceRepository.ManifestIfDifferentVersionResult.DifferentVersion)manifestIfDifferentVersionResult2;
                SignalStorageManifest manifest = diff.getManifest();
                this.storeManifestLocally(manifest);
                yield manifest;
            }
            case 1 -> {
                StorageServiceRepository.ManifestIfDifferentVersionResult.DecryptionError ignore = (StorageServiceRepository.ManifestIfDifferentVersionResult.DecryptionError)manifestIfDifferentVersionResult2;
                logger.warn("Manifest couldn't be decrypted.");
                if (this.account.isPrimaryDevice()) {
                    needsForcePush = true;
                } else {
                    this.context.getSyncHelper().requestSyncKeys();
                }
                yield null;
            }
            case 2 -> {
                StorageServiceRepository.ManifestIfDifferentVersionResult.SameVersion ignored = (StorageServiceRepository.ManifestIfDifferentVersionResult.SameVersion)manifestIfDifferentVersionResult2;
                yield localManifest;
            }
            case 3 -> {
                StorageServiceRepository.ManifestIfDifferentVersionResult.NetworkError e = (StorageServiceRepository.ManifestIfDifferentVersionResult.NetworkError)manifestIfDifferentVersionResult2;
                throw e.getException();
            }
            case 4 -> {
                StorageServiceRepository.ManifestIfDifferentVersionResult.StatusCodeError e = (StorageServiceRepository.ManifestIfDifferentVersionResult.StatusCodeError)manifestIfDifferentVersionResult2;
                throw e.getException();
            }
            default -> throw new RuntimeException("Unhandled ManifestIfDifferentVersionResult type");
        };
        if (remoteManifest != null) {
            logger.trace("Manifest versions: local {}, remote {}", (Object)localManifestVersion, (Object)remoteManifest.version);
            if (remoteManifest.version > localManifestVersion) {
                logger.trace("Remote version was newer, reading records.");
                needsForcePush = this.readDataFromStorage(storageKey, localManifest, remoteManifest);
            } else if (remoteManifest.version < localManifest.version) {
                logger.debug("Remote storage manifest version was older. User might have switched accounts.");
            }
            logger.trace("Done reading data from remote storage");
            this.readRecordsWithPreviouslyUnknownTypes(storageKey, remoteManifest);
        }
        logger.trace("Adding missing storageIds to local data");
        this.account.getRecipientStore().setMissingStorageIds();
        this.account.getGroupStore().setMissingStorageIds();
        boolean needsMultiDeviceSync = false;
        if (this.account.needsStorageKeyMigration()) {
            logger.debug("Storage needs force push due to new account entropy pool");
            this.account.setAccountEntropyPool(this.account.getOrCreateAccountEntropyPool());
            storageKey = this.account.getOrCreateStorageKey();
            this.context.getSyncHelper().sendKeysMessage();
            needsForcePush = true;
        } else if (remoteManifest == null) {
            if (this.account.isPrimaryDevice()) {
                needsForcePush = true;
            }
        } else if (remoteManifest.recordIkm == null && this.account.getSelfRecipientProfile().getCapabilities().contains((Object)Profile.Capability.storageServiceEncryptionV2Capability)) {
            logger.debug("The SSRE2 capability is supported, but no recordIkm is set! Force pushing.");
            needsForcePush = true;
        } else {
            try {
                needsMultiDeviceSync = this.writeToStorage(storageKey, remoteManifest, needsForcePush);
            }
            catch (RetryLaterException e) {
                return;
            }
        }
        if (needsForcePush) {
            logger.debug("Doing a force push.");
            try {
                this.forcePushToStorage(storageKey);
                needsMultiDeviceSync = true;
            }
            catch (RetryLaterException e) {
                return;
            }
        }
        if (needsMultiDeviceSync) {
            this.context.getSyncHelper().sendSyncFetchStorageMessage();
        }
        logger.debug("Done syncing data with remote storage");
    }

    public void forcePushToStorage() throws IOException {
        if (!this.account.isPrimaryDevice()) {
            return;
        }
        StorageKey storageKey = this.account.getOrCreateStorageKey();
        if (storageKey == null) {
            return;
        }
        try {
            this.forcePushToStorage(storageKey);
        }
        catch (RetryLaterException retryLaterException) {
            // empty catch block
        }
    }

    private boolean readDataFromStorage(StorageKey storageKey, SignalStorageManifest localManifest, SignalStorageManifest remoteManifest) throws IOException {
        boolean needsForcePush = false;
        try (Connection connection = this.account.getAccountDatabase().getConnection();){
            connection.setAutoCommit(false);
            IdDifferenceResult idDifference = StorageHelper.findIdDifference(remoteManifest.storageIds, localManifest.storageIds);
            if (idDifference.hasTypeMismatches() && this.account.isPrimaryDevice()) {
                logger.debug("Found type mismatches in the ID sets! Scheduling a force push after this sync completes.");
                needsForcePush = true;
            }
            logger.debug("Pre-Merge ID Difference :: {}", (Object)idDifference);
            if (!idDifference.isEmpty()) {
                int updated;
                List<SignalStorageRecord> remoteOnlyRecords = this.getSignalStorageRecords(storageKey, remoteManifest, idDifference.remoteOnlyIds());
                if (remoteOnlyRecords.size() != idDifference.remoteOnlyIds().size()) {
                    logger.debug("Could not find all remote-only records! Requested: {}, Found: {}. These stragglers should naturally get deleted during the sync.", (Object)idDifference.remoteOnlyIds().size(), (Object)remoteOnlyRecords.size());
                }
                if (!idDifference.localOnlyIds().isEmpty() && (updated = this.account.getRecipientStore().removeStorageIdsFromLocalOnlyUnregisteredRecipients(connection, idDifference.localOnlyIds())) > 0) {
                    logger.warn("Found {} records that were deleted remotely but only marked unregistered locally. Removed those from local store.", (Object)updated);
                }
                List<StorageId> unknownInserts = this.processKnownRecords(connection, remoteOnlyRecords);
                List<StorageId> unknownDeletes = idDifference.localOnlyIds().stream().filter(id -> !KNOWN_TYPES.contains(id.getType())).toList();
                logger.debug("Storage ids with unknown type: {} inserts, {} deletes", (Object)unknownInserts.size(), (Object)unknownDeletes.size());
                this.account.getUnknownStorageIdStore().addUnknownStorageIds(connection, unknownInserts);
                this.account.getUnknownStorageIdStore().deleteUnknownStorageIds(connection, unknownDeletes);
            } else {
                logger.debug("Remote version was newer, but there were no remote-only IDs.");
            }
            connection.commit();
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to sync remote storage", e);
        }
        return needsForcePush;
    }

    private void readRecordsWithPreviouslyUnknownTypes(StorageKey storageKey, SignalStorageManifest remoteManifest) throws IOException {
        try (Connection connection = this.account.getAccountDatabase().getConnection();){
            connection.setAutoCommit(false);
            List<StorageId> knownUnknownIds = this.account.getUnknownStorageIdStore().getUnknownStorageIds(connection, KNOWN_TYPES);
            if (!knownUnknownIds.isEmpty()) {
                logger.debug("We have {} unknown records that we can now process.", (Object)knownUnknownIds.size());
                List<SignalStorageRecord> remote = this.getSignalStorageRecords(storageKey, remoteManifest, knownUnknownIds);
                logger.debug("Found {} of the known-unknowns remotely.", (Object)remote.size());
                this.processKnownRecords(connection, remote);
                this.account.getUnknownStorageIdStore().deleteUnknownStorageIds(connection, remote.stream().map(SignalStorageRecord::getId).toList());
            }
            connection.commit();
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to sync remote storage", e);
        }
    }

    private boolean writeToStorage(StorageKey storageKey, SignalStorageManifest remoteManifest, boolean needsForcePush) throws IOException, RetryLaterException {
        StorageServiceRepository.WriteStorageRecordsResult result;
        WriteOperationResult remoteWriteOperation;
        try (Connection connection = this.account.getAccountDatabase().getConnection();){
            connection.setAutoCommit(false);
            List<StorageId> localStorageIds = this.getAllLocalStorageIds(connection);
            IdDifferenceResult idDifference = StorageHelper.findIdDifference(remoteManifest.storageIds, localStorageIds);
            logger.debug("ID Difference :: {}", (Object)idDifference);
            List<StorageId> unknownOnlyLocal = idDifference.localOnlyIds().stream().filter(id -> !KNOWN_TYPES.contains(id.getType())).toList();
            if (!unknownOnlyLocal.isEmpty()) {
                logger.debug("Storage ids with unknown type: {} to delete", (Object)unknownOnlyLocal.size());
                this.account.getUnknownStorageIdStore().deleteUnknownStorageIds(connection, unknownOnlyLocal);
                localStorageIds = this.getAllLocalStorageIds(connection);
                idDifference = StorageHelper.findIdDifference(remoteManifest.storageIds, localStorageIds);
            }
            List<byte[]> remoteDeletes = idDifference.remoteOnlyIds().stream().map(StorageId::getRaw).toList();
            List<SignalStorageRecord> remoteInserts = this.buildLocalStorageRecords(connection, idDifference.localOnlyIds());
            remoteWriteOperation = new WriteOperationResult(new SignalStorageManifest(remoteManifest.version + 1L, this.account.getDeviceId(), remoteManifest.recordIkm, localStorageIds), remoteInserts, remoteDeletes);
            connection.commit();
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to sync remote storage", e);
        }
        if (remoteWriteOperation.isEmpty()) {
            logger.debug("No remote writes needed. Still at version: {}", (Object)remoteManifest.version);
            return false;
        }
        logger.debug("We have something to write remotely.");
        logger.debug("WriteOperationResult :: {}", (Object)remoteWriteOperation);
        StorageSyncValidations.validate(remoteWriteOperation, remoteManifest, needsForcePush, this.account.getSelfRecipientAddress());
        StorageServiceRepository.WriteStorageRecordsResult writeStorageRecordsResult = result = this.dependencies.getStorageServiceRepository().writeStorageRecords(storageKey, remoteWriteOperation.manifest(), remoteWriteOperation.inserts(), remoteWriteOperation.deletes());
        Objects.requireNonNull(writeStorageRecordsResult);
        StorageServiceRepository.WriteStorageRecordsResult writeStorageRecordsResult2 = writeStorageRecordsResult;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{StorageServiceRepository.WriteStorageRecordsResult.ConflictError.class, StorageServiceRepository.WriteStorageRecordsResult.NetworkError.class, StorageServiceRepository.WriteStorageRecordsResult.StatusCodeError.class, StorageServiceRepository.WriteStorageRecordsResult.Success.class}, (Object)writeStorageRecordsResult2, n)) {
            case 0: {
                StorageServiceRepository.WriteStorageRecordsResult.ConflictError ignored = (StorageServiceRepository.WriteStorageRecordsResult.ConflictError)writeStorageRecordsResult2;
                logger.debug("Hit a conflict when trying to resolve the conflict! Retrying.");
                throw new RetryLaterException();
            }
            case 1: {
                StorageServiceRepository.WriteStorageRecordsResult.NetworkError networkError = (StorageServiceRepository.WriteStorageRecordsResult.NetworkError)writeStorageRecordsResult2;
                throw networkError.getException();
            }
            case 2: {
                StorageServiceRepository.WriteStorageRecordsResult.StatusCodeError statusCodeError = (StorageServiceRepository.WriteStorageRecordsResult.StatusCodeError)writeStorageRecordsResult2;
                throw statusCodeError.getException();
            }
            case 3: {
                StorageServiceRepository.WriteStorageRecordsResult.Success ignored = (StorageServiceRepository.WriteStorageRecordsResult.Success)writeStorageRecordsResult2;
                logger.debug("Saved new manifest. Now at version: {}", (Object)remoteWriteOperation.manifest().version);
                this.storeManifestLocally(remoteWriteOperation.manifest());
                return true;
            }
        }
        throw new IllegalStateException("Unexpected value: " + String.valueOf(result));
    }

    /*
     * WARNING - void declaration
     */
    private void forcePushToStorage(StorageKey storageServiceKey) throws IOException, RetryLaterException {
        void var13_18;
        RecordIkm recordIkm;
        Map<GroupIdV2, StorageId> newGroupV2StorageIds;
        Map<GroupIdV1, StorageId> newGroupV1StorageIds;
        Map<RecipientId, StorageId> newContactStorageIds;
        long currentVersion;
        logger.debug("Force pushing local state to remote storage");
        try {
            currentVersion = (Long)Utils.handleResponseException(this.dependencies.getStorageServiceRepository().getManifestVersion());
        }
        catch (NotFoundException e) {
            currentVersion = 0L;
        }
        long newVersion = currentVersion + 1L;
        ArrayList<SignalStorageRecord> newStorageRecords = new ArrayList<SignalStorageRecord>();
        try (Connection connection = this.account.getAccountDatabase().getConnection();){
            ContactRecord record;
            connection.setAutoCommit(false);
            List<RecipientId> recipientIds = this.account.getRecipientStore().getRecipientIds(connection);
            newContactStorageIds = this.generateContactStorageIds(recipientIds);
            for (RecipientId recipientId : recipientIds) {
                Recipient recipient;
                StorageId storageId = newContactStorageIds.get(recipientId);
                if (storageId.getType() == ManifestRecord.Identifier.Type.ACCOUNT.getValue()) {
                    recipient = this.account.getRecipientStore().getRecipient(connection, recipientId);
                    AccountRecord accountRecord = StorageSyncModels.localToRemoteRecord(connection, this.account.getConfigurationStore(), recipient, this.account.getUsernameLink());
                    newStorageRecords.add(new SignalStorageRecord(storageId, new StorageRecord.Builder().account(accountRecord).build()));
                    continue;
                }
                recipient = this.account.getRecipientStore().getRecipient(connection, recipientId);
                String address = recipient.getAddress().getIdentifier();
                IdentityInfo identity = this.account.getIdentityKeyStore().getIdentityInfo(connection, address);
                record = StorageSyncModels.localToRemoteRecord(recipient, identity);
                newStorageRecords.add(new SignalStorageRecord(storageId, new StorageRecord.Builder().contact(record).build()));
            }
            List<GroupIdV1> groupV1Ids = this.account.getGroupStore().getGroupV1Ids(connection);
            newGroupV1StorageIds = this.generateGroupV1StorageIds(groupV1Ids);
            for (GroupIdV1 groupIdV1 : groupV1Ids) {
                StorageId storageId = newGroupV1StorageIds.get(groupIdV1);
                GroupInfoV1 group = this.account.getGroupStore().getGroup(connection, groupIdV1);
                GroupV1Record record2 = StorageSyncModels.localToRemoteRecord(group);
                newStorageRecords.add(new SignalStorageRecord(storageId, new StorageRecord.Builder().groupV1(record2).build()));
            }
            List<GroupIdV2> list = this.account.getGroupStore().getGroupV2Ids(connection);
            newGroupV2StorageIds = this.generateGroupV2StorageIds(list);
            for (GroupIdV2 groupId3 : list) {
                StorageId storageId = newGroupV2StorageIds.get(groupId3);
                GroupInfoV2 group = this.account.getGroupStore().getGroup(connection, groupId3);
                record = StorageSyncModels.localToRemoteRecord(group);
                newStorageRecords.add(new SignalStorageRecord(storageId, new StorageRecord.Builder().groupV2((GroupV2Record)record).build()));
            }
            connection.commit();
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to sync remote storage", e);
        }
        List<StorageId> newStorageIds = newStorageRecords.stream().map(SignalStorageRecord::getId).toList();
        if (this.account.getSelfRecipientProfile().getCapabilities().contains((Object)Profile.Capability.storageServiceEncryptionV2Capability)) {
            logger.debug("Generating and including a new recordIkm.");
            recordIkm = RecordIkm.Companion.generate();
        } else {
            logger.debug("SSRE2 not yet supported. Not including recordIkm.");
            recordIkm = null;
        }
        SignalStorageManifest manifest = new SignalStorageManifest(newVersion, this.account.getDeviceId(), recordIkm, newStorageIds);
        StorageSyncValidations.validateForcePush(manifest, newStorageRecords, this.account.getSelfRecipientAddress());
        if (newVersion > 1L) {
            logger.trace("Force-pushing data. Inserting {} IDs.", (Object)newStorageRecords.size());
            StorageServiceRepository.WriteStorageRecordsResult writeStorageRecordsResult = this.dependencies.getStorageServiceRepository().resetAndWriteStorageRecords(storageServiceKey, manifest, newStorageRecords);
        } else {
            logger.trace("First version, normal push. Inserting {} IDs.", (Object)newStorageRecords.size());
            StorageServiceRepository.WriteStorageRecordsResult writeStorageRecordsResult = this.dependencies.getStorageServiceRepository().writeStorageRecords(storageServiceKey, manifest, newStorageRecords, Collections.emptyList());
        }
        void v0 = var13_18;
        Objects.requireNonNull(v0);
        void var14_23 = v0;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{StorageServiceRepository.WriteStorageRecordsResult.ConflictError.class, StorageServiceRepository.WriteStorageRecordsResult.NetworkError.class, StorageServiceRepository.WriteStorageRecordsResult.StatusCodeError.class, StorageServiceRepository.WriteStorageRecordsResult.Success.class}, (Object)var14_23, n)) {
            case 0: {
                StorageServiceRepository.WriteStorageRecordsResult.ConflictError ignored = (StorageServiceRepository.WriteStorageRecordsResult.ConflictError)var14_23;
                logger.debug("Hit a conflict. Trying again.");
                throw new RetryLaterException();
            }
            case 1: {
                StorageServiceRepository.WriteStorageRecordsResult.NetworkError networkError = (StorageServiceRepository.WriteStorageRecordsResult.NetworkError)var14_23;
                throw networkError.getException();
            }
            case 2: {
                StorageServiceRepository.WriteStorageRecordsResult.StatusCodeError statusCodeError = (StorageServiceRepository.WriteStorageRecordsResult.StatusCodeError)var14_23;
                throw statusCodeError.getException();
            }
            case 3: {
                StorageServiceRepository.WriteStorageRecordsResult.Success ignored = (StorageServiceRepository.WriteStorageRecordsResult.Success)var14_23;
                logger.debug("Force push succeeded. Updating local manifest version to: {}", (Object)manifest.version);
                this.storeManifestLocally(manifest);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + String.valueOf(var13_18));
            }
        }
        try (Connection connection = this.account.getAccountDatabase().getConnection();){
            connection.setAutoCommit(false);
            this.account.getRecipientStore().updateStorageIds(connection, newContactStorageIds);
            this.account.getGroupStore().updateStorageIds(connection, newGroupV1StorageIds, newGroupV2StorageIds);
            this.account.getUnknownStorageIdStore().deleteAllUnknownStorageIds(connection);
            connection.commit();
        }
        catch (SQLException sQLException) {
            throw new RuntimeException("Failed to sync remote storage", sQLException);
        }
    }

    private Map<RecipientId, StorageId> generateContactStorageIds(List<RecipientId> recipientIds) {
        RecipientId selfRecipientId = this.account.getSelfRecipientId();
        return recipientIds.stream().collect(Collectors.toMap(recipientId -> recipientId, recipientId -> {
            if (recipientId.equals(selfRecipientId)) {
                return StorageId.forAccount((byte[])KeyUtils.createRawStorageId());
            }
            return StorageId.forContact((byte[])KeyUtils.createRawStorageId());
        }));
    }

    private Map<GroupIdV1, StorageId> generateGroupV1StorageIds(List<GroupIdV1> groupIds) {
        return groupIds.stream().collect(Collectors.toMap(recipientId -> recipientId, recipientId -> StorageId.forGroupV1((byte[])KeyUtils.createRawStorageId())));
    }

    private Map<GroupIdV2, StorageId> generateGroupV2StorageIds(List<GroupIdV2> groupIds) {
        return groupIds.stream().collect(Collectors.toMap(recipientId -> recipientId, recipientId -> StorageId.forGroupV2((byte[])KeyUtils.createRawStorageId())));
    }

    private void storeManifestLocally(SignalStorageManifest remoteManifest) {
        this.account.setStorageManifestVersion(remoteManifest.version);
        this.account.setStorageManifest(remoteManifest);
    }

    private List<SignalStorageRecord> getSignalStorageRecords(StorageKey storageKey, SignalStorageManifest manifest, List<StorageId> storageIds) throws IOException {
        StorageServiceRepository.StorageRecordResult result;
        StorageServiceRepository.StorageRecordResult storageRecordResult = result = this.dependencies.getStorageServiceRepository().readStorageRecords(storageKey, manifest.recordIkm, storageIds);
        Objects.requireNonNull(storageRecordResult);
        StorageServiceRepository.StorageRecordResult storageRecordResult2 = storageRecordResult;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{StorageServiceRepository.StorageRecordResult.DecryptionError.class, StorageServiceRepository.StorageRecordResult.NetworkError.class, StorageServiceRepository.StorageRecordResult.StatusCodeError.class, StorageServiceRepository.StorageRecordResult.Success.class}, (Object)storageRecordResult2, n)) {
            case 0 -> {
                StorageServiceRepository.StorageRecordResult.DecryptionError decryptionError = (StorageServiceRepository.StorageRecordResult.DecryptionError)storageRecordResult2;
                if (decryptionError.getException() instanceof InvalidKeyException) {
                    logger.warn("Failed to read storage records, ignoring.");
                    yield List.of();
                }
                Exception var9_8 = decryptionError.getException();
                if (var9_8 instanceof IOException) {
                    IOException ioe = (IOException)var9_8;
                    throw ioe;
                }
                throw new IOException(decryptionError.getException());
            }
            case 1 -> {
                StorageServiceRepository.StorageRecordResult.NetworkError networkError = (StorageServiceRepository.StorageRecordResult.NetworkError)storageRecordResult2;
                throw networkError.getException();
            }
            case 2 -> {
                StorageServiceRepository.StorageRecordResult.StatusCodeError statusCodeError = (StorageServiceRepository.StorageRecordResult.StatusCodeError)storageRecordResult2;
                throw statusCodeError.getException();
            }
            case 3 -> {
                StorageServiceRepository.StorageRecordResult.Success success = (StorageServiceRepository.StorageRecordResult.Success)storageRecordResult2;
                yield success.getRecords();
            }
            default -> throw new IllegalStateException("Unexpected value: " + String.valueOf(result));
        };
    }

    private List<StorageId> getAllLocalStorageIds(Connection connection) throws SQLException {
        ArrayList<StorageId> storageIds = new ArrayList<StorageId>();
        storageIds.addAll(this.account.getUnknownStorageIdStore().getUnknownStorageIds(connection));
        storageIds.addAll(this.account.getGroupStore().getStorageIds(connection));
        storageIds.addAll(this.account.getRecipientStore().getStorageIds(connection));
        storageIds.add(this.account.getRecipientStore().getSelfStorageId(connection));
        return storageIds;
    }

    private List<SignalStorageRecord> buildLocalStorageRecords(Connection connection, List<StorageId> storageIds) throws SQLException {
        ArrayList<SignalStorageRecord> records = new ArrayList<SignalStorageRecord>(storageIds.size());
        for (StorageId storageId : storageIds) {
            SignalStorageRecord record = this.buildLocalStorageRecord(connection, storageId);
            records.add(record);
        }
        return records;
    }

    private SignalStorageRecord buildLocalStorageRecord(Connection connection, StorageId storageId) throws SQLException {
        ManifestRecord.Identifier.Type type = ManifestRecord.Identifier.Type.fromValue((int)storageId.getType());
        int n = 0;
        return switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"CONTACT", "GROUPV1", "GROUPV2", "ACCOUNT"}, (ManifestRecord.Identifier.Type)type, n)) {
            case 0 -> {
                Recipient recipient = this.account.getRecipientStore().getRecipient(connection, storageId);
                String address = recipient.getAddress().getIdentifier();
                IdentityInfo identity = this.account.getIdentityKeyStore().getIdentityInfo(connection, address);
                ContactRecord record = StorageSyncModels.localToRemoteRecord(recipient, identity);
                yield new SignalStorageRecord(storageId, new StorageRecord.Builder().contact(record).build());
            }
            case 1 -> {
                GroupInfoV1 groupV1 = this.account.getGroupStore().getGroupV1(connection, storageId);
                GroupV1Record record = StorageSyncModels.localToRemoteRecord(groupV1);
                yield new SignalStorageRecord(storageId, new StorageRecord.Builder().groupV1(record).build());
            }
            case 2 -> {
                GroupInfoV2 groupV2 = this.account.getGroupStore().getGroupV2(connection, storageId);
                GroupV2Record record = StorageSyncModels.localToRemoteRecord(groupV2);
                yield new SignalStorageRecord(storageId, new StorageRecord.Builder().groupV2(record).build());
            }
            case 3 -> {
                Recipient selfRecipient = this.account.getRecipientStore().getRecipient(connection, this.account.getSelfRecipientId());
                AccountRecord record = StorageSyncModels.localToRemoteRecord(connection, this.account.getConfigurationStore(), selfRecipient, this.account.getUsernameLink());
                yield new SignalStorageRecord(storageId, new StorageRecord.Builder().account(record).build());
            }
            default -> throw new AssertionError((Object)("Got unknown local storage record type: " + String.valueOf(storageId)));
        };
    }

    private static IdDifferenceResult findIdDifference(Collection<StorageId> remoteIds, Collection<StorageId> localIds) {
        Base64.Encoder base64Encoder = Base64.getEncoder();
        Map<String, StorageId> remoteByRawId = remoteIds.stream().collect(Collectors.toMap(id -> base64Encoder.encodeToString(id.getRaw()), id -> id));
        Map<String, StorageId> localByRawId = localIds.stream().collect(Collectors.toMap(id -> base64Encoder.encodeToString(id.getRaw()), id -> id));
        boolean hasTypeMismatch = remoteByRawId.size() != remoteIds.size() || localByRawId.size() != localIds.size();
        Set remoteOnlyRawIds = SetUtil.difference(remoteByRawId.keySet(), localByRawId.keySet());
        Set localOnlyRawIds = SetUtil.difference(localByRawId.keySet(), remoteByRawId.keySet());
        Set sharedRawIds = SetUtil.intersection(localByRawId.keySet(), remoteByRawId.keySet());
        for (String rawId : sharedRawIds) {
            StorageId remote = remoteByRawId.get(rawId);
            StorageId local = localByRawId.get(rawId);
            if (remote.getType() == local.getType() || !KNOWN_TYPES.contains(local.getType())) continue;
            remoteOnlyRawIds.remove(rawId);
            localOnlyRawIds.remove(rawId);
            hasTypeMismatch = true;
            logger.debug("Remote type {} did not match local type {} for {}!", new Object[]{remote.getType(), local.getType(), rawId});
        }
        List<StorageId> remoteOnlyKeys = remoteOnlyRawIds.stream().map(remoteByRawId::get).toList();
        List<StorageId> localOnlyKeys = localOnlyRawIds.stream().map(localByRawId::get).toList();
        return new IdDifferenceResult(remoteOnlyKeys, localOnlyKeys, hasTypeMismatch);
    }

    private List<StorageId> processKnownRecords(Connection connection, List<SignalStorageRecord> records) throws SQLException {
        ArrayList<StorageId> unknownRecords = new ArrayList<StorageId>();
        AccountRecordProcessor accountRecordProcessor = new AccountRecordProcessor(this.account, connection, this.context.getJobExecutor());
        ContactRecordProcessor contactRecordProcessor = new ContactRecordProcessor(this.account, connection, this.context.getJobExecutor());
        GroupV1RecordProcessor groupV1RecordProcessor = new GroupV1RecordProcessor(this.account, connection);
        GroupV2RecordProcessor groupV2RecordProcessor = new GroupV2RecordProcessor(this.account, connection);
        for (SignalStorageRecord record : records) {
            if (record.getProto().account != null) {
                logger.debug("Reading record {} of type account", (Object)record.getId());
                accountRecordProcessor.process((SignalRecord)StorageRecordConvertersKt.toSignalAccountRecord((AccountRecord)record.getProto().account, (StorageId)record.getId()));
                continue;
            }
            if (record.getProto().groupV1 != null) {
                logger.debug("Reading record {} of type groupV1", (Object)record.getId());
                groupV1RecordProcessor.process((SignalRecord)StorageRecordConvertersKt.toSignalGroupV1Record((GroupV1Record)record.getProto().groupV1, (StorageId)record.getId()));
                continue;
            }
            if (record.getProto().groupV2 != null) {
                logger.debug("Reading record {} of type groupV2", (Object)record.getId());
                groupV2RecordProcessor.process((SignalRecord)StorageRecordConvertersKt.toSignalGroupV2Record((GroupV2Record)record.getProto().groupV2, (StorageId)record.getId()));
                continue;
            }
            if (record.getProto().contact != null) {
                logger.debug("Reading record {} of type contact", (Object)record.getId());
                contactRecordProcessor.process((SignalRecord)StorageRecordConvertersKt.toSignalContactRecord((ContactRecord)record.getProto().contact, (StorageId)record.getId()));
                continue;
            }
            unknownRecords.add(record.getId());
        }
        return unknownRecords;
    }

    private static class RetryLaterException
    extends Throwable {
        private RetryLaterException() {
        }
    }

    private record IdDifferenceResult(List<StorageId> remoteOnlyIds, List<StorageId> localOnlyIds, boolean hasTypeMismatches) {
        public boolean isEmpty() {
            return this.remoteOnlyIds.isEmpty() && this.localOnlyIds.isEmpty();
        }
    }
}

