/***************************************************************************
 *   crengine-ng                                                           *
 *   Copyright (C) 2007 Vadim Lopatin <coolreader.org@gmail.com>           *
 *   Copyright (C) 2021 NiLuJe <ninuje@gmail.com>                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU General Public License           *
 *   as published by the Free Software Foundation; either version 2        *
 *   of the License, or (at your option) any later version.                *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the Free Software           *
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,            *
 *   MA 02110-1301, USA.                                                   *
 ***************************************************************************/

#ifndef __LVNODEIMAGESOURCE_H_INCLUDED__
#define __LVNODEIMAGESOURCE_H_INCLUDED__

#include <lvimagesource.h>
#include <lvstream.h>

struct ldomNode;

class LVNodeImageSource: public LVImageSource
{
protected:
    ldomNode* _node;
    LVStreamRef _stream;
    int _width;
    int _height;
public:
    LVNodeImageSource(ldomNode* node, LVStreamRef stream)
            : _node(node)
            , _stream(stream)
            , _width(0)
            , _height(0) {
    }
    ldomNode* GetSourceNode() {
        return _node;
    }
    virtual LVStream* GetSourceStream() {
        return _stream.get();
    }
    virtual void Compact() { }
    virtual int GetWidth() const {
        return _width;
    }
    virtual int GetHeight() const {
        return _height;
    }
    virtual bool Decode(LVImageDecoderCallback* callback) = 0;
    virtual ~LVNodeImageSource() { }
};

#endif // __LVNODEIMAGESOURCE_H_INCLUDED__
