/***************************************************************************
 *   crengine-ng                                                           *
 *   Copyright (C) 2007,2008 Vadim Lopatin <coolreader.org@gmail.com>      *
 *   Copyright (C) 2019 Aleksey Chernov <valexlin@gmail.com>               *
 *   Copyright (C) 2021 Carmina16 <mistresssilvara@hotmail.com>            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU General Public License           *
 *   as published by the Free Software Foundation; either version 2        *
 *   of the License, or (at your option) any later version.                *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the Free Software           *
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,            *
 *   MA 02110-1301, USA.                                                   *
 ***************************************************************************/

#include <crengine.h>

#include <stdio.h>
#include <stdlib.h>

#ifdef _WIN32
#define BASE_DIR  "text\\"
#define DEST_FILE "text\\cp_stats.cpp"
#else
#define BASE_DIR  "text/"
#define DEST_FILE "text/cp_stats.cpp"
#endif

void MakeStatsForFile(const char* fname, const char* cp_name, const char* lang_name, int index, FILE* f, lString8& list);

void MakeStats() {
    lString8 list(
            "typedef struct {\n"
            "    const short * ch_stat;\n"
            "    const dbl_char_stat_t * dbl_ch_stat;\n"
            "    char * cp_name;\n"
            "    char * lang_name;\n"
            "} cp_stat_t;\n"
            "\n\ncp_stat_t cp_stat_table[] = {\n");
    FILE* f = fopen(DEST_FILE, "wt");
    if (!f) {
        fprintf(stderr, "Can't open destination file!\n");
        return;
    }
    fprintf(f,
            "// LANGUAGE CODEPAGE AUTODETECTION STATISTICS FILE\n"
            "// generated by CoolReader3 (c)Vadim Lopatin, 2005-2008\n\n"
            "#include \"../include/cp_stats.h\"\n\n"
            "#define NULL 0\n\n");
    //"typedef struct {\n"
    //"   unsigned char ch1;\n"
    //"   unsigned char ch2;\n"
    //"   short    count;\n"
    //"} dbl_char_stat_t;\n\n#define NULL 0\n\n" );
    MakeStatsForFile(BASE_DIR "rus1_cp1251.txt", "cp1251", "ru", 1, f, list);
    MakeStatsForFile(BASE_DIR "rus1_cp866.txt", "cp866", "ru", 1, f, list);
    MakeStatsForFile(BASE_DIR "rus1_koi8r.txt", "koi8r", "ru", 1, f, list);
    MakeStatsForFile(BASE_DIR "rus1_utf8.txt", "utf8", "ru", 1, f, list);
    MakeStatsForFile(BASE_DIR "rus2_cp1251.txt", "cp1251", "ru", 2, f, list);
    MakeStatsForFile(BASE_DIR "rus2_cp866.txt", "cp866", "ru", 2, f, list);
    MakeStatsForFile(BASE_DIR "rus2_koi8r.txt", "koi8r", "ru", 2, f, list);
    MakeStatsForFile(BASE_DIR "bg1-cp1251.txt", "cp1251", "bg", 1, f, list);
    MakeStatsForFile(BASE_DIR "bg1-cp866.txt", "cp866", "bg", 1, f, list);
    MakeStatsForFile(BASE_DIR "bg1-koi8r.txt", "koi8r", "bg", 1, f, list);
    MakeStatsForFile(BASE_DIR "czech1-cp1250.txt", "cp1250", "cs", 1, f, list);
    MakeStatsForFile(BASE_DIR "czech2-iso8859-2.txt", "iso8859_2", "cs", 2, f, list);
    MakeStatsForFile(BASE_DIR "pl1-cp1250.txt", "cp1250", "pl", 1, f, list);
    MakeStatsForFile(BASE_DIR "pl2-cp1250.txt", "cp1250", "pl", 2, f, list);
    MakeStatsForFile(BASE_DIR "fr1-cp1252.txt", "cp1252", "fr", 1, f, list);
    MakeStatsForFile(BASE_DIR "fr2-cp1252.txt", "cp1252", "fr", 2, f, list);
    MakeStatsForFile(BASE_DIR "fr1-cp850.txt", "cp850", "fr", 1, f, list);
    MakeStatsForFile(BASE_DIR "fr2-cp850.txt", "cp850", "fr", 2, f, list);
    MakeStatsForFile(BASE_DIR "de1-cp1252.txt", "cp1252", "de", 1, f, list);
    MakeStatsForFile(BASE_DIR "de2-cp1252.txt", "cp1252", "de", 2, f, list);
    MakeStatsForFile(BASE_DIR "de1-cp850.txt", "cp850", "de", 1, f, list);
    MakeStatsForFile(BASE_DIR "de2-cp850.txt", "cp850", "de", 2, f, list);
    MakeStatsForFile(BASE_DIR "es1-cp1252.txt", "cp1252", "es", 1, f, list);
    MakeStatsForFile(BASE_DIR "es2-cp1252.txt", "cp1252", "es", 2, f, list);
    MakeStatsForFile(BASE_DIR "es1-cp850.txt", "cp850", "es", 1, f, list);
    MakeStatsForFile(BASE_DIR "es2-cp850.txt", "cp850", "es", 2, f, list);
    MakeStatsForFile(BASE_DIR "ee1-utf8.txt", "utf8", "ee", 1, f, list);
    MakeStatsForFile(BASE_DIR "es2-utf8.txt", "utf8", "ee", 2, f, list);
    MakeStatsForFile(BASE_DIR "ee3-cp775.txt", "cp775", "ee", 1, f, list);
    MakeStatsForFile(BASE_DIR "es3-cp1257.txt", "cp1257", "ee", 2, f, list);
    MakeStatsForFile(BASE_DIR "gr1-cp1253.txt", "cp1253", "el", 1, f, list);
    MakeStatsForFile(BASE_DIR "gr1-cp737.txt", "cp737", "el", 1, f, list);
    MakeStatsForFile(BASE_DIR "lit1-cp1257.txt", "cp1257", "lit", 1, f, list);
    MakeStatsForFile(BASE_DIR "lat1-cp1257.txt", "cp1257", "lat", 1, f, list);

    fprintf(f, "%s{NULL, NULL, NULL, NULL}\n};\n\n", list.c_str());
    fclose(f);
}

int main(int argc, char* argv[]) {
    MakeStats();
    return 0;
}
