Example of illegal code:

```ada
X : Integer with Volatile;

procedure P is
begin
   if X = 0 then -- error: wrong context for volatile object
      ...
   end if;
end P;
```

This error is issued on the use of volatile objects in arbitrary expressions,
like the comparison of `X` with value `0` above. That use violates legality
rule 10 of [section 7.1.3 of SPARK Reference Manual]. Indeed, reading a volatile
object is considered to have a side effect, which needs to be accounted for
during the analysis of the code.

Thus, such reads should occur in a restricted set of expressions defining
a so-called "non-interfering context", such as the
left-hand side or right-hand side of assignments. The appropriate fix for the
above code is to assign the value of `X` to a temporary constant:

```ada
procedure P is
   Tmp : constant Integer := X;
begin
   if Tmp = 0 then
      ...
   end if;
end P;
```

If `X` is only read but not written outside of the SPARK program, it is also
possible to mark it as having only asynchronous readers with aspect
`Async_Readers`, which makes it possible to read `X` in arbitrary expressions:

```ada
X : Integer with Volatile, Async_Readers;
```

[section 7.1.3 of SPARK Reference Manual]:
https://docs.adacore.com/live/wave/spark2014/html/spark2014_rm/packages.html#external-state-variables-and-types
