# -*- coding: utf-8 -*-
#
# SPARK 2014 User's Guide documentation build configuration file,
# created by sphinx-quickstart on Mon Apr 4 14:49:11 2011.
#
# This file is execfile()d with the current directory set to its containing
# dir.
#
# Note that not all possible configuration values are present in this
# autogenerated file.
#
# All configuration values have a default; values that are commented out
# serve to show the default.

import sys
import time
import os

# AdaCore specific Ada/SPARK highlighter, that does not crash

sys.path.append(
    os.path.join(os.path.dirname(os.path.abspath(__file__)), "..", "sphinx_support")
)
import ada_pygments  # noqa E402


def setup(app):
    app.add_lexer("ada", ada_pygments.AdaLexer)
    app.add_lexer("gpr", ada_pygments.GNATProjectLexer)
    app.add_css_file("css/table-wrap.css")


needs_sphinx = "1.4"

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom ones.
extensions = ["sphinx.ext.todo", "sphinx.ext.autosectionlabel", "sphinx_rtd_theme"]

# Add any paths that contain templates here, relative to this directory.
templates_path = ["_templates"]

# The suffix of source filenames.
source_suffix = ".rst"


def get_copyright():
    return "2011-%s, AdaCore and Capgemini Engineering" % time.strftime("%Y")


# General information about the project.
project = "SPARK User's Guide"
copyright = get_copyright()


# The version info for the project you're documenting, acts as replacement for
# |version| and |release|, also used in various other places throughout the
# built documents.
#
# The short X.Y version.

import confvars  # noqa E402

version = confvars.version
# The full version, including alpha/beta/rc tags.
release = version

# Substitution for the new SPARK name
rst_prolog = """.. |SPARK| replace:: SPARK
.. |GNATprove| replace:: GNATprove
.. |GNAT Pro| replace:: GNAT
.. |CodePeer| replace:: CodePeer
"""

exclude_patterns = ["_build"]

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
if tags.has("core_ja"):  # noqa F821
    language = "ja"
    exclude_patterns += ["en/*", "index.rst", "gnatprove_by_example/*.rst"]
    master_doc = "index_ja"
else:
    exclude_patterns += ["ja/*", "index_ja.rst"]
    master_doc = "index"

# The name of the Pygments (syntax highlighting) style to use.
pygments_style = None

# Treat todo and todolist blocks specially
todo_include_todos = True

# -- Options for HTML output --------------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
html_theme = "sphinx_rtd_theme"

# The name for this set of Sphinx documents.  If None, it defaults to
# "<project> v<release> documentation".
html_title = project + " " + release

# The name of an image file (within the static path) to use as favicon of the
# docs.  This file should be a Windows icon file (.ico) being 16x16 or 32x32
# pixels large.
html_favicon = "../shared_images/favicon.ico"

# The name of an image file (relative to this directory) to place at the top
# of the sidebar.
html_logo = "../shared_images/adacore-logo-white.png"

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_static_path = ["static"]

# Output file base name for HTML help builder.
htmlhelp_basename = "SPARK2014UsersGuidedoc"

# https://sphinx-rtd-theme.readthedocs.io/en/stable/configuring.html#theme-options
html_theme_options = {
     # Use AdaCore blue in the Table Of Content
     "style_nav_header_background": "#12284c",
 }


# -- Options for LaTeX output -------------------------------------------------

if tags.has("core_ja"):  # noqa
    with open("ja/gfdl_ja.tex", "r") as fd:
        gfdl = fd.read()
else:
    with open("en/gfdl.tex", "r") as fd:
        gfdl = fd.read()

latex_elements = {
    # Additional stuff for the LaTeX preamble.
    "tableofcontents": gfdl
    + "\n\n\\tableofcontents\n",
}

# Grouping the document tree into LaTeX files. List of tuples
# (source start file, target name, title, author, documentclass
# [howto/manual]).
latex_documents = [
    (
        master_doc,
        "spark2014_ug.tex",
        "SPARK User's Guide",
        "AdaCore and Capgemini Engineering",
        "manual",
    ),
]

# -- Options for manual page output -------------------------------------------

# One entry per manual page. List of tuples
# (source start file, name, description, authors, manual section).
man_pages = [
    (
        master_doc,
        "spark2014usersguide",
        "SPARK User's Guide",
        ["AdaCore and Capgemini Engineering"],
        1,
    )
]
