/*
 * MOTIS API
 *
 * This is the MOTIS routing API.  Overview of MOTIS API versions:  MOTIS 0.x - deprecated/discontinued  MOTIS 2.x - current, providing:  * /api/v5/{plan,trip,stoptimes,map/trips} renamed METRO mode to SUBURBAN, AREAL_LIFT to AERIAL_LIFT; since MOTIS 2.5.0 * /api/v4/{plan,trip,stoptimes,map/trips} new displayName property, routeShortName only contains actual route short name from source; since MOTIS 2.2.0 * /api/v3/plan with correct maxTransfers API parameter (transfers actually corresponding to number of changes between transit legs (and not to number of transit legs), i.e. maxTransfers=0 returns direct public transit connections, as expected); since MOTIS 2.0.84  * /api/v2/{plan,trip} returns Google polylines with precision=6; since MOTIS 2.0.60 * /api/v1/{plan,trip} returns Google polylines with precision=7 (not defined for |longitude|>107) * /api/v1/_* all other endpoints  If you use the JS client lib https://www.npmjs.com/package/@motis-project/motis-client, endpoint versions will be taken into account automatically (i.e. the newest one available will be used). 
 *
 * The version of the OpenAPI document: v5
 * Contact: felix@triptix.tech
 * Generated by: https://openapi-generator.tech
 */

use crate::models;
use serde::{Deserialize, Serialize};

/// FareTransfer : The concept is derived from: https://gtfs.org/documentation/schedule/reference/#fare_transfer_rulestxt  Terminology:   - **Leg**: An itinerary leg as described by the `Leg` type of this API description.   - **Effective Fare Leg**: Itinerary legs can be joined together to form one *effective fare leg*.   - **Fare Transfer**: A fare transfer groups two or more effective fare legs.   - **A** is the first *effective fare leg* of potentially multiple consecutive legs contained in a fare transfer   - **B** is any *effective fare leg* following the first *effective fare leg* in this transfer   - **AB** are all changes between *effective fare legs* contained in this transfer  The fare transfer rule is used to derive the final set of products of the itinerary legs contained in this transfer:   - A_AB means that any product from the first effective fare leg combined with the product attached to the transfer itself (AB) which can be empty (= free). Note that all subsequent effective fare leg products need to be ignored in this case.   - A_AB_B mean that a product for each effective fare leg needs to be purchased in a addition to the product attached to the transfer itself (AB) which can be empty (= free)   - AB only the transfer product itself has to be purchased. Note that all fare products attached to the contained effective fare legs need to be ignored in this case.  An itinerary `Leg` references the index of the fare transfer and the index of the effective fare leg in this transfer it belongs to. 
#[derive(Clone, Default, Debug, PartialEq, Serialize, Deserialize)]
pub struct FareTransfer {
    #[serde(rename = "rule", skip_serializing_if = "Option::is_none")]
    pub rule: Option<models::FareTransferRule>,
    #[serde(rename = "transferProducts", skip_serializing_if = "Option::is_none")]
    pub transfer_products: Option<Vec<models::FareProduct>>,
    /// Lists all valid fare products for the effective fare legs. This is an `array<array<FareProduct>>` where the inner array lists all possible fare products that would cover this effective fare leg. Each \"effective fare leg\" can have multiple options for adult/child/weekly/monthly/day/one-way tickets etc. You can see the outer array as AND (you need one ticket for each effective fare leg (`A_AB_B`), the first effective fare leg (`A_AB`) or no fare leg at all but only the transfer product (`AB`) and the inner array as OR (you can choose which ticket to buy) 
    #[serde(rename = "effectiveFareLegProducts")]
    pub effective_fare_leg_products: Vec<Vec<Vec<models::FareProduct>>>,
}

impl FareTransfer {
    /// The concept is derived from: https://gtfs.org/documentation/schedule/reference/#fare_transfer_rulestxt  Terminology:   - **Leg**: An itinerary leg as described by the `Leg` type of this API description.   - **Effective Fare Leg**: Itinerary legs can be joined together to form one *effective fare leg*.   - **Fare Transfer**: A fare transfer groups two or more effective fare legs.   - **A** is the first *effective fare leg* of potentially multiple consecutive legs contained in a fare transfer   - **B** is any *effective fare leg* following the first *effective fare leg* in this transfer   - **AB** are all changes between *effective fare legs* contained in this transfer  The fare transfer rule is used to derive the final set of products of the itinerary legs contained in this transfer:   - A_AB means that any product from the first effective fare leg combined with the product attached to the transfer itself (AB) which can be empty (= free). Note that all subsequent effective fare leg products need to be ignored in this case.   - A_AB_B mean that a product for each effective fare leg needs to be purchased in a addition to the product attached to the transfer itself (AB) which can be empty (= free)   - AB only the transfer product itself has to be purchased. Note that all fare products attached to the contained effective fare legs need to be ignored in this case.  An itinerary `Leg` references the index of the fare transfer and the index of the effective fare leg in this transfer it belongs to. 
    pub fn new(effective_fare_leg_products: Vec<Vec<Vec<models::FareProduct>>>) -> FareTransfer {
        FareTransfer {
            rule: None,
            transfer_products: None,
            effective_fare_leg_products,
        }
    }
}

