// $Id$

// Fish Supper
// Copyright 2006, 2007, 2009, 2010 Matthew Clarke <mafferyew@googlemail.com>
//
// This file is part of Fish Supper.
//
// Fish Supper is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Fish Supper is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Fish Supper.  If not, see <http://www.gnu.org/licenses/>.




#ifndef User_input_h
#define User_input_h




#include <list>
#include "SDL.h"
#include <fstream>
#include <iostream>




namespace FS
{

class User_input
{

    public:
        
        enum Keyboard_Event
        {
            UP_KEY_PRESSED,
            RIGHT_KEY_PRESSED,
            DOWN_KEY_PRESSED,
            LEFT_KEY_PRESSED,
            JUMP_KEY_PRESSED,
            ESCAPE_PRESSED,
            UP_KEY_RELEASED,
            RIGHT_KEY_RELEASED,
            DOWN_KEY_RELEASED,
            LEFT_KEY_RELEASED
        }; // enum Keyboard_Event    

        User_input();
        ~User_input();
        
        // Could be joystick- or keyboard-triggered. Turn
        // into an FS::Keyboard_Event and add to my_list.
        void add_event( const SDL_Event& event, bool joystick_selected );
        
        // Write the contents of the current list to fout.
        // The list is unchanged.
        // FIXME: format?!
        bool write_to_file( std::ofstream& fout ) const;
        
        // If there are any events left, remove from my_list
        // and put in ke - function returns true. If my_list is
        // empty, returns false.
        bool next_event( Keyboard_Event& ke );

        // FIXME: function for getting 'user' input from a file.
        
        // Only call this function when you know you've got an SDL_KEYDOWN
        // event.
        void add_keydown_event( const SDL_Event& event );
        
        bool next_keydown_event( SDL_keysym& ks );

    private:
        
        // Used as a FIFO structure.
        std::list<Keyboard_Event> my_list;
        
        // User-defined keys. These are the defaults.
        SDLKey left_key;
        SDLKey right_key;
        SDLKey up_key;
        SDLKey down_key;
        SDLKey jump_key;

        // Needed so that joystick events can emulate keyboard ones.
        Keyboard_Event last_horizontal_event;
        Keyboard_Event last_vertical_event;
        
        // For when all keydown events need to be recorded (e.g. when
        // entering your name on a high-score table).
        std::list<SDL_keysym> my_keydown_list;
        
}; // class User_input

} // namespace FS




#endif
