// $Id$

// Fish Supper
// Copyright 2006, 2007, 2009, 2010 Matthew Clarke <mafferyew@googlemail.com>
//
// This file is part of Fish Supper.
//
// Fish Supper is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Fish Supper is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Fish Supper.  If not, see <http://www.gnu.org/licenses/>.




#include "Star_particle_system.h"




// *******************
// *** CONSTRUCTOR ***
// *******************
FS::Star_particle_system::Star_particle_system()
{
    active = false;
    
} // FS::Star_particle_system::Star_particle_system

// ******************
// *** DESTRUCTOR ***
// ******************
FS::Star_particle_system::~Star_particle_system()
{
    // NYI
    
} // FS::Star_particle_system::~Star_particle_system




// ************************
// *** MEMBER FUNCTIONS ***
// ************************

// **************************************************

void FS::Star_particle_system::update(int time_passed, SDL_Rect box)
{
    // Check if we need to launch a new star particle.
    if ( (!stopped) && (num_stars < MAX_STARS) && 
            ((time_passed - start_time) > LAUNCH_INTERVAL) )
    {
        launch_new_star(time_passed, box);
        start_time = time_passed + ((time_passed - start_time) % LAUNCH_INTERVAL);
    } // if
     
    // Update existing star particles.
    bool still_alive = false;
    
    for (int i = 0; i < MAX_STARS; ++i)
    {
        if ( my_stars[i].active )
        {
            int age = time_passed - my_stars[i].start_time;
            if ( age < lifespan )
            {
                gfx_ptr->draw_texture( FS_gfx::STAR, my_stars[i].x, my_stars[i].y,
                        false, 0.0, true, (1.0 - (age / lifespan)) );
                still_alive = true;
            }
            else
            {
                my_stars[i].active = false;
            } // if ... else
        } // if
    } // for
    
    if ( !still_alive )
    {
        active = false;
    } // if
    
} // FS::Star_particle_system::update

// **************************************************

void FS::Star_particle_system::activate(int t, SDL_Rect box)
{
    active = true;
    stopped = false;
    start_time = t;
    num_stars = 0;
    
    for (int i = 0; i < MAX_STARS; ++i)
    {
        my_stars[i].active = false;
    } // for
    
    // launch a new star straight away
    launch_new_star(t, box);
    
} // FS::Star_particle_system::activate

// **************************************************

void FS::Star_particle_system::stop(int t)
{
    stopped = true;
    
} // FS::Star_particle_system::stop

// **************************************************

void FS::Star_particle_system::launch_new_star(int t, SDL_Rect box)
{
    box.x -= STAR_WIDTH;
    box.w += STAR_WIDTH;
    box.y -= STAR_HEIGHT;
    box.h += STAR_HEIGHT;
    
    my_stars[num_stars].active = true;
    my_stars[num_stars].x = box.x + (rand() % box.w);
    my_stars[num_stars].y = box.y + (rand() % box.h);
    my_stars[num_stars].start_time = t;
    
    ++num_stars;
    
} // FS::Star_particle_system::launch_new_star

// **************************************************
// **************************************************
// **************************************************
// **************************************************
// **************************************************
