// $Id$

// Fish Supper
// Copyright 2006, 2007, 2009, 2010 Matthew Clarke <mafferyew@googlemail.com>
//
// This file is part of Fish Supper.
//
// Fish Supper is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Fish Supper is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Fish Supper.  If not, see <http://www.gnu.org/licenses/>.




#ifndef Settings_h
#define Settings_h




#include <iostream>
#include <fstream>
#include <string>
#include <cstdlib>
#include "constants.h"




extern bool joystick_available;
extern bool sound_available;
extern char* fs_dir;




namespace FS
{

class Settings
{
    public:
            
        Settings();
        ~Settings();
        
        void read_config_file();
        void write_config_file();
        
        bool is_joystick_available() const { return joystick_available; }
        bool is_sound_available() const { return sound_available; }
        bool is_fullscreen() const { return fullscreen; }
        bool is_joystick_selected() const { return joystick_selected; }
        bool is_sound() const { return sound; }
        int get_furthest_level() const { return furthest_level; }
        
        void set_fullscreen(bool b) { fullscreen = b; }
        void set_joystick_selected(bool b); /* { joystick_selected = b; }*/
        void set_sound(bool b) { sound = b; }
        void set_furthest_level(int lev);
        
        void print_settings() const;

    private:
            
        bool fullscreen;
        bool joystick_selected;
        bool sound;
        int furthest_level;
        
}; // class Settings

} // namespace FS




#endif
    
