#ifndef __SAA716x_I2C_REG_H
#define __SAA716x_I2C_REG_H

/* -------------- I2C Registers -------------- */

#define RX_FIFO				0x000
#define I2C_RX_BYTE			(0x000000ff <<  0)

#define TX_FIFO				0x000
#define I2C_STOP_BIT			(0x00000001 <<  9)
#define I2C_START_BIT			(0x00000001 <<  8)
#define I2C_TX_BYTE			(0x000000ff <<  0)

#define I2C_STATUS			0x008
#define I2C_TRANSMIT			(0x00000001 << 11)
#define I2C_RECEIVE			(0x00000001 << 10)
#define I2C_TRANSMIT_S_PROG		(0x00000001 <<  9)
#define I2C_TRANSMIT_S_CLEAR		(0x00000001 <<  8)
#define I2C_TRANSMIT_PROG		(0x00000001 <<  7)
#define I2C_TRANSMIT_CLEAR		(0x00000001 <<  6)
#define I2C_RECEIVE_PROG		(0x00000001 <<  5)
#define I2C_RECEIVE_CLEAR		(0x00000001 <<  4)
#define I2C_SDA_LINE			(0x00000001 <<  3)
#define I2C_SCL_LINE			(0x00000001 <<  2)
#define I2C_START_STOP_FLAG		(0x00000001 <<  1)
#define I2C_MODE_STATUS			(0x00000001 <<  0)

#define I2C_CONTROL			0x00c
#define I2C_SCL_CONTROL			(0x00000001 <<  7)
#define I2C_SDA_CONTROL			(0x00000001 <<  6)
#define I2C_RECEIVE_PROTECT		(0x00000001 <<  5)
#define I2C_RECEIVE_PRO_READ		(0x00000001 <<  4)
#define I2C_TRANS_SELF_CLEAR		(0x00000001 <<  3)
#define I2C_TRANS_S_SELF_CLEAR		(0x00000001 <<  2)
#define I2C_SLAVE_ADDR_10BIT		(0x00000001 <<  1)
#define I2C_RESET			(0x00000001 <<  0)

#define I2C_CLOCK_DIVISOR_HIGH		0x010
#define I2C_CLOCK_HIGH			(0x0000ffff <<  0)

#define I2C_CLOCK_DIVISOR_LOW		0x014
#define I2C_CLOCK_LOW			(0x0000ffff <<  0)

#define I2C_RX_LEVEL			0x01c
#define I2C_RECEIVE_RANGE		(0x0000007f <<  0)

#define I2C_TX_LEVEL			0x020
#define I2C_TRANSMIT_RANGE		(0x0000007f <<  0)

#define I2C_SDA_HOLD			0x028
#define I2C_HOLD_TIME			(0x0000007f <<  0)

#define MODULE_CONF			0xfd4
#define INT_CLR_ENABLE			0xfd8
#define I2C_CLR_ENABLE_STFNF		(0x00000001 << 12)
#define I2C_CLR_ENABLE_MTFNF		(0x00000001 << 11)
#define I2C_CLR_ENABLE_RFDA		(0x00000001 << 10)
#define I2C_CLR_ENABLE_RFF		(0x00000001 <<  9)
#define I2C_CLR_ENABLE_STDR		(0x00000001 <<  8)
#define I2C_CLR_ENABLE_MTDR		(0x00000001 <<  7)
#define I2C_CLR_ENABLE_IBE		(0x00000001 <<  6)
#define I2C_CLR_ENABLE_MSMC		(0x00000001 <<  5)
#define I2C_CLR_ENABLE_SRSD		(0x00000001 <<  4)
#define I2C_CLR_ENABLE_STSD		(0x00000001 <<  3)
#define I2C_CLR_ENABLE_MTNA		(0x00000001 <<  2)
#define I2C_CLR_ENABLE_MAF		(0x00000001 <<  1)
#define I2C_CLR_ENABLE_MTD		(0x00000001 <<  0)

#define INT_SET_ENABLE			0xfdc
#define I2C_SET_ENABLE_STFNF		(0x00000001 << 12)
#define I2C_SET_ENABLE_MTFNF		(0x00000001 << 11)
#define I2C_SET_ENABLE_RFDA		(0x00000001 << 10)
#define I2C_SET_ENABLE_RFF		(0x00000001 <<  9)
#define I2C_SET_ENABLE_STDR		(0x00000001 <<  8)
#define I2C_SET_ENABLE_MTDR		(0x00000001 <<  7)
#define I2C_SET_ENABLE_IBE		(0x00000001 <<  6)
#define I2C_SET_ENABLE_MSMC		(0x00000001 <<  5)
#define I2C_SET_ENABLE_SRSD		(0x00000001 <<  4)
#define I2C_SET_ENABLE_STSD		(0x00000001 <<  3)
#define I2C_SET_ENABLE_MTNA		(0x00000001 <<  2)
#define I2C_SET_ENABLE_MAF		(0x00000001 <<  1)
#define I2C_SET_ENABLE_MTD		(0x00000001 <<  0)

#define INT_STATUS			0xfe0
#define I2C_INTERRUPT_STFNF		(0x00000001 << 12)
#define I2C_INTERRUPT_MTFNF		(0x00000001 << 11)
#define I2C_INTERRUPT_RFDA		(0x00000001 << 10)
#define I2C_INTERRUPTE_RFF		(0x00000001 <<  9)
#define I2C_SLAVE_INTERRUPT_STDR	(0x00000001 <<  8)
#define I2C_MASTER_INTERRUPT_MTDR	(0x00000001 <<  7)
#define I2C_ERROR_IBE			(0x00000001 <<  6)
#define I2C_MODE_CHANGE_INTER_MSMC	(0x00000001 <<  5)
#define I2C_SLAVE_RECEIVE_INTER_SRSD	(0x00000001 <<  4)
#define I2C_SLAVE_TRANSMIT_INTER_STSD	(0x00000001 <<  3)
#define I2C_ACK_INTER_MTNA		(0x00000001 <<  2)
#define I2C_FAILURE_INTER_MAF		(0x00000001 <<  1)
#define I2C_INTERRUPT_MTD		(0x00000001 <<  0)

#define INT_ENABLE			0xfe4
#define I2C_ENABLE_STFNF		(0x00000001 << 12)
#define I2C_ENABLE_MTFNF		(0x00000001 << 11)
#define I2C_ENABLE_RFDA			(0x00000001 << 10)
#define I2C_ENABLE_RFF			(0x00000001 <<  9)
#define I2C_ENABLE_STDR			(0x00000001 <<  8)
#define I2C_ENABLE_MTDR			(0x00000001 <<  7)
#define I2C_ENABLE_IBE			(0x00000001 <<  6)
#define I2C_ENABLE_MSMC			(0x00000001 <<  5)
#define I2C_ENABLE_SRSD			(0x00000001 <<  4)
#define I2C_ENABLE_STSD			(0x00000001 <<  3)
#define I2C_ENABLE_MTNA			(0x00000001 <<  2)
#define I2C_ENABLE_MAF			(0x00000001 <<  1)
#define I2C_ENABLE_MTD			(0x00000001 <<  0)

#define INT_CLR_STATUS			0xfe8
#define I2C_CLR_STATUS_STFNF		(0x00000001 << 12)
#define I2C_CLR_STATUS_MTFNF		(0x00000001 << 11)
#define I2C_CLR_STATUS_RFDA		(0x00000001 << 10)
#define I2C_CLR_STATUS_RFF		(0x00000001 <<  9)
#define I2C_CLR_STATUS_STDR		(0x00000001 <<  8)
#define I2C_CLR_STATUS_MTDR		(0x00000001 <<  7)
#define I2C_CLR_STATUS_IBE		(0x00000001 <<  6)
#define I2C_CLR_STATUS_MSMC		(0x00000001 <<  5)
#define I2C_CLR_STATUS_SRSD		(0x00000001 <<  4)
#define I2C_CLR_STATUS_STSD		(0x00000001 <<  3)
#define I2C_CLR_STATUS_MTNA		(0x00000001 <<  2)
#define I2C_CLR_STATUS_MAF		(0x00000001 <<  1)
#define I2C_CLR_STATIS_MTD		(0x00000001 <<  0)

#define INT_SET_STATUS			0xfec
#define I2C_SET_STATUS_STFNF		(0x00000001 << 12)
#define I2C_SET_STATUS_MTFNF		(0x00000001 << 11)
#define I2C_SET_STATUS_RFDA		(0x00000001 << 10)
#define I2C_SET_STATUS_RFF		(0x00000001 <<  9)
#define I2C_SET_STATUS_STDR		(0x00000001 <<  8)
#define I2C_SET_STATUS_MTDR		(0x00000001 <<  7)
#define I2C_SET_STATUS_IBE		(0x00000001 <<  6)
#define I2C_SET_STATUS_MSMC		(0x00000001 <<  5)
#define I2C_SET_STATUS_SRSD		(0x00000001 <<  4)
#define I2C_SET_STATUS_STSD		(0x00000001 <<  3)
#define I2C_SET_STATUS_MTNA		(0x00000001 <<  2)
#define I2C_SET_STATUS_MAF		(0x00000001 <<  1)
#define I2C_SET_STATIS_MTD		(0x00000001 <<  0)


#endif /* __SAA716x_I2C_REG_H */
