/***************************************************************************
 $RCSfile: cardfs.h,v $
                             -------------------
    cvs         : $Id: cardfs.h,v 1.1.1.1 2003/01/25 22:36:44 mali Exp $
    begin       : Thu Aug 15 2002
    copyright   : (C) 2002 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef _CARDFS_H_
#define _CARDFS_H_

#include <vector>
#include <string>

#include <chipcard.h>
#include <fileclient.h>

using namespace std;

struct directory;

#define TIMEOUT1 (10*1000)
#define TIMEOUT2 (60*1000)

/* Main filesystem class, extending FileSystem */
class CardFS{
private:
    struct credentials *cred;
    struct dir_cache *cache;
    struct list_head *cfg;

    string _host;
    string _terminal;
    string _cid;

    struct lufs_fattr _entry2fattr(const CTDirEntry &e);
    unsigned int _mode2attribs(int mode);

public:
    CardFS(struct list_head*, struct dir_cache*, struct credentials*);
    ~CardFS();

    int do_mount();
    void do_umount();
    int do_readdir(char*, struct directory*);
    int do_stat(char*, struct lufs_fattr*);
    int do_mkdir(char*, int);
    int do_rmdir(char*);
    int do_create(char*, int);
    int do_unlink(char*);
    int do_rename(char*, char*);
    int do_open(char*, unsigned);
    int do_release(char*);
    int do_read(char*, unsigned long, unsigned long, char*);
    int do_write(char*, unsigned long, unsigned long, char*);
    int do_readlink(char*, char*, int);
    int do_link(char*, char*);
    int do_symlink(char*, char*);
    int do_setattr(char*, struct lufs_fattr*);
};

#endif

