/*
  filesize.c - functions that deal with file size values

  Copyright 2003 Damien Gregory (dgregory@lightuniverse.no-ip.com)

    This file is part of pipeworks.

    pipeworks is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    pipeworks is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with pipeworks; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include "filesize.h"

fsize_t sizemultiplier (char type)
{
  switch (type) {
  case 'y':
  case 'Y':
    return yotta(1);
  case 'z':
  case 'Z':
    return zetta(1);
  case 'e':
  case 'E':
    return exa(1);
  case 'p':
  case 'P':
    return peta(1);
  case 't':
  case 'T':
    return tera(1);
  case 'g':
  case 'G':
    return giga(1);
  case 'm':
  case 'M':
    return mega(1);
  case 'k':
  case 'K':
    return kilo(1);
  default:
    return 1;
  }
  return 0;
}

fsize_t convertsize (fsize_t s, char source, char dest)
{
  return s * sizemultiplier (source) / sizemultiplier (dest);
}

char *formatsize (fsize_t s, char source, char dest, char *format)
{
  static char buf[1024],fmt[1024]="%.3Lf %c";
  char *f=fmt;
  fsize_t bval;

  if ( format ) f=format;

  bval = convertsize (s, source, 'b');
  
  if (! dest ) {
     if ( bval >= yotta (1) )
      dest='y';
    else if ( bval >= zetta (1) )
      dest='z';
    else if ( bval >= exa (1) )
      dest='e';
    else if ( bval >= peta (1) )
      dest='p';
    else if ( bval >= tera (1) )
      dest='t';
    else if ( bval >= giga (1) )
      dest='g';
    else if ( bval >= mega (1) )
      dest='M';
    else if ( bval >= kilo (1) )
      dest='k';
    else
      dest=0;
  }
  
  sprintf (buf, f, convertsize (s, source, dest), dest);

  return buf;
}

fsize_t parsesize (char *s, char dest)
{
  fsize_t x;
  char t=0;

  sscanf (s, "%Lf%c", &x, &t);

  return convertsize (x, t, dest);
}  

