// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py UTC_ARGS: --function-signature --include-generated-funcs --replace-value-regex "__omp_offloading_[0-9a-z]+_[0-9a-z]+" "reduction_size[.].+[.]" "pl_cond[.].+[.|,]" --prefix-filecheck-ir-name _
// REQUIRES: amdgpu-registered-target

// RUN: %clang_cc1 -fopenmp -x c++ -std=c++11 -triple x86_64-unknown-unknown -fopenmp-targets=amdgcn-amd-amdhsa -emit-llvm-bc %s -o %t-ppc-host.bc
// RUN: %clang_cc1 -fopenmp -x c++ -std=c++11 -triple amdgcn-amd-amdhsa -fopenmp-targets=amdgcn-amd-amdhsa -emit-llvm %s -fopenmp-is-device -fopenmp-host-ir-file-path %t-ppc-host.bc -o - | FileCheck %s
// expected-no-diagnostics

int main()
{
  int N = 100000;

  int a[N];
  int b[N];

  int i;

  for (i=0; i<N; i++)
    b[i]=i;

  for (i=0; i<N; i++)
    a[i]=0;

  int j;
#pragma omp target teams distribute parallel for num_teams(200)
  {
    for (j = 0; j< N; j++)
      a[j]=b[j];
  }

#pragma omp target teams distribute parallel for
  for (int k = 0; k< N; k++) {
#pragma omp simd
    for (int p = 0; p < N; p++)
      a[p]=b[p];
  }

}
// CHECK-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l24
// CHECK-SAME: (ptr noalias noundef [[DYN_PTR:%.*]], i64 noundef [[N:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[A:%.*]], i64 noundef [[VLA1:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[B:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[DYN_PTR_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[N_ADDR:%.*]] = alloca i64, align 8, addrspace(5)
// CHECK-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8, addrspace(5)
// CHECK-NEXT:    [[A_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[VLA_ADDR2:%.*]] = alloca i64, align 8, addrspace(5)
// CHECK-NEXT:    [[B_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[J:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-NEXT:    [[DOTCAPTURE_EXPR_3:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-NEXT:    [[DYN_PTR_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DYN_PTR_ADDR]] to ptr
// CHECK-NEXT:    [[N_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[N_ADDR]] to ptr
// CHECK-NEXT:    [[VLA_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[VLA_ADDR]] to ptr
// CHECK-NEXT:    [[A_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[A_ADDR]] to ptr
// CHECK-NEXT:    [[VLA_ADDR2_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[VLA_ADDR2]] to ptr
// CHECK-NEXT:    [[B_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[B_ADDR]] to ptr
// CHECK-NEXT:    [[J_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[J]] to ptr
// CHECK-NEXT:    [[DOTCAPTURE_EXPR__ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTCAPTURE_EXPR_]] to ptr
// CHECK-NEXT:    [[DOTCAPTURE_EXPR_3_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTCAPTURE_EXPR_3]] to ptr
// CHECK-NEXT:    [[DOTOMP_LB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_LB]] to ptr
// CHECK-NEXT:    [[DOTOMP_UB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_UB]] to ptr
// CHECK-NEXT:    [[DOTOMP_IV_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_IV]] to ptr
// CHECK-NEXT:    store ptr [[DYN_PTR]], ptr [[DYN_PTR_ADDR_ASCAST]], align 8
// CHECK-NEXT:    store i64 [[N]], ptr [[N_ADDR_ASCAST]], align 8
// CHECK-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[A]], ptr [[A_ADDR_ASCAST]], align 8
// CHECK-NEXT:    store i64 [[VLA1]], ptr [[VLA_ADDR2_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[B]], ptr [[B_ADDR_ASCAST]], align 8
// CHECK-NEXT:    [[TMP0:%.*]] = load i64, ptr [[VLA_ADDR_ASCAST]], align 8
// CHECK-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[A_ADDR_ASCAST]], align 8
// CHECK-NEXT:    [[TMP2:%.*]] = load i64, ptr [[VLA_ADDR2_ASCAST]], align 8
// CHECK-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[B_ADDR_ASCAST]], align 8
// CHECK-NEXT:    [[TMP4:%.*]] = load i32, ptr [[N_ADDR_ASCAST]], align 4
// CHECK-NEXT:    store i32 [[TMP4]], ptr [[DOTCAPTURE_EXPR__ASCAST]], align 4
// CHECK-NEXT:    [[TMP5:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR__ASCAST]], align 4
// CHECK-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP5]], 0
// CHECK-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK-NEXT:    [[SUB4:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK-NEXT:    store i32 [[SUB4]], ptr [[DOTCAPTURE_EXPR_3_ASCAST]], align 4
// CHECK-NEXT:    store i32 0, ptr [[J_ASCAST]], align 4
// CHECK-NEXT:    store i32 0, ptr [[DOTOMP_LB_ASCAST]], align 4
// CHECK-NEXT:    [[TMP6:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_3_ASCAST]], align 4
// CHECK-NEXT:    store i32 [[TMP6]], ptr [[DOTOMP_UB_ASCAST]], align 4
// CHECK-NEXT:    [[TMP7:%.*]] = load i32, ptr [[DOTOMP_LB_ASCAST]], align 4
// CHECK-NEXT:    store i32 [[TMP7]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP8:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// CHECK-NEXT:    [[NVPTX_NUM_THREADS:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// CHECK-NEXT:    [[GPU_BLOCK_ID:%.*]] = call i32 @llvm.amdgcn.workgroup.id.x()
// CHECK-NEXT:    [[TMP9:%.*]] = mul i32 [[GPU_BLOCK_ID]], [[NVPTX_NUM_THREADS]]
// CHECK-NEXT:    [[TMP10:%.*]] = add i32 [[TMP9]], [[TMP8]]
// CHECK-NEXT:    [[TMP11:%.*]] = mul i32 [[TMP10]], 1
// CHECK-NEXT:    [[TMP12:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP13:%.*]] = add i32 [[TMP11]], [[TMP12]]
// CHECK-NEXT:    store i32 [[TMP13]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    br label [[FOR_COND:%.*]]
// CHECK:       for.cond:
// CHECK-NEXT:    [[TMP14:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP15:%.*]] = load i32, ptr [[DOTOMP_UB_ASCAST]], align 4
// CHECK-NEXT:    [[CMP:%.*]] = icmp sle i32 [[TMP14]], [[TMP15]]
// CHECK-NEXT:    br i1 [[CMP]], label [[FOR_BODY:%.*]], label [[FOR_END:%.*]]
// CHECK:       for.body:
// CHECK-NEXT:    [[TMP16:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP16]], 1
// CHECK-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK-NEXT:    store i32 [[ADD]], ptr [[J_ASCAST]], align 4
// CHECK-NEXT:    [[TMP17:%.*]] = load i32, ptr [[J_ASCAST]], align 4
// CHECK-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP17]] to i64
// CHECK-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, ptr [[TMP3]], i64 [[IDXPROM]]
// CHECK-NEXT:    [[TMP18:%.*]] = load i32, ptr [[ARRAYIDX]], align 4
// CHECK-NEXT:    [[TMP19:%.*]] = load i32, ptr [[J_ASCAST]], align 4
// CHECK-NEXT:    [[IDXPROM5:%.*]] = sext i32 [[TMP19]] to i64
// CHECK-NEXT:    [[ARRAYIDX6:%.*]] = getelementptr inbounds i32, ptr [[TMP1]], i64 [[IDXPROM5]]
// CHECK-NEXT:    store i32 [[TMP18]], ptr [[ARRAYIDX6]], align 4
// CHECK-NEXT:    br label [[FOR_INC:%.*]]
// CHECK:       for.inc:
// CHECK-NEXT:    [[NVPTX_NUM_THREADS7:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// CHECK-NEXT:    [[TMP20:%.*]] = call i32 @__kmpc_get_hardware_num_blocks()
// CHECK-NEXT:    [[TMP21:%.*]] = mul i32 [[NVPTX_NUM_THREADS7]], [[TMP20]]
// CHECK-NEXT:    [[TMP22:%.*]] = mul i32 [[TMP21]], 1
// CHECK-NEXT:    [[TMP23:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP24:%.*]] = add i32 [[TMP22]], [[TMP23]]
// CHECK-NEXT:    store i32 [[TMP24]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    br label [[FOR_COND]], !llvm.loop [[LOOP9:![0-9]+]]
// CHECK:       for.end:
// CHECK-NEXT:    ret void
//
//
// CHECK-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l30
// CHECK-SAME: (ptr noalias noundef [[DYN_PTR:%.*]], i64 noundef [[N:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[A:%.*]], i64 noundef [[VLA1:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[B:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[DYN_PTR_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[N_ADDR:%.*]] = alloca i64, align 8, addrspace(5)
// CHECK-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8, addrspace(5)
// CHECK-NEXT:    [[A_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[VLA_ADDR2:%.*]] = alloca i64, align 8, addrspace(5)
// CHECK-NEXT:    [[B_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[K:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-NEXT:    [[DOTCAPTURE_EXPR_3:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-NEXT:    [[TMP:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-NEXT:    [[DOTCAPTURE_EXPR_5:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-NEXT:    [[DOTCAPTURE_EXPR_6:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-NEXT:    [[P:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-NEXT:    [[DOTOMP_IV11:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-NEXT:    [[P12:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-NEXT:    [[DYN_PTR_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DYN_PTR_ADDR]] to ptr
// CHECK-NEXT:    [[N_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[N_ADDR]] to ptr
// CHECK-NEXT:    [[VLA_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[VLA_ADDR]] to ptr
// CHECK-NEXT:    [[A_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[A_ADDR]] to ptr
// CHECK-NEXT:    [[VLA_ADDR2_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[VLA_ADDR2]] to ptr
// CHECK-NEXT:    [[B_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[B_ADDR]] to ptr
// CHECK-NEXT:    [[K_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[K]] to ptr
// CHECK-NEXT:    [[DOTCAPTURE_EXPR__ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTCAPTURE_EXPR_]] to ptr
// CHECK-NEXT:    [[DOTCAPTURE_EXPR_3_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTCAPTURE_EXPR_3]] to ptr
// CHECK-NEXT:    [[DOTOMP_LB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_LB]] to ptr
// CHECK-NEXT:    [[DOTOMP_UB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_UB]] to ptr
// CHECK-NEXT:    [[DOTOMP_IV_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_IV]] to ptr
// CHECK-NEXT:    [[TMP_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[TMP]] to ptr
// CHECK-NEXT:    [[DOTCAPTURE_EXPR_5_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTCAPTURE_EXPR_5]] to ptr
// CHECK-NEXT:    [[DOTCAPTURE_EXPR_6_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTCAPTURE_EXPR_6]] to ptr
// CHECK-NEXT:    [[P_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[P]] to ptr
// CHECK-NEXT:    [[DOTOMP_IV11_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_IV11]] to ptr
// CHECK-NEXT:    [[P12_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[P12]] to ptr
// CHECK-NEXT:    store ptr [[DYN_PTR]], ptr [[DYN_PTR_ADDR_ASCAST]], align 8
// CHECK-NEXT:    store i64 [[N]], ptr [[N_ADDR_ASCAST]], align 8
// CHECK-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[A]], ptr [[A_ADDR_ASCAST]], align 8
// CHECK-NEXT:    store i64 [[VLA1]], ptr [[VLA_ADDR2_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[B]], ptr [[B_ADDR_ASCAST]], align 8
// CHECK-NEXT:    [[TMP0:%.*]] = load i64, ptr [[VLA_ADDR_ASCAST]], align 8
// CHECK-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[A_ADDR_ASCAST]], align 8
// CHECK-NEXT:    [[TMP2:%.*]] = load i64, ptr [[VLA_ADDR2_ASCAST]], align 8
// CHECK-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[B_ADDR_ASCAST]], align 8
// CHECK-NEXT:    store i32 0, ptr [[K_ASCAST]], align 4
// CHECK-NEXT:    [[TMP4:%.*]] = load i32, ptr [[N_ADDR_ASCAST]], align 4
// CHECK-NEXT:    store i32 [[TMP4]], ptr [[DOTCAPTURE_EXPR__ASCAST]], align 4
// CHECK-NEXT:    [[TMP5:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR__ASCAST]], align 4
// CHECK-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP5]], 0
// CHECK-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK-NEXT:    [[SUB4:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK-NEXT:    store i32 [[SUB4]], ptr [[DOTCAPTURE_EXPR_3_ASCAST]], align 4
// CHECK-NEXT:    store i32 0, ptr [[K_ASCAST]], align 4
// CHECK-NEXT:    store i32 0, ptr [[DOTOMP_LB_ASCAST]], align 4
// CHECK-NEXT:    [[TMP6:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_3_ASCAST]], align 4
// CHECK-NEXT:    store i32 [[TMP6]], ptr [[DOTOMP_UB_ASCAST]], align 4
// CHECK-NEXT:    [[TMP7:%.*]] = load i32, ptr [[DOTOMP_LB_ASCAST]], align 4
// CHECK-NEXT:    store i32 [[TMP7]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP8:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// CHECK-NEXT:    [[NVPTX_NUM_THREADS:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// CHECK-NEXT:    [[GPU_BLOCK_ID:%.*]] = call i32 @llvm.amdgcn.workgroup.id.x()
// CHECK-NEXT:    [[TMP9:%.*]] = mul i32 [[GPU_BLOCK_ID]], [[NVPTX_NUM_THREADS]]
// CHECK-NEXT:    [[TMP10:%.*]] = add i32 [[TMP9]], [[TMP8]]
// CHECK-NEXT:    [[TMP11:%.*]] = mul i32 [[TMP10]], 1
// CHECK-NEXT:    [[TMP12:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP13:%.*]] = add i32 [[TMP11]], [[TMP12]]
// CHECK-NEXT:    store i32 [[TMP13]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    br label [[FOR_COND:%.*]]
// CHECK:       for.cond:
// CHECK-NEXT:    [[TMP14:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP15:%.*]] = load i32, ptr [[DOTOMP_UB_ASCAST]], align 4
// CHECK-NEXT:    [[CMP:%.*]] = icmp sle i32 [[TMP14]], [[TMP15]]
// CHECK-NEXT:    br i1 [[CMP]], label [[FOR_BODY:%.*]], label [[FOR_END:%.*]]
// CHECK:       for.body:
// CHECK-NEXT:    [[TMP16:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP16]], 1
// CHECK-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK-NEXT:    store i32 [[ADD]], ptr [[K_ASCAST]], align 4
// CHECK-NEXT:    [[TMP17:%.*]] = load i32, ptr [[N_ADDR_ASCAST]], align 4
// CHECK-NEXT:    store i32 [[TMP17]], ptr [[DOTCAPTURE_EXPR_5_ASCAST]], align 4
// CHECK-NEXT:    [[TMP18:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_5_ASCAST]], align 4
// CHECK-NEXT:    [[SUB7:%.*]] = sub nsw i32 [[TMP18]], 0
// CHECK-NEXT:    [[DIV8:%.*]] = sdiv i32 [[SUB7]], 1
// CHECK-NEXT:    [[SUB9:%.*]] = sub nsw i32 [[DIV8]], 1
// CHECK-NEXT:    store i32 [[SUB9]], ptr [[DOTCAPTURE_EXPR_6_ASCAST]], align 4
// CHECK-NEXT:    store i32 0, ptr [[P_ASCAST]], align 4
// CHECK-NEXT:    [[TMP19:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_5_ASCAST]], align 4
// CHECK-NEXT:    [[CMP10:%.*]] = icmp slt i32 0, [[TMP19]]
// CHECK-NEXT:    br i1 [[CMP10]], label [[SIMD_IF_THEN:%.*]], label [[SIMD_IF_END:%.*]]
// CHECK:       simd.if.then:
// CHECK-NEXT:    store i32 0, ptr [[DOTOMP_IV11_ASCAST]], align 4
// CHECK-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK:       omp.inner.for.cond:
// CHECK-NEXT:    [[TMP20:%.*]] = load i32, ptr [[DOTOMP_IV11_ASCAST]], align 4, !llvm.access.group [[ACC_GRP11:![0-9]+]]
// CHECK-NEXT:    [[TMP21:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_6_ASCAST]], align 4, !llvm.access.group [[ACC_GRP11]]
// CHECK-NEXT:    [[ADD13:%.*]] = add nsw i32 [[TMP21]], 1
// CHECK-NEXT:    [[CMP14:%.*]] = icmp slt i32 [[TMP20]], [[ADD13]]
// CHECK-NEXT:    br i1 [[CMP14]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK:       omp.inner.for.body:
// CHECK-NEXT:    [[TMP22:%.*]] = load i32, ptr [[DOTOMP_IV11_ASCAST]], align 4, !llvm.access.group [[ACC_GRP11]]
// CHECK-NEXT:    [[MUL15:%.*]] = mul nsw i32 [[TMP22]], 1
// CHECK-NEXT:    [[ADD16:%.*]] = add nsw i32 0, [[MUL15]]
// CHECK-NEXT:    store i32 [[ADD16]], ptr [[P12_ASCAST]], align 4, !llvm.access.group [[ACC_GRP11]]
// CHECK-NEXT:    [[TMP23:%.*]] = load i32, ptr [[P12_ASCAST]], align 4, !llvm.access.group [[ACC_GRP11]]
// CHECK-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP23]] to i64
// CHECK-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, ptr [[TMP3]], i64 [[IDXPROM]]
// CHECK-NEXT:    [[TMP24:%.*]] = load i32, ptr [[ARRAYIDX]], align 4, !llvm.access.group [[ACC_GRP11]]
// CHECK-NEXT:    [[TMP25:%.*]] = load i32, ptr [[P12_ASCAST]], align 4, !llvm.access.group [[ACC_GRP11]]
// CHECK-NEXT:    [[IDXPROM17:%.*]] = sext i32 [[TMP25]] to i64
// CHECK-NEXT:    [[ARRAYIDX18:%.*]] = getelementptr inbounds i32, ptr [[TMP1]], i64 [[IDXPROM17]]
// CHECK-NEXT:    store i32 [[TMP24]], ptr [[ARRAYIDX18]], align 4, !llvm.access.group [[ACC_GRP11]]
// CHECK-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK:       omp.body.continue:
// CHECK-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK:       omp.inner.for.inc:
// CHECK-NEXT:    [[TMP26:%.*]] = load i32, ptr [[DOTOMP_IV11_ASCAST]], align 4, !llvm.access.group [[ACC_GRP11]]
// CHECK-NEXT:    [[ADD19:%.*]] = add nsw i32 [[TMP26]], 1
// CHECK-NEXT:    store i32 [[ADD19]], ptr [[DOTOMP_IV11_ASCAST]], align 4, !llvm.access.group [[ACC_GRP11]]
// CHECK-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP12:![0-9]+]]
// CHECK:       omp.inner.for.end:
// CHECK-NEXT:    [[TMP27:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_5_ASCAST]], align 4
// CHECK-NEXT:    [[SUB20:%.*]] = sub nsw i32 [[TMP27]], 0
// CHECK-NEXT:    [[DIV21:%.*]] = sdiv i32 [[SUB20]], 1
// CHECK-NEXT:    [[MUL22:%.*]] = mul nsw i32 [[DIV21]], 1
// CHECK-NEXT:    [[ADD23:%.*]] = add nsw i32 0, [[MUL22]]
// CHECK-NEXT:    store i32 [[ADD23]], ptr [[P12_ASCAST]], align 4
// CHECK-NEXT:    br label [[SIMD_IF_END]]
// CHECK:       simd.if.end:
// CHECK-NEXT:    br label [[FOR_INC:%.*]]
// CHECK:       for.inc:
// CHECK-NEXT:    [[NVPTX_NUM_THREADS24:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// CHECK-NEXT:    [[TMP28:%.*]] = call i32 @__kmpc_get_hardware_num_blocks()
// CHECK-NEXT:    [[TMP29:%.*]] = mul i32 [[NVPTX_NUM_THREADS24]], [[TMP28]]
// CHECK-NEXT:    [[TMP30:%.*]] = mul i32 [[TMP29]], 1
// CHECK-NEXT:    [[TMP31:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP32:%.*]] = add i32 [[TMP30]], [[TMP31]]
// CHECK-NEXT:    store i32 [[TMP32]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    br label [[FOR_COND]], !llvm.loop [[LOOP15:![0-9]+]]
// CHECK:       for.end:
// CHECK-NEXT:    ret void
//
