#ifndef	__CAOEFDEF_H_
#define	__CAOEFDEF_H_

#include "listdef.h"

#ifndef __CABYTE_
#define	__CABYTE_
typedef	unsigned char CAByte;
#endif

#ifndef __CAFALSE_
#define	__CAFALSE_
#define	CAFalse	0
#endif

#ifndef __CATRUE_
#define	__CATRUE_
#define	CATrue	1	
#endif

#ifdef CAPT_DUMMY_API
/* Linux CAPT */
typedef void CACFObj;
typedef CAOptList CACFOptList;
typedef struct{
	void *pOptDev;
	void *pCalib;
}CACFDev;

// V200-007(A)
typedef struct{
	int nStartPixel;
	int nEndPixel;
} CAOEFScanlineExtent;

typedef struct{
	int nLinePixels;
	int nLength;
	int nInputType;
	int nRotate;
	char *pPaperSize;
}CACFInputParam;
#endif /* CAPT_DUMMY_API */

/* Linux UFR2 */

typedef void CAOEFObj;

typedef CAOptList CAOEFOptList;

typedef struct{
	void *pOptDev;
	void *pCalib;
}CAOEFDev;

typedef struct{ /* v150 caoefRasterData I/F modification */
	int nStartPixel;
	int nEndPixel;
} CAOEFScanlineExtent;

enum{
	CAOEF_OPT_DEV_NONE,
	CAOEF_OPT_DEV_TYPE1,
	CAOEF_OPT_DEV_TYPE2,		// V200-007(A)
};

enum{
	CAOEF_CALIB_NONE,
	CAOEF_CALIB_TYPE1,
	CAOEF_CALIB_TYPE2,
	CAOEF_CALIB_TYPE3,
	CAOEF_CALIB_TYPE4,		// V210-009(A)
	CAOEF_CALIB_TYPE4PLUS		// V240-002,007(A)
};

#if 0
V210-DT_011-003(D)
typedef struct{
	int bDuplexUnit;
	int nNumCassette;
}CAOpt1;
#endif

// Add Start V200-007
typedef struct{
	CAByte cthC;
	CAByte cthM;
	CAByte cthY;
	CAByte cthK;
}ColorThreshold;

typedef struct{
	ColorThreshold cth;
	CAByte darkColor;
	CAByte lightColor;
}ControlFlag;

typedef struct{
	ControlFlag fill;
	int Num;
}FillInfo;

typedef struct{
	ControlFlag largeText;
	ControlFlag smallText;
	int PointThreshold;
	int Num;
}TextInfo;

typedef struct{
	ControlFlag thickLine;
	ControlFlag thinLine;
	int WideThreshold;
	int Num;
}LineInfo;

typedef struct{
	ControlFlag imageBMP;
	ControlFlag edgeBMP;
	ControlFlag isolationBMP;
	int AreaThreshold;
	int Num;
}BMPInfo;	

typedef struct{
	int version;
	FillInfo fillInfo;
	TextInfo textInfo;
	LineInfo lineInfo;
	BMPInfo  bmpInfo;
	int AttrNum;
}CAOEF_DRAInterpCtrl;

typedef struct{
	int PageWidth;
	int shiftPointWidth;
	int shiftPointNum;
	signed char *BlackGap;
	signed char *YellowGap;
	signed char *MagentaGap;
	signed char *CyanGap;
}CAOEF_DRAShiftCtrl;

typedef struct{
	int bDuplexUnit;
	int nNumCassette;
	CAOEF_DRAInterpCtrl tInterpCtrl;
	CAOEF_DRAShiftCtrl	tShiftCtrl;
}CAOpt2;
// Add End V200-007

typedef struct{
	int nLinePixels;
	int nLength;
	int nInputType;
	int nRotate;
	char *pPaperSize;
}CAOEFInputParam;

enum{
	CAOEF_INPUT_TYPE_1P8B = 1,
	CAOEF_INPUT_TYPE_1P24B,
	CAOEF_INPUT_TYPE_4P1B,
	CAOEF_INPUT_TYPE_4P2B,
	CAOEF_INPUT_TYPE_4P4B,
	CAOEF_INPUT_TYPE_1P1B,
	CAOEF_INPUT_TYPE_1P2B,
	CAOEF_INPUT_TYPE_1P4B,
};

#define	CAOEF_PLANE_ORDER_KYCM	0x00
#define	CAOEF_PLANE_ORDER_CMYK	0x80

enum{
	CAOEF_IMG_ROTATE_0,
	CAOEF_IMG_ROTATE_90,
	CAOEF_IMG_ROTATE_180,
	CAOEF_IMG_ROTATE_270,
	CAOEF_IMG_ROTATE_FLT = 0xFF,
};

enum{
	CAOEF_SHORT_EDGE_FEED,
	CAOEF_LONG_EDGE_FEED,
};

#ifdef CAPT_DUMMY_API
int cacfStartJob(CACFObj *, CACFOptList *, int, int, CACFDev *);
int cacfEndJob(CACFObj *);
int cacfStartPage(CACFObj *, CACFInputParam *);
int cacfEndPage(CACFObj *);
int cacfRasterData(CACFObj *, CAByte *, int, int);
int cacfCancelJob(CACFObj *);
int cacfGetPaperFeed(CACFObj *, char *)
#else /* Linux UFR2 */
CAOEFObj* caoefInit(char *, int);
int caoefTerm(CAOEFObj *);
int caoefStartJob(CAOEFObj *, CAOEFOptList *, int, int, CAOEFDev *);
int caoefEndJob(CAOEFObj *);
int caoefStartPage(CAOEFObj *, CAOEFInputParam *);
int caoefEndPage(CAOEFObj *);
//int caoefRasterData(CAOEFObj *, CAByte *, int, int); /* v150 Modify caoefRasterData I/F */
int caoefRasterData(CAOEFObj *, CAByte *, int, int, int, CAOEFScanlineExtent *);
int caoefAttributeData(CAOEFObj *, CAByte *, int, int, int, CAOEFScanlineExtent*);	// V240-012(M)
int caoefCancelJob(CAOEFObj *);
//int caoefGetPaperFeed(CAOEFObj *, char *);

int caoefInterpData(CAOEFObj *, CAByte *, int, int, int, CAOEFScanlineExtent*);
#endif /* CAPT_DUMMY_API */

#endif
