/* $Id: dp_stream_stat.h,v 1.5 2004/02/20 01:59:48 andrewbaker Exp $ */
/*
** Copyright (C) 2001 Andrew R. Baker <andrewb@snort.org>
**
** This program is distributed under the terms of version 1.0 of the 
** Q Public License.  See LICENSE.QPL for further details.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
**
*/
 

#ifndef __DP_STREAM_STAT_H__
#define __DP_STREAM_STAT_H__

#include <sys/types.h>

#define STREAM_STAT_MAGIC  0xDEAD5747   /* dead alert (ok, so it's stupid) */

typedef struct _StreamStatFileHeader
{
    u_int32_t version_major;
    u_int32_t version_minor;
    u_int32_t timezone;
} StreamStatFileHeader;

typedef struct _StreamStatRecord
{
    u_int32_t start_time;
    u_int32_t end_time;
    u_int32_t server_ip;
    u_int32_t client_ip;
    u_int16_t server_port;
    u_int16_t client_port;
    u_int32_t server_packets;
    u_int32_t client_packets;
    u_int32_t server_bytes;
    u_int32_t client_bytes;
} StreamStatRecord;


void StreamStatDpInit();

#endif /* __DP_STREAM_STAT__H__ */
