/* $Id: dp_plugbase.h,v 1.7 2004/03/16 04:18:20 andrewbaker Exp $ */
/*
** Copyright (C) 2001-2002 Andrew R. Baker <andrewb@snort.org>
** Copyright (C) 2001 Martin Roesch <roesch@sourcefire.com>
**
** This program is distributed under the terms of version 1.0 of the 
** Q Public License.  See LICENSE.QPL for further details.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
**
*/

#ifndef __DB_PLUGBASE_H__
#define __DB_PLUGBASE_H__

#include <sys/types.h>
#include "plugbase.h"
#include "output-plugins/op_plugbase.h"
#include "spool.h"


typedef struct _DpContext
{
    void *file_header;
} DpContext;

typedef struct _DpFunctionalNode
{
    char *type;                   /* type name for output plugins to link on */
    int magic;                    /* magic number we want to see to operate */
    int (*readRecordFunc)(SpoolFileHandle *);
    int (*readFileHeaderFunc)(struct _DpFunctionalNode *, SpoolFileHandle *);
    int (*processRecordFunc)(void *, struct _DpFunctionalNode *);
    int (*headerCompareFunc)(struct _DpFunctionalNode *, void *, void *);
    DpContext context;            /* aux ptr to store "other" stuff */
	int started;
    OutputPluginListNode *oList;       /* list of output plugin's to call */
    struct _DpFunctionalNode *next;
} DpFunctionalNode;

typedef struct _DpRegistrationNode
{
    PluginInfo pi;
    char *name;
    char *type;
    void (*initFunc)(char *, DpFunctionalNode *);
    
    struct _DpRegistrationNode *next;
} DpRegistrationNode;

/* ------------------------ Exported Variables ------------------------*/
extern DpRegistrationNode *DpRegistrationList;

void SetupDataProcessors(void);

int DataProcessorSetup(char *, char *);
int DataProcessorExit(DpFunctionalNode *);
int DataProcessorStart(DpFunctionalNode *);
int DataProcessorStop(DpFunctionalNode *);
int DataProcessorRestart(DpFunctionalNode *);

void DpFuncs_LogOutputPluginConfigs(DpFunctionalNode *);
void RegisterDp(char *, void (*)(char *, DpFunctionalNode *), 
char *, PluginInfo *);
void RegisterDpReadRecord(int (*)(SpoolFileHandle *), DpFunctionalNode *);
void RegisterDpReadFileHeader(int (*)(DpFunctionalNode *, SpoolFileHandle *), 
			DpFunctionalNode *);
        
void RegisterDpProcessRecord(int (*)(void *, DpFunctionalNode *), 
		DpFunctionalNode *);
void RegisterDpHeaderCompare(int (*)(DpFunctionalNode *, void *, void *), 
        DpFunctionalNode *);



DpFunctionalNode *GetDpType(char *);
DpFunctionalNode *LookupFunctions(u_int32_t magic);

void LoadDataProcessors();

void FreeDpRegList(DpRegistrationNode *);
void FreeDpFuncList(DpFunctionalNode *);

#endif  /* __DP_PLUGBASE_H__ */
