/* $Id: dp_log.h,v 1.6 2004/04/03 19:57:32 andrewbaker Exp $ */
/*
** Copyright (C) 2001 Martin Roesch <roesch@sourcefire.com>
**
** This program is distributed under the terms of version 1.0 of the 
** Q Public License.  See LICENSE.QPL for further details.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
**
*/

#ifndef __DP_LOG_H__
#define __DP_LOG_H__

#include "event.h"
#include "barnyard.h"

#define LOG_MAGIC 0xDEAD1080

typedef struct _UnifiedLogFileHeader
{
    u_int16_t version_major;
    u_int16_t version_minor;
    u_int32_t timezone;
    u_int32_t sigfigs;
    u_int32_t snaplen;
    u_int32_t linktype;
} UnifiedLogFileHeader;

/* unified log packet header format 
 *
 * One of these per packet in the log file, the packets are appended in the 
 * file after each UnifiedLog header (extended pcap format) 
 */
typedef struct _UnifiedLog
{
    Event event;
    u_int32_t flags;       /* bitmap for interesting flags */
    SnortPktHeader pkth;   /* SnortPktHeader schtuff */
} UnifiedLog;


typedef struct _UnifiedLogRecord
{
    UnifiedLog log;
    u_int8_t pkt[4];
} UnifiedLogRecord;

void LogDpInit();

extern int linktype;

#endif /* __DP_LOG_H__ */
