/* $Id: event.h,v 1.3 2003/05/03 02:44:12 andrewbaker Exp $ */
/*
** Copyright (C) 1998-2001 Martin Roesch <roesch@clark.net>
**
** This program is distributed under the terms of version 1.0 of the 
** Q Public License.  See LICENSE.QPL for further details.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
**
*/

/*  D E F I N E S  ************************************************************/
#ifndef __EVENT_H__
#define __EVENT_H__

#include "config.h"
#include <sys/types.h>
#include <sys/time.h>

typedef struct _Event
{
    u_int32_t sig_generator;   /* which part of snort generated the alert? */
    u_int32_t sig_id;          /* sig id for this generator */
    u_int32_t sig_rev;         /* sig revision for this id */
    u_int32_t classification;  /* event classification */
    u_int32_t priority;        /* event priority */
    u_int32_t event_id;        /* event ID */
    u_int32_t event_reference; /* reference to other events that have gone off,
                                * such as in the case of tagged packets...
                                */
    struct timeval ref_time;   /* reference time for the event reference */
} Event;
#endif /* __EVENT_H__ */
