/* $Id: debug.h,v 1.3 2003/05/03 02:44:12 andrewbaker Exp $ */
/*
** Copyright (C) 1998-2001 Martin Roesch <roesch@clark.net>
**
** This program is distributed under the terms of version 1.0 of the 
** Q Public License.  See LICENSE.QPL for further details.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
**
*/


#ifndef __DEBUG_H__
#define __DEBUG_H__

#define DEBUG_VARIABLE "BARNYARD_DEBUG"

#define DEBUG_ALL             0xffff
#define DEBUG_INIT            0x00000001
#define DEBUG_REGISTRATION    0x00000002
#define DEBUG_PLUGIN          0x00000004
#define DEBUG_DECODE          0x00000040
#define DEBUG_LOG             0x00000080
#define DEBUG_MSTRING         0x00000100
#define DEBUG_PARSER          0x00000200
#define DEBUG_PLUGBASE        0x00000400
#define DEBUG_FLOW            0x00001000


#ifdef DEBUG

    extern char *DebugMessageFile;
    extern int DebugMessageLine;

#define    DebugMessage    DebugMessageFile = __FILE__; DebugMessageLine = __LINE__; DebugMessageFunc

    void DebugMessageFunc(int , char *, ...);

    int GetDebugLevel (void);

#else 

#ifdef WIN32
         /* Visual C++ uses the keyword "__inline" rather than "__inline__" */
         #define __inline__ __inline
#endif


static __inline__ void DebugMessage(int dbg,char *fmt, ...) {}

#endif /* DEBUG */


#endif /* __DEBUG_H__ */
