/*
** Copyright (C) 2004 Andrew R. Baker <andrewb@snort.org>
**
** This program is distributed under the terms of version 1.0 of the 
** Q Public License.  See LICENSE.QPL for further details.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
**
*/

#ifndef __COMMAND_LINE_ARGS_H__
#define __COMMAND_LINE_ARGS_H__

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <sys/types.h>
#include <stdio.h>

typedef struct _CommandLineArgs
{
    char *config_file;
    char *spool_dir;
    char *gen_msg_file;
    char *sid_msg_file;
    char *class_file;
    char *log_dir;
    char *archive_dir;
    char *file_base;
    char *waldo_file;
    char *pid_file;
    char **extra_args;
    int extra_args_count;

    u_int8_t verbosity;
    u_int8_t dry_run_flag;
    u_int8_t batch_mode_flag;
    u_int8_t daemon_flag;
    u_int8_t new_records_only_flag;
    u_int8_t usage_flag;
    u_int8_t version_flag;
} CommandLineArgs;

int CommandLineArgs_Parse(int argc, char **argv, CommandLineArgs **clargs);
int CommandLineArgs_Fprintf(CommandLineArgs *clargs, FILE *stream);
int CommandLineArgs_Validate(CommandLineArgs *clargs);
int CommandLineArgs_PrintUsage(FILE *stream);

#endif /* __COMMAND_LINE_ARGS_H__ */
