//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
#[cfg(feature = "objc2-core-foundation")]
use objc2_core_foundation::*;
use objc2_foundation::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/uipointeraccessoryposition?language=objc)
#[cfg(feature = "objc2-core-foundation")]
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct UIPointerAccessoryPosition {
    /// Offset from the primary pointer shape. Only allows positive values.
    pub offset: CGFloat,
    /// Clock-wise angle from top in radians.
    pub angle: CGFloat,
}

#[cfg(feature = "objc2-core-foundation")]
unsafe impl Encode for UIPointerAccessoryPosition {
    const ENCODING: Encoding = Encoding::Struct("?", &[<CGFloat>::ENCODING, <CGFloat>::ENCODING]);
}

#[cfg(feature = "objc2-core-foundation")]
unsafe impl RefEncode for UIPointerAccessoryPosition {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

#[cfg(feature = "objc2-core-foundation")]
unsafe impl Send for UIPointerAccessoryPosition {}

#[cfg(feature = "objc2-core-foundation")]
unsafe impl Sync for UIPointerAccessoryPosition {}

#[cfg(feature = "objc2-core-foundation")]
impl UIPointerAccessoryPosition {
    // TODO: pub fn UIPointerAccessoryPositionMake(offset: CGFloat,angle: CGFloat,) -> UIPointerAccessoryPosition;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uipointeraccessorypositiontop?language=objc)
    #[cfg(feature = "objc2-core-foundation")]
    pub static UIPointerAccessoryPositionTop: UIPointerAccessoryPosition;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uipointeraccessorypositiontopright?language=objc)
    #[cfg(feature = "objc2-core-foundation")]
    pub static UIPointerAccessoryPositionTopRight: UIPointerAccessoryPosition;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uipointeraccessorypositionright?language=objc)
    #[cfg(feature = "objc2-core-foundation")]
    pub static UIPointerAccessoryPositionRight: UIPointerAccessoryPosition;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uipointeraccessorypositionbottomright?language=objc)
    #[cfg(feature = "objc2-core-foundation")]
    pub static UIPointerAccessoryPositionBottomRight: UIPointerAccessoryPosition;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uipointeraccessorypositionbottom?language=objc)
    #[cfg(feature = "objc2-core-foundation")]
    pub static UIPointerAccessoryPositionBottom: UIPointerAccessoryPosition;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uipointeraccessorypositionbottomleft?language=objc)
    #[cfg(feature = "objc2-core-foundation")]
    pub static UIPointerAccessoryPositionBottomLeft: UIPointerAccessoryPosition;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uipointeraccessorypositionleft?language=objc)
    #[cfg(feature = "objc2-core-foundation")]
    pub static UIPointerAccessoryPositionLeft: UIPointerAccessoryPosition;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uipointeraccessorypositiontopleft?language=objc)
    #[cfg(feature = "objc2-core-foundation")]
    pub static UIPointerAccessoryPositionTopLeft: UIPointerAccessoryPosition;
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uipointeraccessory?language=objc)
    #[unsafe(super(NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct UIPointerAccessory;
);

extern_conformance!(
    unsafe impl NSCopying for UIPointerAccessory {}
);

unsafe impl CopyingHelper for UIPointerAccessory {
    type Result = Self;
}

extern_conformance!(
    unsafe impl NSObjectProtocol for UIPointerAccessory {}
);

impl UIPointerAccessory {
    extern_methods!(
        #[cfg(feature = "UIPointerStyle")]
        /// This accessory's shape.
        #[unsafe(method(shape))]
        #[unsafe(method_family = none)]
        pub unsafe fn shape(&self) -> Retained<UIPointerShape>;

        #[cfg(feature = "objc2-core-foundation")]
        /// This accessory shape's position relative to the pointer.
        #[unsafe(method(position))]
        #[unsafe(method_family = none)]
        pub unsafe fn position(&self) -> UIPointerAccessoryPosition;

        /// Indicates whether the accessory is rotated to match its angle.
        /// This is false by default for custom accessories, but varies for system vended ones.
        #[unsafe(method(orientationMatchesAngle))]
        #[unsafe(method_family = none)]
        pub unsafe fn orientationMatchesAngle(&self) -> bool;

        /// Setter for [`orientationMatchesAngle`][Self::orientationMatchesAngle].
        #[unsafe(method(setOrientationMatchesAngle:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setOrientationMatchesAngle(&self, orientation_matches_angle: bool);

        #[cfg(all(feature = "UIPointerStyle", feature = "objc2-core-foundation"))]
        /// Creates an accessory with the given pointer shape and position.
        ///
        ///
        /// Parameter `shape`: The desired accessory shape.
        ///
        /// Parameter `position`: The desired accessory position.
        #[unsafe(method(accessoryWithShape:position:))]
        #[unsafe(method_family = none)]
        pub unsafe fn accessoryWithShape_position(
            shape: &UIPointerShape,
            position: UIPointerAccessoryPosition,
        ) -> Retained<Self>;

        #[cfg(feature = "objc2-core-foundation")]
        /// Returns an arrow shaped accessory with the given position.
        #[unsafe(method(arrowAccessoryWithPosition:))]
        #[unsafe(method_family = none)]
        pub unsafe fn arrowAccessoryWithPosition(
            position: UIPointerAccessoryPosition,
            mtm: MainThreadMarker,
        ) -> Retained<Self>;

        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}
