#include <test_common.h>
#include <igl/isolines.h>
#include <igl/matlab_format.h>
#include <iostream>

TEST_CASE("isolines: broken-sphere", "[igl]" )
{
  // Test a case with edge-edge, edge-vertex, vertex-vertex, boundary edge, and
  // degenerate boundaries
  Eigen::MatrixXd V(42,3);
  V<<
        0,0.52573111211913359,0.85065080835203999,
    0,-0.52573111211913359,0.85065080835203999,
    0,0.52573111211913359,-0.85065080835203999,
    0,-0.52573111211913359,-0.85065080835203999,
    0.52573111211913359,0.85065080835203999,0,
    -0.52573111211913359,0.85065080835203999,0,
    0.52573111211913359,-0.85065080835203999,0,
    -0.52573111211913359,-0.85065080835203999,0,
    0.85065080835203999,0,0.52573111211913359,
    -0.85065080835203999,0,0.52573111211913359,
    0.85065080835203999,0,-0.52573111211913359,
    -0.85065080835203999,0,-0.52573111211913359,
    0,0,1,
    0.3090169943749474,0.80901699437494734,0.5,
    -0.3090169943749474,0.80901699437494734,0.5,
    0.5,0.3090169943749474,0.80901699437494734,
    -0.5,0.3090169943749474,0.80901699437494734,
    0.3090169943749474,-0.80901699437494734,0.5,
    -0.3090169943749474,-0.80901699437494734,0.5,
    0.5,-0.3090169943749474,0.80901699437494734,
    -0.5,-0.3090169943749474,0.80901699437494734,
    0,0,-1,
    0.3090169943749474,0.80901699437494734,-0.5,
    -0.3090169943749474,0.80901699437494734,-0.5,
    0.5,0.3090169943749474,-0.80901699437494734,
    -0.5,0.3090169943749474,-0.80901699437494734,
    0.3090169943749474,-0.80901699437494734,-0.5,
    -0.3090169943749474,-0.80901699437494734,-0.5,
    0.5,-0.3090169943749474,-0.80901699437494734,
    -0.5,-0.3090169943749474,-0.80901699437494734,
    0,1,0,
    0.80901699437494734,0.5,0.3090169943749474,
    0.80901699437494734,0.5,-0.3090169943749474,
    -0.80901699437494734,0.5,0.3090169943749474,
    -0.80901699437494734,0.5,-0.3090169943749474,
    0,-1,0,
    0.80901699437494734,-0.5,0.3090169943749474,
    0.80901699437494734,-0.5,-0.3090169943749474,
    -0.80901699437494734,-0.5,0.3090169943749474,
    -0.80901699437494734,-0.5,-0.3090169943749474,
    1,0,0,
    -1,0,0;
  Eigen::MatrixXi F(58,3);
  F <<
    0,12,15,
    0,15,13,
    0,13,14,
    0,14,16,
    0,16,12,
    8,40,31,
    4,32,22,
    4,22,30,
    5,23,34,
    5,34,33,
    1,18,17,
    3,26,27,
    8,31,15,
    4,30,13,
    5,33,14,
    9,20,16,
    6,36,17,
    6,37,36,
    10,32,40,
    10,24,32,
    2,23,22,
    2,25,23,
    11,41,34,
    7,18,38,
    7,35,18,
    6,35,26,
    7,39,27,
    11,25,29,
    2,24,21,
    8,15,19,
    4,13,31,
    5,14,30,
    9,16,33,
    4,31,32,
    2,22,24,
    5,30,23,
    11,34,25,
    9,33,41,
    7,38,39,
    6,17,35,
    7,27,35,
    2,21,25,
    10,28,24,
    6,26,37,
    19,15,12,
    31,13,15,
    30,14,13,
    33,16,14,
    20,12,16,
    32,31,40,
    24,22,32,
    23,30,22,
    25,34,23,
    41,33,34,
    35,17,18,
    35,27,26,
    25,21,29,
    24,28,21;
  Eigen::MatrixXd iV;
  Eigen::MatrixXi iE;
  Eigen::VectorXi I;
  Eigen::VectorXd vals(3);
  vals<<-0.5,0,0.5;
  igl::isolines(V,F,V.col(1).eval(),vals,iV,iE,I);
  Eigen::MatrixXd iV_gt(30,3);
  iV_gt<<
      0.809016994374947,-0.5, 0.309016994374947,
      0.809016994374947,-0.5,-0.309016994374947,
     -0.809016994374947,-0.5, 0.309016994374947,
     -0.809016994374947,-0.5,-0.309016994374947,
                    0.5,   0, 0.809016994374947,
                   -0.5,   0, 0.809016994374947,
                    0.5,   0,-0.809016994374947,
                   -0.5,   0,-0.809016994374947,
                      0,   0,                 1,
       0.85065080835204,   0, 0.525731112119134,
                      1,   0,                 0,
      -0.85065080835204,   0, 0.525731112119134,
       0.85065080835204,   0,-0.525731112119134,
      -0.85065080835204,   0,-0.525731112119134,
                     -1,   0,                 0,
                      0,   0,                -1,
                      0, 0.5, 0.857960478079794,
     0.0593664879495925, 0.5, 0.845707501720507,
    -0.0593664879495925, 0.5, 0.845707501720507,
                      0, 0.5,-0.857960478079794,
     0.0593664879495925, 0.5,-0.845707501720507,
    -0.0593664879495925, 0.5,-0.845707501720507,
      0.427050983124842, 0.5, 0.690983005625053,
     -0.427050983124842, 0.5, 0.690983005625052,
      0.427050983124842, 0.5,-0.690983005625053,
     -0.427050983124842, 0.5,-0.690983005625053,
      0.809016994374947, 0.5, 0.309016994374947,
      0.809016994374947, 0.5,-0.309016994374947,
     -0.809016994374947, 0.5,-0.309016994374947,
     -0.809016994374947, 0.5, 0.309016994374947;
  Eigen::MatrixXi iE_gt(28,2);
  iE_gt<<
     0, 1,
     3, 2,
     9,10,
    11, 5,
    10,12,
    13,14,
     7,13,
     4, 9,
    14,11,
    12, 6,
     8, 4,
     5, 8,
    15, 7,
     6,15,
    16,17,
    17,22,
    23,18,
    18,16,
    28,29,
    21,25,
    20,19,
    26,27,
    24,20,
    19,21,
    22,26,
    29,23,
    27,24,
    25,28;

  test_common::assert_near(iV,iV_gt,1e-15);
  test_common::assert_eq(iE,iE_gt);
}
