-- | The Bit module contains the Bit data type, which is essentially a
--   renamed Boolean, and some convenience functions.
module Bit (
  Bit(..)
  )
where

import Test.Tasty.QuickCheck (
  Arbitrary,
  arbitrary,
  elements )


data Bit = Zero | One
  deriving (Enum, Eq)

instance Show Bit where
  show Zero = "0"
  show One  = "1"


instance Arbitrary Bit where
  arbitrary = elements [ Zero, One ]


instance Ord Bit where
  Zero <= Zero = True
  Zero <= One  = True
  One  <= Zero = False
  One  <= One  = True

instance Bounded Bit where
  minBound = Zero
  maxBound = One
