<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

  <!-- FileName: idkey22 -->
  <!-- Document: http://www.w3.org/TR/xpath -->
  <!-- DocVersion: 19991116 -->
  <!-- Section: 4.1 -->
  <!-- Creator: David Marston (original idea sent in by user) -->
  <!-- Purpose: Test for id() in complex structure. -->

<xsl:template match="/">
  <out>
    <xsl:apply-templates/>
  </out>
</xsl:template>

<xsl:template match="doc">
  Test for id selection and pattern matching...
  Next line should read: -*id17*-    <!-- No id() either end -->
  <xsl:apply-templates select="c/b"/>
  Next line should read: (*id14*)    <!-- id() below but not here -->
  <xsl:apply-templates select="b/c"/>
  Next line should read: -*id4*-     <!-- id() here on apply but not below -->
  <xsl:apply-templates select="id('id4')"/>
  Next line should read: +*id9*+     <!-- id() same on both ends -->
  <xsl:apply-templates select="id('id9')"/>
  Next line should read: (*id13*)    <!-- simple id() here, path off top-level id() below -->
  <xsl:apply-templates select="id('id13')"/>
  Next line should read: -*id6*-     <!-- path off top-level id() here but not below -->
  <xsl:apply-templates select="id('id0')/a/b"/>
  Next line should read: @*id19*@    <!-- same path off top-level id() here and below -->
  <xsl:apply-templates select="id('id0')/c/c/a"/>
  Next line should read: %*id12*%    <!-- different paths off id() here and below -->
  <xsl:apply-templates select="id('id8')/b/b"/>
  Next line should read: !*id11*!    <!-- different paths off id(), middle here and top-level below -->
  <xsl:apply-templates select="id('id10')/a"/>
  Next line should read: [*id3*] \*id5*\ =*id16*=  <!-- union of id()-based paths -->
  <xsl:apply-templates select="id('id2')/a | id('id5') | id('id15')/a"/>
</xsl:template>

<!-- Now the templates for the specific cases -->

<xsl:template match="c">
  Error if this (c) template fires!
</xsl:template>

<xsl:template match="b">
  -<xsl:apply-templates/>-
</xsl:template>

<xsl:template match="id('id5')">
  \<xsl:apply-templates/>\
</xsl:template>

<xsl:template match="id('id9')">
  +<xsl:apply-templates/>+
</xsl:template>

<xsl:template match="id('id16')">
  =<xsl:apply-templates/>=
</xsl:template>

<xsl:template match="id('id0')/a/a/a">
  [<xsl:apply-templates/>]
</xsl:template>

<xsl:template match="id('id0')/b/b/a">
  !<xsl:apply-templates/>!
</xsl:template>

<xsl:template match="id('id0')/c/c/a">
  @<xsl:apply-templates/>@
</xsl:template>

<xsl:template match="id('id8')//b" priority="1">
  %<xsl:apply-templates/>%
</xsl:template>

<xsl:template match="id('id8')//c" priority="2">
  (<xsl:apply-templates/>)
</xsl:template>


  <!--
   * Licensed to the Apache Software Foundation (ASF) under one
   * or more contributor license agreements. See the NOTICE file
   * distributed with this work for additional information
   * regarding copyright ownership. The ASF licenses this file
   * to you under the Apache License, Version 2.0 (the  "License");
   * you may not use this file except in compliance with the License.
   * You may obtain a copy of the License at
   *
   *     http://www.apache.org/licenses/LICENSE-2.0
   *
   * Unless required by applicable law or agreed to in writing, software
   * distributed under the License is distributed on an "AS IS" BASIS,
   * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   * See the License for the specific language governing permissions and
   * limitations under the License.
  -->

</xsl:stylesheet>
