/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.resolver.internal.ant.types;

import org.apache.maven.resolver.internal.ant.org.apache.maven.model.Model;
import org.apache.maven.resolver.internal.ant.org.codehaus.plexus.interpolation.reflection.ReflectionValueExtractor;
import org.apache.tools.ant.Project;

class ModelValueExtractor {
    private static final String PREFIX_PROPERTIES = "properties.";
    private final String prefix;
    private final Project project;
    private final Model model;

    ModelValueExtractor(String prefix, Model model, Project project) {
        if (model == null) {
            throw new IllegalArgumentException("reference to Maven POM has not been specified");
        }
        if (project == null) {
            throw new IllegalArgumentException("reference to Ant project has not been specified");
        }
        if (prefix == null || prefix.length() <= 0) {
            prefix = "pom.";
        } else if (!prefix.endsWith(".")) {
            prefix = prefix + '.';
        }
        this.prefix = prefix;
        this.model = model;
        this.project = project;
    }

    public Project getProject() {
        return this.project;
    }

    public boolean isApplicable(String expression) {
        return expression.startsWith(this.prefix);
    }

    public Object getValue(String expression) {
        if (expression.startsWith(this.prefix)) {
            String expr = expression.substring(this.prefix.length());
            try {
                if (expr.startsWith(PREFIX_PROPERTIES)) {
                    String key = expr.substring(PREFIX_PROPERTIES.length());
                    return this.model.getProperties().getProperty(key);
                }
                return ReflectionValueExtractor.evaluate(expr, this.model, false);
            }
            catch (Exception e) {
                this.project.log("Could not retrieve '" + expression + "' from POM: " + e.getMessage(), (Throwable)e, 1);
                return null;
            }
        }
        return null;
    }
}

