/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.resolver.internal.ant.tasks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.resolver.internal.ant.org.eclipse.aether.artifact.Artifact;
import org.apache.tools.ant.BuildException;

class Layout {
    public static final String GID = "{groupId}";
    public static final String GID_DIRS = "{groupIdDirs}";
    public static final String AID = "{artifactId}";
    public static final String VER = "{version}";
    public static final String BVER = "{baseVersion}";
    public static final String EXT = "{extension}";
    public static final String CLS = "{classifier}";
    private String[] tokens;

    Layout(String layout) throws BuildException {
        HashSet<String> valid = new HashSet<String>(Arrays.asList(GID, GID_DIRS, AID, VER, BVER, EXT, CLS));
        ArrayList<String> tokens = new ArrayList<String>();
        Matcher m = Pattern.compile("(\\{[^}]*\\})|([^{]+)").matcher(layout);
        while (m.find()) {
            if (m.group(1) != null && !valid.contains(m.group(1))) {
                throw new BuildException("Invalid variable '" + m.group() + "' in layout, supported variables are " + new TreeSet<String>(valid));
            }
            tokens.add(m.group());
        }
        this.tokens = tokens.toArray(new String[tokens.size()]);
    }

    public String getPath(Artifact artifact) {
        StringBuilder buffer = new StringBuilder(128);
        for (int i = 0; i < this.tokens.length; ++i) {
            String token = this.tokens[i];
            if (GID.equals(token)) {
                buffer.append(artifact.getGroupId());
                continue;
            }
            if (GID_DIRS.equals(token)) {
                buffer.append(artifact.getGroupId().replace('.', '/'));
                continue;
            }
            if (AID.equals(token)) {
                buffer.append(artifact.getArtifactId());
                continue;
            }
            if (VER.equals(token)) {
                buffer.append(artifact.getVersion());
                continue;
            }
            if (BVER.equals(token)) {
                buffer.append(artifact.getBaseVersion());
                continue;
            }
            if (CLS.equals(token)) {
                if (artifact.getClassifier().length() <= 0) {
                    String lt;
                    if (i <= 0 || (lt = this.tokens[i - 1]).length() <= 0 || "-_".indexOf(lt.charAt(lt.length() - 1)) < 0) continue;
                    buffer.setLength(buffer.length() - 1);
                    continue;
                }
                buffer.append(artifact.getClassifier());
                continue;
            }
            if (EXT.equals(token)) {
                buffer.append(artifact.getExtension());
                continue;
            }
            buffer.append(token);
        }
        return buffer.toString();
    }
}

